/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackageMetadata;
import software.amazon.awssdk.services.tnb.model.NsdOnboardingState;
import software.amazon.awssdk.services.tnb.model.NsdOperationalState;
import software.amazon.awssdk.services.tnb.model.NsdUsageState;
import software.amazon.awssdk.services.tnb.model.VnfPkgIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolNetworkPackageInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListSolNetworkPackageInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::arn)).setter(ListSolNetworkPackageInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::id)).setter(ListSolNetworkPackageInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ListSolNetworkPackageMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::metadata)).setter(ListSolNetworkPackageInfo.setter(Builder::metadata)).constructor(ListSolNetworkPackageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NSD_DESIGNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdDesigner").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdDesigner)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdDesigner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdDesigner").build()}).build();
    private static final SdkField<String> NSD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdId").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdId)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()}).build();
    private static final SdkField<String> NSD_INVARIANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdInvariantId").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdInvariantId)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdInvariantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInvariantId").build()}).build();
    private static final SdkField<String> NSD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdName").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdName)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdName").build()}).build();
    private static final SdkField<String> NSD_ONBOARDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdOnboardingState").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdOnboardingStateAsString)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdOnboardingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOnboardingState").build()}).build();
    private static final SdkField<String> NSD_OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdOperationalState").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdOperationalStateAsString)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdOperationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdOperationalState").build()}).build();
    private static final SdkField<String> NSD_USAGE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdUsageState").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdUsageStateAsString)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdUsageState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdUsageState").build()}).build();
    private static final SdkField<String> NSD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdVersion").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::nsdVersion)).setter(ListSolNetworkPackageInfo.setter(Builder::nsdVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdVersion").build()}).build();
    private static final SdkField<List<String>> VNF_PKG_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vnfPkgIds").getter(ListSolNetworkPackageInfo.getter(ListSolNetworkPackageInfo::vnfPkgIds)).setter(ListSolNetworkPackageInfo.setter(Builder::vnfPkgIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, METADATA_FIELD, NSD_DESIGNER_FIELD, NSD_ID_FIELD, NSD_INVARIANT_ID_FIELD, NSD_NAME_FIELD, NSD_ONBOARDING_STATE_FIELD, NSD_OPERATIONAL_STATE_FIELD, NSD_USAGE_STATE_FIELD, NSD_VERSION_FIELD, VNF_PKG_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final ListSolNetworkPackageMetadata metadata;
    private final String nsdDesigner;
    private final String nsdId;
    private final String nsdInvariantId;
    private final String nsdName;
    private final String nsdOnboardingState;
    private final String nsdOperationalState;
    private final String nsdUsageState;
    private final String nsdVersion;
    private final List<String> vnfPkgIds;

    private ListSolNetworkPackageInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.nsdDesigner = builder.nsdDesigner;
        this.nsdId = builder.nsdId;
        this.nsdInvariantId = builder.nsdInvariantId;
        this.nsdName = builder.nsdName;
        this.nsdOnboardingState = builder.nsdOnboardingState;
        this.nsdOperationalState = builder.nsdOperationalState;
        this.nsdUsageState = builder.nsdUsageState;
        this.nsdVersion = builder.nsdVersion;
        this.vnfPkgIds = builder.vnfPkgIds;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final ListSolNetworkPackageMetadata metadata() {
        return this.metadata;
    }

    public final String nsdDesigner() {
        return this.nsdDesigner;
    }

    public final String nsdId() {
        return this.nsdId;
    }

    public final String nsdInvariantId() {
        return this.nsdInvariantId;
    }

    public final String nsdName() {
        return this.nsdName;
    }

    public final NsdOnboardingState nsdOnboardingState() {
        return NsdOnboardingState.fromValue(this.nsdOnboardingState);
    }

    public final String nsdOnboardingStateAsString() {
        return this.nsdOnboardingState;
    }

    public final NsdOperationalState nsdOperationalState() {
        return NsdOperationalState.fromValue(this.nsdOperationalState);
    }

    public final String nsdOperationalStateAsString() {
        return this.nsdOperationalState;
    }

    public final NsdUsageState nsdUsageState() {
        return NsdUsageState.fromValue(this.nsdUsageState);
    }

    public final String nsdUsageStateAsString() {
        return this.nsdUsageState;
    }

    public final String nsdVersion() {
        return this.nsdVersion;
    }

    public final boolean hasVnfPkgIds() {
        return this.vnfPkgIds != null && !(this.vnfPkgIds instanceof SdkAutoConstructList);
    }

    public final List<String> vnfPkgIds() {
        return this.vnfPkgIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdDesigner());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdInvariantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdOnboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdOperationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdUsageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVnfPkgIds() ? this.vnfPkgIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkPackageInfo)) {
            return false;
        }
        ListSolNetworkPackageInfo other = (ListSolNetworkPackageInfo)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsdDesigner(), other.nsdDesigner()) && Objects.equals(this.nsdId(), other.nsdId()) && Objects.equals(this.nsdInvariantId(), other.nsdInvariantId()) && Objects.equals(this.nsdName(), other.nsdName()) && Objects.equals(this.nsdOnboardingStateAsString(), other.nsdOnboardingStateAsString()) && Objects.equals(this.nsdOperationalStateAsString(), other.nsdOperationalStateAsString()) && Objects.equals(this.nsdUsageStateAsString(), other.nsdUsageStateAsString()) && Objects.equals(this.nsdVersion(), other.nsdVersion()) && this.hasVnfPkgIds() == other.hasVnfPkgIds() && Objects.equals(this.vnfPkgIds(), other.vnfPkgIds());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolNetworkPackageInfo").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Metadata", (Object)this.metadata()).add("NsdDesigner", (Object)this.nsdDesigner()).add("NsdId", (Object)this.nsdId()).add("NsdInvariantId", (Object)this.nsdInvariantId()).add("NsdName", (Object)this.nsdName()).add("NsdOnboardingState", (Object)this.nsdOnboardingStateAsString()).add("NsdOperationalState", (Object)this.nsdOperationalStateAsString()).add("NsdUsageState", (Object)this.nsdUsageStateAsString()).add("NsdVersion", (Object)this.nsdVersion()).add("VnfPkgIds", this.hasVnfPkgIds() ? this.vnfPkgIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsdDesigner": {
                return Optional.ofNullable(clazz.cast(this.nsdDesigner()));
            }
            case "nsdId": {
                return Optional.ofNullable(clazz.cast(this.nsdId()));
            }
            case "nsdInvariantId": {
                return Optional.ofNullable(clazz.cast(this.nsdInvariantId()));
            }
            case "nsdName": {
                return Optional.ofNullable(clazz.cast(this.nsdName()));
            }
            case "nsdOnboardingState": {
                return Optional.ofNullable(clazz.cast(this.nsdOnboardingStateAsString()));
            }
            case "nsdOperationalState": {
                return Optional.ofNullable(clazz.cast(this.nsdOperationalStateAsString()));
            }
            case "nsdUsageState": {
                return Optional.ofNullable(clazz.cast(this.nsdUsageStateAsString()));
            }
            case "nsdVersion": {
                return Optional.ofNullable(clazz.cast(this.nsdVersion()));
            }
            case "vnfPkgIds": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkPackageInfo, T> g) {
        return obj -> g.apply((ListSolNetworkPackageInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private ListSolNetworkPackageMetadata metadata;
        private String nsdDesigner;
        private String nsdId;
        private String nsdInvariantId;
        private String nsdName;
        private String nsdOnboardingState;
        private String nsdOperationalState;
        private String nsdUsageState;
        private String nsdVersion;
        private List<String> vnfPkgIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkPackageInfo model) {
            this.arn(model.arn);
            this.id(model.id);
            this.metadata(model.metadata);
            this.nsdDesigner(model.nsdDesigner);
            this.nsdId(model.nsdId);
            this.nsdInvariantId(model.nsdInvariantId);
            this.nsdName(model.nsdName);
            this.nsdOnboardingState(model.nsdOnboardingState);
            this.nsdOperationalState(model.nsdOperationalState);
            this.nsdUsageState(model.nsdUsageState);
            this.nsdVersion(model.nsdVersion);
            this.vnfPkgIds(model.vnfPkgIds);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ListSolNetworkPackageMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolNetworkPackageMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolNetworkPackageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsdDesigner() {
            return this.nsdDesigner;
        }

        public final void setNsdDesigner(String nsdDesigner) {
            this.nsdDesigner = nsdDesigner;
        }

        @Override
        public final Builder nsdDesigner(String nsdDesigner) {
            this.nsdDesigner = nsdDesigner;
            return this;
        }

        public final String getNsdId() {
            return this.nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdInvariantId() {
            return this.nsdInvariantId;
        }

        public final void setNsdInvariantId(String nsdInvariantId) {
            this.nsdInvariantId = nsdInvariantId;
        }

        @Override
        public final Builder nsdInvariantId(String nsdInvariantId) {
            this.nsdInvariantId = nsdInvariantId;
            return this;
        }

        public final String getNsdName() {
            return this.nsdName;
        }

        public final void setNsdName(String nsdName) {
            this.nsdName = nsdName;
        }

        @Override
        public final Builder nsdName(String nsdName) {
            this.nsdName = nsdName;
            return this;
        }

        public final String getNsdOnboardingState() {
            return this.nsdOnboardingState;
        }

        public final void setNsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
        }

        @Override
        public final Builder nsdOnboardingState(String nsdOnboardingState) {
            this.nsdOnboardingState = nsdOnboardingState;
            return this;
        }

        @Override
        public final Builder nsdOnboardingState(NsdOnboardingState nsdOnboardingState) {
            this.nsdOnboardingState(nsdOnboardingState == null ? null : nsdOnboardingState.toString());
            return this;
        }

        public final String getNsdOperationalState() {
            return this.nsdOperationalState;
        }

        public final void setNsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
        }

        @Override
        public final Builder nsdOperationalState(String nsdOperationalState) {
            this.nsdOperationalState = nsdOperationalState;
            return this;
        }

        @Override
        public final Builder nsdOperationalState(NsdOperationalState nsdOperationalState) {
            this.nsdOperationalState(nsdOperationalState == null ? null : nsdOperationalState.toString());
            return this;
        }

        public final String getNsdUsageState() {
            return this.nsdUsageState;
        }

        public final void setNsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
        }

        @Override
        public final Builder nsdUsageState(String nsdUsageState) {
            this.nsdUsageState = nsdUsageState;
            return this;
        }

        @Override
        public final Builder nsdUsageState(NsdUsageState nsdUsageState) {
            this.nsdUsageState(nsdUsageState == null ? null : nsdUsageState.toString());
            return this;
        }

        public final String getNsdVersion() {
            return this.nsdVersion;
        }

        public final void setNsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
        }

        @Override
        public final Builder nsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
            return this;
        }

        public final Collection<String> getVnfPkgIds() {
            if (this.vnfPkgIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vnfPkgIds;
        }

        public final void setVnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
        }

        @Override
        public final Builder vnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vnfPkgIds(String ... vnfPkgIds) {
            this.vnfPkgIds(Arrays.asList(vnfPkgIds));
            return this;
        }

        public ListSolNetworkPackageInfo build() {
            return new ListSolNetworkPackageInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListSolNetworkPackageInfo> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder metadata(ListSolNetworkPackageMetadata var1);

        default public Builder metadata(Consumer<ListSolNetworkPackageMetadata.Builder> metadata) {
            return this.metadata((ListSolNetworkPackageMetadata)((ListSolNetworkPackageMetadata.Builder)ListSolNetworkPackageMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsdDesigner(String var1);

        public Builder nsdId(String var1);

        public Builder nsdInvariantId(String var1);

        public Builder nsdName(String var1);

        public Builder nsdOnboardingState(String var1);

        public Builder nsdOnboardingState(NsdOnboardingState var1);

        public Builder nsdOperationalState(String var1);

        public Builder nsdOperationalState(NsdOperationalState var1);

        public Builder nsdUsageState(String var1);

        public Builder nsdUsageState(NsdUsageState var1);

        public Builder nsdVersion(String var1);

        public Builder vnfPkgIds(Collection<String> var1);

        public Builder vnfPkgIds(String ... var1);
    }
}

