/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.tnb.DefaultTnbBaseClientBuilder;
import software.amazon.awssdk.services.tnb.DefaultTnbClient;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.TnbClientBuilder;
import software.amazon.awssdk.services.tnb.TnbServiceClientConfiguration;
import software.amazon.awssdk.services.tnb.endpoints.TnbEndpointProvider;

@SdkInternalApi
final class DefaultTnbClientBuilder
extends DefaultTnbBaseClientBuilder<TnbClientBuilder, TnbClient>
implements TnbClientBuilder {
    DefaultTnbClientBuilder() {
    }

    @Override
    public DefaultTnbClientBuilder endpointProvider(TnbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TnbClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultTnbClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        TnbServiceClientConfiguration serviceClientConfiguration = TnbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultTnbClient(serviceClientConfiguration, clientConfiguration);
    }
}

