/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.model.AccessDeniedException;
import software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationRequest;
import software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.InternalServerException;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse;
import software.amazon.awssdk.services.tnb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.tnb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.tnb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.tnb.model.TagResourceRequest;
import software.amazon.awssdk.services.tnb.model.TagResourceResponse;
import software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.ThrottlingException;
import software.amazon.awssdk.services.tnb.model.TnbException;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.services.tnb.model.UntagResourceRequest;
import software.amazon.awssdk.services.tnb.model.UntagResourceResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ValidationException;
import software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable;
import software.amazon.awssdk.services.tnb.transform.CancelSolNetworkOperationRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.CreateSolFunctionPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.CreateSolNetworkInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.CreateSolNetworkPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.DeleteSolFunctionPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.DeleteSolNetworkInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.DeleteSolNetworkPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolFunctionInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolFunctionPackageContentRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolFunctionPackageDescriptorRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolFunctionPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolNetworkInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolNetworkOperationRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolNetworkPackageContentRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolNetworkPackageDescriptorRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.GetSolNetworkPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.InstantiateSolNetworkInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ListSolFunctionInstancesRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ListSolFunctionPackagesRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ListSolNetworkInstancesRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ListSolNetworkOperationsRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ListSolNetworkPackagesRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.PutSolFunctionPackageContentRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.PutSolNetworkPackageContentRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.TerminateSolNetworkInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.UpdateSolFunctionPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.UpdateSolNetworkInstanceRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.UpdateSolNetworkPackageRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ValidateSolFunctionPackageContentRequestMarshaller;
import software.amazon.awssdk.services.tnb.transform.ValidateSolNetworkPackageContentRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTnbClient
implements TnbClient {
    private static final Logger log = Logger.loggerFor(DefaultTnbClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTnbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelSolNetworkOperationResponse cancelSolNetworkOperation(CancelSolNetworkOperationRequest cancelSolNetworkOperationRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelSolNetworkOperationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, cancelSolNetworkOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelSolNetworkOperation");
            CancelSolNetworkOperationResponse cancelSolNetworkOperationResponse = (CancelSolNetworkOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelSolNetworkOperation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelSolNetworkOperationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelSolNetworkOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelSolNetworkOperationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$cancelSolNetworkOperation$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSolFunctionPackageResponse createSolFunctionPackage(CreateSolFunctionPackageRequest createSolFunctionPackageRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolFunctionPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, createSolFunctionPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSolFunctionPackage");
            CreateSolFunctionPackageResponse createSolFunctionPackageResponse = (CreateSolFunctionPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolFunctionPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolFunctionPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSolFunctionPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSolFunctionPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$createSolFunctionPackage$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSolNetworkInstanceResponse createSolNetworkInstance(CreateSolNetworkInstanceRequest createSolNetworkInstanceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolNetworkInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, createSolNetworkInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSolNetworkInstance");
            CreateSolNetworkInstanceResponse createSolNetworkInstanceResponse = (CreateSolNetworkInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolNetworkInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolNetworkInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSolNetworkInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSolNetworkInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$createSolNetworkInstance$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSolNetworkPackageResponse createSolNetworkPackage(CreateSolNetworkPackageRequest createSolNetworkPackageRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolNetworkPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, createSolNetworkPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSolNetworkPackage");
            CreateSolNetworkPackageResponse createSolNetworkPackageResponse = (CreateSolNetworkPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolNetworkPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolNetworkPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSolNetworkPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSolNetworkPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$createSolNetworkPackage$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSolFunctionPackageResponse deleteSolFunctionPackage(DeleteSolFunctionPackageRequest deleteSolFunctionPackageRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSolFunctionPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, deleteSolFunctionPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSolFunctionPackage");
            DeleteSolFunctionPackageResponse deleteSolFunctionPackageResponse = (DeleteSolFunctionPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSolFunctionPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSolFunctionPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSolFunctionPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSolFunctionPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$deleteSolFunctionPackage$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSolNetworkInstanceResponse deleteSolNetworkInstance(DeleteSolNetworkInstanceRequest deleteSolNetworkInstanceRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSolNetworkInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, deleteSolNetworkInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSolNetworkInstance");
            DeleteSolNetworkInstanceResponse deleteSolNetworkInstanceResponse = (DeleteSolNetworkInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSolNetworkInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSolNetworkInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSolNetworkInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSolNetworkInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$deleteSolNetworkInstance$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSolNetworkPackageResponse deleteSolNetworkPackage(DeleteSolNetworkPackageRequest deleteSolNetworkPackageRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSolNetworkPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, deleteSolNetworkPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSolNetworkPackage");
            DeleteSolNetworkPackageResponse deleteSolNetworkPackageResponse = (DeleteSolNetworkPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSolNetworkPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSolNetworkPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSolNetworkPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSolNetworkPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$deleteSolNetworkPackage$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolFunctionInstanceResponse getSolFunctionInstance(GetSolFunctionInstanceRequest getSolFunctionInstanceRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolFunctionInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolFunctionInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolFunctionInstance");
            GetSolFunctionInstanceResponse getSolFunctionInstanceResponse = (GetSolFunctionInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolFunctionInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolFunctionInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolFunctionInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolFunctionInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolFunctionInstance$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolFunctionPackageResponse getSolFunctionPackage(GetSolFunctionPackageRequest getSolFunctionPackageRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolFunctionPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolFunctionPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolFunctionPackage");
            GetSolFunctionPackageResponse getSolFunctionPackageResponse = (GetSolFunctionPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolFunctionPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolFunctionPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolFunctionPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolFunctionPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolFunctionPackage$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolFunctionPackageContentResponse getSolFunctionPackageContent(GetSolFunctionPackageContentRequest getSolFunctionPackageContentRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolFunctionPackageContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolFunctionPackageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolFunctionPackageContent");
            GetSolFunctionPackageContentResponse getSolFunctionPackageContentResponse = (GetSolFunctionPackageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolFunctionPackageContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolFunctionPackageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolFunctionPackageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolFunctionPackageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolFunctionPackageContent$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolFunctionPackageDescriptorResponse getSolFunctionPackageDescriptor(GetSolFunctionPackageDescriptorRequest getSolFunctionPackageDescriptorRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolFunctionPackageDescriptorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolFunctionPackageDescriptorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolFunctionPackageDescriptor");
            GetSolFunctionPackageDescriptorResponse getSolFunctionPackageDescriptorResponse = (GetSolFunctionPackageDescriptorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolFunctionPackageDescriptor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolFunctionPackageDescriptorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolFunctionPackageDescriptorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolFunctionPackageDescriptorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolFunctionPackageDescriptor$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolNetworkInstanceResponse getSolNetworkInstance(GetSolNetworkInstanceRequest getSolNetworkInstanceRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolNetworkInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolNetworkInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolNetworkInstance");
            GetSolNetworkInstanceResponse getSolNetworkInstanceResponse = (GetSolNetworkInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolNetworkInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolNetworkInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolNetworkInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolNetworkInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolNetworkInstance$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolNetworkOperationResponse getSolNetworkOperation(GetSolNetworkOperationRequest getSolNetworkOperationRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolNetworkOperationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolNetworkOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolNetworkOperation");
            GetSolNetworkOperationResponse getSolNetworkOperationResponse = (GetSolNetworkOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolNetworkOperation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolNetworkOperationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolNetworkOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolNetworkOperationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolNetworkOperation$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolNetworkPackageResponse getSolNetworkPackage(GetSolNetworkPackageRequest getSolNetworkPackageRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolNetworkPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolNetworkPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolNetworkPackage");
            GetSolNetworkPackageResponse getSolNetworkPackageResponse = (GetSolNetworkPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolNetworkPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolNetworkPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolNetworkPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolNetworkPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolNetworkPackage$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolNetworkPackageContentResponse getSolNetworkPackageContent(GetSolNetworkPackageContentRequest getSolNetworkPackageContentRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolNetworkPackageContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolNetworkPackageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolNetworkPackageContent");
            GetSolNetworkPackageContentResponse getSolNetworkPackageContentResponse = (GetSolNetworkPackageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolNetworkPackageContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolNetworkPackageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolNetworkPackageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolNetworkPackageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolNetworkPackageContent$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolNetworkPackageDescriptorResponse getSolNetworkPackageDescriptor(GetSolNetworkPackageDescriptorRequest getSolNetworkPackageDescriptorRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolNetworkPackageDescriptorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, getSolNetworkPackageDescriptorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolNetworkPackageDescriptor");
            GetSolNetworkPackageDescriptorResponse getSolNetworkPackageDescriptorResponse = (GetSolNetworkPackageDescriptorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolNetworkPackageDescriptor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolNetworkPackageDescriptorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolNetworkPackageDescriptorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolNetworkPackageDescriptorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$getSolNetworkPackageDescriptor$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstantiateSolNetworkInstanceResponse instantiateSolNetworkInstance(InstantiateSolNetworkInstanceRequest instantiateSolNetworkInstanceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InstantiateSolNetworkInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, instantiateSolNetworkInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InstantiateSolNetworkInstance");
            InstantiateSolNetworkInstanceResponse instantiateSolNetworkInstanceResponse = (InstantiateSolNetworkInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InstantiateSolNetworkInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)instantiateSolNetworkInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InstantiateSolNetworkInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return instantiateSolNetworkInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$instantiateSolNetworkInstance$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolFunctionInstancesResponse listSolFunctionInstances(ListSolFunctionInstancesRequest listSolFunctionInstancesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolFunctionInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, listSolFunctionInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolFunctionInstances");
            ListSolFunctionInstancesResponse listSolFunctionInstancesResponse = (ListSolFunctionInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolFunctionInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolFunctionInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolFunctionInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolFunctionInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$listSolFunctionInstances$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolFunctionInstancesIterable listSolFunctionInstancesPaginator(ListSolFunctionInstancesRequest listSolFunctionInstancesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolFunctionInstancesIterable(this, this.applyPaginatorUserAgent(listSolFunctionInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolFunctionPackagesResponse listSolFunctionPackages(ListSolFunctionPackagesRequest listSolFunctionPackagesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolFunctionPackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, listSolFunctionPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolFunctionPackages");
            ListSolFunctionPackagesResponse listSolFunctionPackagesResponse = (ListSolFunctionPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolFunctionPackages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolFunctionPackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolFunctionPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolFunctionPackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$listSolFunctionPackages$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolFunctionPackagesIterable listSolFunctionPackagesPaginator(ListSolFunctionPackagesRequest listSolFunctionPackagesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolFunctionPackagesIterable(this, this.applyPaginatorUserAgent(listSolFunctionPackagesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolNetworkInstancesResponse listSolNetworkInstances(ListSolNetworkInstancesRequest listSolNetworkInstancesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolNetworkInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, listSolNetworkInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolNetworkInstances");
            ListSolNetworkInstancesResponse listSolNetworkInstancesResponse = (ListSolNetworkInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolNetworkInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolNetworkInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolNetworkInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolNetworkInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$listSolNetworkInstances$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolNetworkInstancesIterable listSolNetworkInstancesPaginator(ListSolNetworkInstancesRequest listSolNetworkInstancesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolNetworkInstancesIterable(this, this.applyPaginatorUserAgent(listSolNetworkInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolNetworkOperationsResponse listSolNetworkOperations(ListSolNetworkOperationsRequest listSolNetworkOperationsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolNetworkOperationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, listSolNetworkOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolNetworkOperations");
            ListSolNetworkOperationsResponse listSolNetworkOperationsResponse = (ListSolNetworkOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolNetworkOperations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolNetworkOperationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolNetworkOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolNetworkOperationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$listSolNetworkOperations$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolNetworkOperationsIterable listSolNetworkOperationsPaginator(ListSolNetworkOperationsRequest listSolNetworkOperationsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolNetworkOperationsIterable(this, this.applyPaginatorUserAgent(listSolNetworkOperationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolNetworkPackagesResponse listSolNetworkPackages(ListSolNetworkPackagesRequest listSolNetworkPackagesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolNetworkPackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, listSolNetworkPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolNetworkPackages");
            ListSolNetworkPackagesResponse listSolNetworkPackagesResponse = (ListSolNetworkPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolNetworkPackages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolNetworkPackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolNetworkPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolNetworkPackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$listSolNetworkPackages$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolNetworkPackagesIterable listSolNetworkPackagesPaginator(ListSolNetworkPackagesRequest listSolNetworkPackagesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolNetworkPackagesIterable(this, this.applyPaginatorUserAgent(listSolNetworkPackagesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$listTagsForResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSolFunctionPackageContentResponse putSolFunctionPackageContent(PutSolFunctionPackageContentRequest putSolFunctionPackageContentRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSolFunctionPackageContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, putSolFunctionPackageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSolFunctionPackageContent");
            PutSolFunctionPackageContentResponse putSolFunctionPackageContentResponse = (PutSolFunctionPackageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSolFunctionPackageContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putSolFunctionPackageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSolFunctionPackageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSolFunctionPackageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$putSolFunctionPackageContent$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSolNetworkPackageContentResponse putSolNetworkPackageContent(PutSolNetworkPackageContentRequest putSolNetworkPackageContentRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSolNetworkPackageContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, putSolNetworkPackageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSolNetworkPackageContent");
            PutSolNetworkPackageContentResponse putSolNetworkPackageContentResponse = (PutSolNetworkPackageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSolNetworkPackageContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putSolNetworkPackageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSolNetworkPackageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSolNetworkPackageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$putSolNetworkPackageContent$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$tagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateSolNetworkInstanceResponse terminateSolNetworkInstance(TerminateSolNetworkInstanceRequest terminateSolNetworkInstanceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateSolNetworkInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, terminateSolNetworkInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateSolNetworkInstance");
            TerminateSolNetworkInstanceResponse terminateSolNetworkInstanceResponse = (TerminateSolNetworkInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateSolNetworkInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateSolNetworkInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateSolNetworkInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateSolNetworkInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$terminateSolNetworkInstance$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$untagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSolFunctionPackageResponse updateSolFunctionPackage(UpdateSolFunctionPackageRequest updateSolFunctionPackageRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSolFunctionPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, updateSolFunctionPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSolFunctionPackage");
            UpdateSolFunctionPackageResponse updateSolFunctionPackageResponse = (UpdateSolFunctionPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSolFunctionPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSolFunctionPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSolFunctionPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSolFunctionPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$updateSolFunctionPackage$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSolNetworkInstanceResponse updateSolNetworkInstance(UpdateSolNetworkInstanceRequest updateSolNetworkInstanceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSolNetworkInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, updateSolNetworkInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSolNetworkInstance");
            UpdateSolNetworkInstanceResponse updateSolNetworkInstanceResponse = (UpdateSolNetworkInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSolNetworkInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSolNetworkInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSolNetworkInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSolNetworkInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$updateSolNetworkInstance$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSolNetworkPackageResponse updateSolNetworkPackage(UpdateSolNetworkPackageRequest updateSolNetworkPackageRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSolNetworkPackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, updateSolNetworkPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSolNetworkPackage");
            UpdateSolNetworkPackageResponse updateSolNetworkPackageResponse = (UpdateSolNetworkPackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSolNetworkPackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSolNetworkPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSolNetworkPackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSolNetworkPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$updateSolNetworkPackage$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateSolFunctionPackageContentResponse validateSolFunctionPackageContent(ValidateSolFunctionPackageContentRequest validateSolFunctionPackageContentRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidateSolFunctionPackageContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, validateSolFunctionPackageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidateSolFunctionPackageContent");
            ValidateSolFunctionPackageContentResponse validateSolFunctionPackageContentResponse = (ValidateSolFunctionPackageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateSolFunctionPackageContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateSolFunctionPackageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ValidateSolFunctionPackageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return validateSolFunctionPackageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$validateSolFunctionPackageContent$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateSolNetworkPackageContentResponse validateSolNetworkPackageContent(ValidateSolNetworkPackageContentRequest validateSolNetworkPackageContentRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidateSolNetworkPackageContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTnbClient.resolveMetricPublishers(this.clientConfiguration, validateSolNetworkPackageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"tnb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidateSolNetworkPackageContent");
            ValidateSolNetworkPackageContentResponse validateSolNetworkPackageContentResponse = (ValidateSolNetworkPackageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateSolNetworkPackageContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateSolNetworkPackageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ValidateSolNetworkPackageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return validateSolNetworkPackageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTnbClient.lambda$validateSolNetworkPackageContent$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends TnbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.29").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TnbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "tnb";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TnbException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$validateSolNetworkPackageContent$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$validateSolFunctionPackageContent$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSolNetworkPackage$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSolNetworkInstance$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSolFunctionPackage$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateSolNetworkInstance$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSolNetworkPackageContent$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSolFunctionPackageContent$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolNetworkPackages$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolNetworkOperations$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolNetworkInstances$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolFunctionPackages$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolFunctionInstances$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$instantiateSolNetworkInstance$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolNetworkPackageDescriptor$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolNetworkPackageContent$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolNetworkPackage$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolNetworkOperation$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolNetworkInstance$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolFunctionPackageDescriptor$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolFunctionPackageContent$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolFunctionPackage$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolFunctionInstance$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSolNetworkPackage$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSolNetworkInstance$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSolFunctionPackage$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSolNetworkPackage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSolNetworkInstance$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSolFunctionPackage$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelSolNetworkOperation$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

