/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.tnb.model.AccessDeniedException;
import software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationRequest;
import software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.InternalServerException;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse;
import software.amazon.awssdk.services.tnb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.tnb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.tnb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.tnb.model.TagResourceRequest;
import software.amazon.awssdk.services.tnb.model.TagResourceResponse;
import software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.ThrottlingException;
import software.amazon.awssdk.services.tnb.model.TnbException;
import software.amazon.awssdk.services.tnb.model.UntagResourceRequest;
import software.amazon.awssdk.services.tnb.model.UntagResourceResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ValidationException;
import software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable;

/**
 * Service client for accessing AWS Telco Network Builder. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Web Services Telco Network Builder (TNB) is a network automation service that helps you deploy and manage
 * telecom networks. AWS TNB helps you with the lifecycle management of your telecommunication network functions
 * throughout planning, deployment, and post-deployment activities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TnbClient extends AwsClient {
    String SERVICE_NAME = "tnb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "tnb";

    /**
     * <p>
     * Cancels a network operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     *
     * @param cancelSolNetworkOperationRequest
     * @return Result of the CancelSolNetworkOperation operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CancelSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CancelSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSolNetworkOperationResponse cancelSolNetworkOperation(
            CancelSolNetworkOperationRequest cancelSolNetworkOperationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a network operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSolNetworkOperationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSolNetworkOperationRequest#builder()}
     * </p>
     *
     * @param cancelSolNetworkOperationRequest
     *        A {@link Consumer} that will call methods on {@link CancelSolNetworkOperationInput.Builder} to create a
     *        request.
     * @return Result of the CancelSolNetworkOperation operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CancelSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CancelSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSolNetworkOperationResponse cancelSolNetworkOperation(
            Consumer<CancelSolNetworkOperationRequest.Builder> cancelSolNetworkOperationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return cancelSolNetworkOperation(CancelSolNetworkOperationRequest.builder()
                .applyMutation(cancelSolNetworkOperationRequest).build());
    }

    /**
     * <p>
     * Creates a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html">Function packages</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty
     * container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload
     * function package content, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html"
     * >PutSolFunctionPackageContent</a>.
     * </p>
     *
     * @param createSolFunctionPackageRequest
     * @return Result of the CreateSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CreateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolFunctionPackageResponse createSolFunctionPackage(
            CreateSolFunctionPackageRequest createSolFunctionPackageRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html">Function packages</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty
     * container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload
     * function package content, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html"
     * >PutSolFunctionPackageContent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolFunctionPackageRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param createSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on {@link CreateSolFunctionPackageInput.Builder} to create a
     *        request.
     * @return Result of the CreateSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CreateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolFunctionPackageResponse createSolFunctionPackage(
            Consumer<CreateSolFunctionPackageRequest.Builder> createSolFunctionPackageRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return createSolFunctionPackage(CreateSolFunctionPackageRequest.builder().applyMutation(createSolFunctionPackageRequest)
                .build());
    }

    /**
     * <p>
     * Creates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the
     * third step after creating a network package. For more information about network instances, <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Once you create a network instance, you can instantiate it. To instantiate a network, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html"
     * >InstantiateSolNetworkInstance</a>.
     * </p>
     *
     * @param createSolNetworkInstanceRequest
     * @return Result of the CreateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CreateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolNetworkInstanceResponse createSolNetworkInstance(
            CreateSolNetworkInstanceRequest createSolNetworkInstanceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the
     * third step after creating a network package. For more information about network instances, <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Once you create a network instance, you can instantiate it. To instantiate a network, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html"
     * >InstantiateSolNetworkInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolNetworkInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param createSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateSolNetworkInstanceInput.Builder} to create a
     *        request.
     * @return Result of the CreateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CreateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolNetworkInstanceResponse createSolNetworkInstance(
            Consumer<CreateSolNetworkInstanceRequest.Builder> createSolNetworkInstanceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return createSolNetworkInstance(CreateSolNetworkInstanceRequest.builder().applyMutation(createSolNetworkInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * A network package consists of a network service descriptor (NSD) file (required) and any additional files
     * (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your
     * network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or
     * EKS clusters.
     * </p>
     * <p>
     * This request creates an empty network package container with an ID. Once you create a network package, you can
     * upload the network package content using <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html"
     * >PutSolNetworkPackageContent</a>.
     * </p>
     *
     * @param createSolNetworkPackageRequest
     * @return Result of the CreateSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CreateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolNetworkPackageResponse createSolNetworkPackage(CreateSolNetworkPackageRequest createSolNetworkPackageRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * A network package consists of a network service descriptor (NSD) file (required) and any additional files
     * (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your
     * network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or
     * EKS clusters.
     * </p>
     * <p>
     * This request creates an empty network package container with an ID. Once you create a network package, you can
     * upload the network package content using <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html"
     * >PutSolNetworkPackageContent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolNetworkPackageRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param createSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on {@link CreateSolNetworkPackageInput.Builder} to create a
     *        request.
     * @return Result of the CreateSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.CreateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolNetworkPackageResponse createSolNetworkPackage(
            Consumer<CreateSolNetworkPackageRequest.Builder> createSolNetworkPackageRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return createSolNetworkPackage(CreateSolNetworkPackageRequest.builder().applyMutation(createSolNetworkPackageRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <p>
     * To delete a function package, the package must be in a disabled state. To disable a function package, see <a
     * href=
     * "https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html">UpdateSolFunctionPackage
     * </a>.
     * </p>
     *
     * @param deleteSolFunctionPackageRequest
     * @return Result of the DeleteSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.DeleteSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolFunctionPackageResponse deleteSolFunctionPackage(
            DeleteSolFunctionPackageRequest deleteSolFunctionPackageRequest) throws InternalServerException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <p>
     * To delete a function package, the package must be in a disabled state. To disable a function package, see <a
     * href=
     * "https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html">UpdateSolFunctionPackage
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolFunctionPackageRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param deleteSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSolFunctionPackageInput.Builder} to create a
     *        request.
     * @return Result of the DeleteSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.DeleteSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolFunctionPackageResponse deleteSolFunctionPackage(
            Consumer<DeleteSolFunctionPackageRequest.Builder> deleteSolFunctionPackageRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return deleteSolFunctionPackage(DeleteSolFunctionPackageRequest.builder().applyMutation(deleteSolFunctionPackageRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network
     * instance, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html">
     * TerminateSolNetworkInstance</a>.
     * </p>
     *
     * @param deleteSolNetworkInstanceRequest
     * @return Result of the DeleteSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.DeleteSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolNetworkInstanceResponse deleteSolNetworkInstance(
            DeleteSolNetworkInstanceRequest deleteSolNetworkInstanceRequest) throws InternalServerException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network
     * instance, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html">
     * TerminateSolNetworkInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolNetworkInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param deleteSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSolNetworkInstanceInput.Builder} to create a
     *        request.
     * @return Result of the DeleteSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.DeleteSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolNetworkInstanceResponse deleteSolNetworkInstance(
            Consumer<DeleteSolNetworkInstanceRequest.Builder> deleteSolNetworkInstanceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return deleteSolNetworkInstance(DeleteSolNetworkInstanceRequest.builder().applyMutation(deleteSolNetworkInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * To delete a network package, the package must be in a disable state. To disable a network package, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html"
     * >UpdateSolNetworkPackage</a>.
     * </p>
     *
     * @param deleteSolNetworkPackageRequest
     * @return Result of the DeleteSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.DeleteSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolNetworkPackageResponse deleteSolNetworkPackage(DeleteSolNetworkPackageRequest deleteSolNetworkPackageRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * To delete a network package, the package must be in a disable state. To disable a network package, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html"
     * >UpdateSolNetworkPackage</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolNetworkPackageRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param deleteSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSolNetworkPackageInput.Builder} to create a
     *        request.
     * @return Result of the DeleteSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.DeleteSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolNetworkPackageResponse deleteSolNetworkPackage(
            Consumer<DeleteSolNetworkPackageRequest.Builder> deleteSolNetworkPackageRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return deleteSolNetworkPackage(DeleteSolNetworkPackageRequest.builder().applyMutation(deleteSolNetworkPackageRequest)
                .build());
    }

    /**
     * <p>
     * Gets the details of a network function instance, including the instantation state and metadata from the function
     * package descriptor in the network function package.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     *
     * @param getSolFunctionInstanceRequest
     * @return Result of the GetSolFunctionInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSolFunctionInstanceResponse getSolFunctionInstance(GetSolFunctionInstanceRequest getSolFunctionInstanceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a network function instance, including the instantation state and metadata from the function
     * package descriptor in the network function package.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolFunctionInstanceRequest#builder()}
     * </p>
     *
     * @param getSolFunctionInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetSolFunctionInstanceInput.Builder} to create a
     *        request.
     * @return Result of the GetSolFunctionInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSolFunctionInstanceResponse getSolFunctionInstance(
            Consumer<GetSolFunctionInstanceRequest.Builder> getSolFunctionInstanceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return getSolFunctionInstance(GetSolFunctionInstanceRequest.builder().applyMutation(getSolFunctionInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Gets the details of an individual function package, such as the operational state and whether the package is in
     * use.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network..
     * </p>
     *
     * @param getSolFunctionPackageRequest
     * @return Result of the GetSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSolFunctionPackageResponse getSolFunctionPackage(GetSolFunctionPackageRequest getSolFunctionPackageRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of an individual function package, such as the operational state and whether the package is in
     * use.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionPackageRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param getSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on {@link GetSolFunctionPackageInput.Builder} to create a
     *        request.
     * @return Result of the GetSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSolFunctionPackageResponse getSolFunctionPackage(
            Consumer<GetSolFunctionPackageRequest.Builder> getSolFunctionPackageRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return getSolFunctionPackage(GetSolFunctionPackageRequest.builder().applyMutation(getSolFunctionPackageRequest).build());
    }

    /**
     * <p>
     * Gets the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param getSolFunctionPackageContentRequest
     * @return Result of the GetSolFunctionPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolFunctionPackageContentResponse getSolFunctionPackageContent(
            GetSolFunctionPackageContentRequest getSolFunctionPackageContentRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolFunctionPackageContentRequest#builder()}
     * </p>
     *
     * @param getSolFunctionPackageContentRequest
     *        A {@link Consumer} that will call methods on {@link GetSolFunctionPackageContentInput.Builder} to create a
     *        request.
     * @return Result of the GetSolFunctionPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolFunctionPackageContentResponse getSolFunctionPackageContent(
            Consumer<GetSolFunctionPackageContentRequest.Builder> getSolFunctionPackageContentRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return getSolFunctionPackageContent(GetSolFunctionPackageContentRequest.builder()
                .applyMutation(getSolFunctionPackageContentRequest).build());
    }

    /**
     * <p>
     * Gets a function package descriptor in a function package.
     * </p>
     * <p>
     * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how
     * the network function in the function package should run on your network.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param getSolFunctionPackageDescriptorRequest
     * @return Result of the GetSolFunctionPackageDescriptor operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolFunctionPackageDescriptorResponse getSolFunctionPackageDescriptor(
            GetSolFunctionPackageDescriptorRequest getSolFunctionPackageDescriptorRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a function package descriptor in a function package.
     * </p>
     * <p>
     * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how
     * the network function in the function package should run on your network.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionPackageDescriptorRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolFunctionPackageDescriptorRequest#builder()}
     * </p>
     *
     * @param getSolFunctionPackageDescriptorRequest
     *        A {@link Consumer} that will call methods on {@link GetSolFunctionPackageDescriptorInput.Builder} to
     *        create a request.
     * @return Result of the GetSolFunctionPackageDescriptor operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolFunctionPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolFunctionPackageDescriptorResponse getSolFunctionPackageDescriptor(
            Consumer<GetSolFunctionPackageDescriptorRequest.Builder> getSolFunctionPackageDescriptorRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return getSolFunctionPackageDescriptor(GetSolFunctionPackageDescriptorRequest.builder()
                .applyMutation(getSolFunctionPackageDescriptorRequest).build());
    }

    /**
     * <p>
     * Gets the details of the network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     *
     * @param getSolNetworkInstanceRequest
     * @return Result of the GetSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSolNetworkInstanceResponse getSolNetworkInstance(GetSolNetworkInstanceRequest getSolNetworkInstanceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param getSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetSolNetworkInstanceInput.Builder} to create a
     *        request.
     * @return Result of the GetSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSolNetworkInstanceResponse getSolNetworkInstance(
            Consumer<GetSolNetworkInstanceRequest.Builder> getSolNetworkInstanceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return getSolNetworkInstance(GetSolNetworkInstanceRequest.builder().applyMutation(getSolNetworkInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the details of a network operation, including the tasks involved in the network operation and the status of
     * the tasks.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     *
     * @param getSolNetworkOperationRequest
     * @return Result of the GetSolNetworkOperation operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSolNetworkOperationResponse getSolNetworkOperation(GetSolNetworkOperationRequest getSolNetworkOperationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a network operation, including the tasks involved in the network operation and the status of
     * the tasks.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkOperationRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolNetworkOperationRequest#builder()}
     * </p>
     *
     * @param getSolNetworkOperationRequest
     *        A {@link Consumer} that will call methods on {@link GetSolNetworkOperationInput.Builder} to create a
     *        request.
     * @return Result of the GetSolNetworkOperation operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSolNetworkOperationResponse getSolNetworkOperation(
            Consumer<GetSolNetworkOperationRequest.Builder> getSolNetworkOperationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return getSolNetworkOperation(GetSolNetworkOperationRequest.builder().applyMutation(getSolNetworkOperationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the details of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param getSolNetworkPackageRequest
     * @return Result of the GetSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSolNetworkPackageResponse getSolNetworkPackage(GetSolNetworkPackageRequest getSolNetworkPackageRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkPackageRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param getSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on {@link GetSolNetworkPackageInput.Builder} to create a
     *        request.
     * @return Result of the GetSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSolNetworkPackageResponse getSolNetworkPackage(
            Consumer<GetSolNetworkPackageRequest.Builder> getSolNetworkPackageRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return getSolNetworkPackage(GetSolNetworkPackageRequest.builder().applyMutation(getSolNetworkPackageRequest).build());
    }

    /**
     * <p>
     * Gets the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param getSolNetworkPackageContentRequest
     * @return Result of the GetSolNetworkPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolNetworkPackageContentResponse getSolNetworkPackageContent(
            GetSolNetworkPackageContentRequest getSolNetworkPackageContentRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolNetworkPackageContentRequest#builder()}
     * </p>
     *
     * @param getSolNetworkPackageContentRequest
     *        A {@link Consumer} that will call methods on {@link GetSolNetworkPackageContentInput.Builder} to create a
     *        request.
     * @return Result of the GetSolNetworkPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolNetworkPackageContentResponse getSolNetworkPackageContent(
            Consumer<GetSolNetworkPackageContentRequest.Builder> getSolNetworkPackageContentRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return getSolNetworkPackageContent(GetSolNetworkPackageContentRequest.builder()
                .applyMutation(getSolNetworkPackageContentRequest).build());
    }

    /**
     * <p>
     * Gets the content of the network service descriptor.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     *
     * @param getSolNetworkPackageDescriptorRequest
     * @return Result of the GetSolNetworkPackageDescriptor operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolNetworkPackageDescriptorResponse getSolNetworkPackageDescriptor(
            GetSolNetworkPackageDescriptorRequest getSolNetworkPackageDescriptorRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the content of the network service descriptor.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkPackageDescriptorRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolNetworkPackageDescriptorRequest#builder()}
     * </p>
     *
     * @param getSolNetworkPackageDescriptorRequest
     *        A {@link Consumer} that will call methods on {@link GetSolNetworkPackageDescriptorInput.Builder} to create
     *        a request.
     * @return Result of the GetSolNetworkPackageDescriptor operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.GetSolNetworkPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolNetworkPackageDescriptorResponse getSolNetworkPackageDescriptor(
            Consumer<GetSolNetworkPackageDescriptorRequest.Builder> getSolNetworkPackageDescriptorRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return getSolNetworkPackageDescriptor(GetSolNetworkPackageDescriptorRequest.builder()
                .applyMutation(getSolNetworkPackageDescriptorRequest).build());
    }

    /**
     * <p>
     * Instantiates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * Before you can instantiate a network instance, you have to create a network instance. For more information, see
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html">
     * CreateSolNetworkInstance</a>.
     * </p>
     *
     * @param instantiateSolNetworkInstanceRequest
     * @return Result of the InstantiateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.InstantiateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/InstantiateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default InstantiateSolNetworkInstanceResponse instantiateSolNetworkInstance(
            InstantiateSolNetworkInstanceRequest instantiateSolNetworkInstanceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instantiates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * Before you can instantiate a network instance, you have to create a network instance. For more information, see
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html">
     * CreateSolNetworkInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InstantiateSolNetworkInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link InstantiateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param instantiateSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on {@link InstantiateSolNetworkInstanceInput.Builder} to create
     *        a request.
     * @return Result of the InstantiateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.InstantiateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/InstantiateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default InstantiateSolNetworkInstanceResponse instantiateSolNetworkInstance(
            Consumer<InstantiateSolNetworkInstanceRequest.Builder> instantiateSolNetworkInstanceRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return instantiateSolNetworkInstance(InstantiateSolNetworkInstanceRequest.builder()
                .applyMutation(instantiateSolNetworkInstanceRequest).build());
    }

    /**
     * <p>
     * Lists network function instances.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     * @return Result of the ListSolFunctionInstances operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionInstancesResponse listSolFunctionInstances(
            ListSolFunctionInstancesRequest listSolFunctionInstancesRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network function instances.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionInstancesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolFunctionInstancesInput.Builder} to create a
     *        request.
     * @return Result of the ListSolFunctionInstances operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionInstancesResponse listSolFunctionInstances(
            Consumer<ListSolFunctionInstancesRequest.Builder> listSolFunctionInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolFunctionInstances(ListSolFunctionInstancesRequest.builder().applyMutation(listSolFunctionInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Lists network function instances.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable responses = client.listSolFunctionInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable responses = client
     *             .listSolFunctionInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable responses = client.listSolFunctionInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionInstancesIterable listSolFunctionInstancesPaginator(
            ListSolFunctionInstancesRequest listSolFunctionInstancesRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolFunctionInstancesIterable(this, listSolFunctionInstancesRequest);
    }

    /**
     * <p>
     * Lists network function instances.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable responses = client.listSolFunctionInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable responses = client
     *             .listSolFunctionInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesIterable responses = client.listSolFunctionInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionInstancesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolFunctionInstancesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionInstancesIterable listSolFunctionInstancesPaginator(
            Consumer<ListSolFunctionInstancesRequest.Builder> listSolFunctionInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolFunctionInstancesPaginator(ListSolFunctionInstancesRequest.builder()
                .applyMutation(listSolFunctionInstancesRequest).build());
    }

    /**
     * <p>
     * Lists information about function packages.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     * @return Result of the ListSolFunctionPackages operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionPackagesResponse listSolFunctionPackages(ListSolFunctionPackagesRequest listSolFunctionPackagesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about function packages.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionPackagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionPackagesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolFunctionPackagesInput.Builder} to create a
     *        request.
     * @return Result of the ListSolFunctionPackages operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionPackagesResponse listSolFunctionPackages(
            Consumer<ListSolFunctionPackagesRequest.Builder> listSolFunctionPackagesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolFunctionPackages(ListSolFunctionPackagesRequest.builder().applyMutation(listSolFunctionPackagesRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about function packages.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable responses = client.listSolFunctionPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable responses = client
     *             .listSolFunctionPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable responses = client.listSolFunctionPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionPackagesIterable listSolFunctionPackagesPaginator(
            ListSolFunctionPackagesRequest listSolFunctionPackagesRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolFunctionPackagesIterable(this, listSolFunctionPackagesRequest);
    }

    /**
     * <p>
     * Lists information about function packages.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable responses = client.listSolFunctionPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable responses = client
     *             .listSolFunctionPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesIterable responses = client.listSolFunctionPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionPackagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionPackagesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolFunctionPackagesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionPackagesIterable listSolFunctionPackagesPaginator(
            Consumer<ListSolFunctionPackagesRequest.Builder> listSolFunctionPackagesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolFunctionPackagesPaginator(ListSolFunctionPackagesRequest.builder()
                .applyMutation(listSolFunctionPackagesRequest).build());
    }

    /**
     * <p>
     * Lists your network instances.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     * @return Result of the ListSolNetworkInstances operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkInstancesResponse listSolNetworkInstances(ListSolNetworkInstancesRequest listSolNetworkInstancesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your network instances.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkInstancesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolNetworkInstancesInput.Builder} to create a
     *        request.
     * @return Result of the ListSolNetworkInstances operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkInstancesResponse listSolNetworkInstances(
            Consumer<ListSolNetworkInstancesRequest.Builder> listSolNetworkInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolNetworkInstances(ListSolNetworkInstancesRequest.builder().applyMutation(listSolNetworkInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Lists your network instances.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable responses = client.listSolNetworkInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable responses = client
     *             .listSolNetworkInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable responses = client.listSolNetworkInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkInstancesIterable listSolNetworkInstancesPaginator(
            ListSolNetworkInstancesRequest listSolNetworkInstancesRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolNetworkInstancesIterable(this, listSolNetworkInstancesRequest);
    }

    /**
     * <p>
     * Lists your network instances.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable responses = client.listSolNetworkInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable responses = client
     *             .listSolNetworkInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesIterable responses = client.listSolNetworkInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkInstancesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolNetworkInstancesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkInstancesIterable listSolNetworkInstancesPaginator(
            Consumer<ListSolNetworkInstancesRequest.Builder> listSolNetworkInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolNetworkInstancesPaginator(ListSolNetworkInstancesRequest.builder()
                .applyMutation(listSolNetworkInstancesRequest).build());
    }

    /**
     * <p>
     * Lists details for a network operation, including when the operation started and the status of the operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     * @return Result of the ListSolNetworkOperations operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkOperationsResponse listSolNetworkOperations(
            ListSolNetworkOperationsRequest listSolNetworkOperationsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details for a network operation, including when the operation started and the status of the operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkOperationsRequest#builder()}
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSolNetworkOperationsInput.Builder} to create a
     *        request.
     * @return Result of the ListSolNetworkOperations operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkOperationsResponse listSolNetworkOperations(
            Consumer<ListSolNetworkOperationsRequest.Builder> listSolNetworkOperationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolNetworkOperations(ListSolNetworkOperationsRequest.builder().applyMutation(listSolNetworkOperationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists details for a network operation, including when the operation started and the status of the operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable responses = client.listSolNetworkOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable responses = client
     *             .listSolNetworkOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable responses = client.listSolNetworkOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkOperationsIterable listSolNetworkOperationsPaginator(
            ListSolNetworkOperationsRequest listSolNetworkOperationsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolNetworkOperationsIterable(this, listSolNetworkOperationsRequest);
    }

    /**
     * <p>
     * Lists details for a network operation, including when the operation started and the status of the operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable responses = client.listSolNetworkOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable responses = client
     *             .listSolNetworkOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsIterable responses = client.listSolNetworkOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkOperationsRequest#builder()}
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSolNetworkOperationsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkOperationsIterable listSolNetworkOperationsPaginator(
            Consumer<ListSolNetworkOperationsRequest.Builder> listSolNetworkOperationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolNetworkOperationsPaginator(ListSolNetworkOperationsRequest.builder()
                .applyMutation(listSolNetworkOperationsRequest).build());
    }

    /**
     * <p>
     * Lists network packages.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     * @return Result of the ListSolNetworkPackages operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkPackagesResponse listSolNetworkPackages(ListSolNetworkPackagesRequest listSolNetworkPackagesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network packages.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkPackagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSolNetworkPackagesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolNetworkPackagesInput.Builder} to create a
     *        request.
     * @return Result of the ListSolNetworkPackages operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkPackagesResponse listSolNetworkPackages(
            Consumer<ListSolNetworkPackagesRequest.Builder> listSolNetworkPackagesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolNetworkPackages(ListSolNetworkPackagesRequest.builder().applyMutation(listSolNetworkPackagesRequest)
                .build());
    }

    /**
     * <p>
     * Lists network packages.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable responses = client.listSolNetworkPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable responses = client
     *             .listSolNetworkPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable responses = client.listSolNetworkPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkPackagesIterable listSolNetworkPackagesPaginator(
            ListSolNetworkPackagesRequest listSolNetworkPackagesRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return new ListSolNetworkPackagesIterable(this, listSolNetworkPackagesRequest);
    }

    /**
     * <p>
     * Lists network packages.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable responses = client.listSolNetworkPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable responses = client
     *             .listSolNetworkPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesIterable responses = client.listSolNetworkPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkPackagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSolNetworkPackagesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListSolNetworkPackagesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkPackagesIterable listSolNetworkPackagesPaginator(
            Consumer<ListSolNetworkPackagesRequest.Builder> listSolNetworkPackagesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        return listSolNetworkPackagesPaginator(ListSolNetworkPackagesRequest.builder()
                .applyMutation(listSolNetworkPackagesRequest).build());
    }

    /**
     * <p>
     * Lists tags for AWS TNB resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for AWS TNB resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Uploads the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param putSolFunctionPackageContentRequest
     * @return Result of the PutSolFunctionPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.PutSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSolFunctionPackageContentResponse putSolFunctionPackageContent(
            PutSolFunctionPackageContentRequest putSolFunctionPackageContentRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSolFunctionPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link PutSolFunctionPackageContentRequest#builder()}
     * </p>
     *
     * @param putSolFunctionPackageContentRequest
     *        A {@link Consumer} that will call methods on {@link PutSolFunctionPackageContentInput.Builder} to create a
     *        request.
     * @return Result of the PutSolFunctionPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.PutSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSolFunctionPackageContentResponse putSolFunctionPackageContent(
            Consumer<PutSolFunctionPackageContentRequest.Builder> putSolFunctionPackageContentRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return putSolFunctionPackageContent(PutSolFunctionPackageContentRequest.builder()
                .applyMutation(putSolFunctionPackageContentRequest).build());
    }

    /**
     * <p>
     * Uploads the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param putSolNetworkPackageContentRequest
     * @return Result of the PutSolNetworkPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.PutSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSolNetworkPackageContentResponse putSolNetworkPackageContent(
            PutSolNetworkPackageContentRequest putSolNetworkPackageContentRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSolNetworkPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link PutSolNetworkPackageContentRequest#builder()}
     * </p>
     *
     * @param putSolNetworkPackageContentRequest
     *        A {@link Consumer} that will call methods on {@link PutSolNetworkPackageContentInput.Builder} to create a
     *        request.
     * @return Result of the PutSolNetworkPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.PutSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSolNetworkPackageContentResponse putSolNetworkPackageContent(
            Consumer<PutSolNetworkPackageContentRequest.Builder> putSolNetworkPackageContentRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return putSolNetworkPackageContent(PutSolNetworkPackageContentRequest.builder()
                .applyMutation(putSolNetworkPackageContentRequest).build());
    }

    /**
     * <p>
     * Tags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Terminates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * You must terminate a network instance before you can delete it.
     * </p>
     *
     * @param terminateSolNetworkInstanceRequest
     * @return Result of the TerminateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.TerminateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TerminateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateSolNetworkInstanceResponse terminateSolNetworkInstance(
            TerminateSolNetworkInstanceRequest terminateSolNetworkInstanceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * You must terminate a network instance before you can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateSolNetworkInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param terminateSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on {@link TerminateSolNetworkInstanceInput.Builder} to create a
     *        request.
     * @return Result of the TerminateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.TerminateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TerminateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateSolNetworkInstanceResponse terminateSolNetworkInstance(
            Consumer<TerminateSolNetworkInstanceRequest.Builder> terminateSolNetworkInstanceRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return terminateSolNetworkInstance(TerminateSolNetworkInstanceRequest.builder()
                .applyMutation(terminateSolNetworkInstanceRequest).build());
    }

    /**
     * <p>
     * Untags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the operational state of function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param updateSolFunctionPackageRequest
     * @return Result of the UpdateSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UpdateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSolFunctionPackageResponse updateSolFunctionPackage(
            UpdateSolFunctionPackageRequest updateSolFunctionPackageRequest) throws InternalServerException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the operational state of function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSolFunctionPackageRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param updateSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSolFunctionPackageInput.Builder} to create a
     *        request.
     * @return Result of the UpdateSolFunctionPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UpdateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSolFunctionPackageResponse updateSolFunctionPackage(
            Consumer<UpdateSolFunctionPackageRequest.Builder> updateSolFunctionPackageRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return updateSolFunctionPackage(UpdateSolFunctionPackageRequest.builder().applyMutation(updateSolFunctionPackageRequest)
                .build());
    }

    /**
     * <p>
     * Update a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     *
     * @param updateSolNetworkInstanceRequest
     * @return Result of the UpdateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UpdateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSolNetworkInstanceResponse updateSolNetworkInstance(
            UpdateSolNetworkInstanceRequest updateSolNetworkInstanceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSolNetworkInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param updateSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSolNetworkInstanceInput.Builder} to create a
     *        request.
     * @return Result of the UpdateSolNetworkInstance operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ServiceQuotaExceededException
     *         Service quotas have been exceeded.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UpdateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSolNetworkInstanceResponse updateSolNetworkInstance(
            Consumer<UpdateSolNetworkInstanceRequest.Builder> updateSolNetworkInstanceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return updateSolNetworkInstance(UpdateSolNetworkInstanceRequest.builder().applyMutation(updateSolNetworkInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Updates the operational state of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     *
     * @param updateSolNetworkPackageRequest
     * @return Result of the UpdateSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UpdateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSolNetworkPackageResponse updateSolNetworkPackage(UpdateSolNetworkPackageRequest updateSolNetworkPackageRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the operational state of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSolNetworkPackageRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param updateSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSolNetworkPackageInput.Builder} to create a
     *        request.
     * @return Result of the UpdateSolNetworkPackage operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.UpdateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSolNetworkPackageResponse updateSolNetworkPackage(
            Consumer<UpdateSolNetworkPackageRequest.Builder> updateSolNetworkPackageRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        return updateSolNetworkPackage(UpdateSolNetworkPackageRequest.builder().applyMutation(updateSolNetworkPackageRequest)
                .build());
    }

    /**
     * <p>
     * Validates function package content. This can be used as a dry run before uploading function package content with
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html">
     * PutSolFunctionPackageContent</a>.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param validateSolFunctionPackageContentRequest
     * @return Result of the ValidateSolFunctionPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ValidateSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateSolFunctionPackageContentResponse validateSolFunctionPackageContent(
            ValidateSolFunctionPackageContentRequest validateSolFunctionPackageContentRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates function package content. This can be used as a dry run before uploading function package content with
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html">
     * PutSolFunctionPackageContent</a>.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateSolFunctionPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateSolFunctionPackageContentRequest#builder()}
     * </p>
     *
     * @param validateSolFunctionPackageContentRequest
     *        A {@link Consumer} that will call methods on {@link ValidateSolFunctionPackageContentInput.Builder} to
     *        create a request.
     * @return Result of the ValidateSolFunctionPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ValidateSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateSolFunctionPackageContentResponse validateSolFunctionPackageContent(
            Consumer<ValidateSolFunctionPackageContentRequest.Builder> validateSolFunctionPackageContentRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return validateSolFunctionPackageContent(ValidateSolFunctionPackageContentRequest.builder()
                .applyMutation(validateSolFunctionPackageContentRequest).build());
    }

    /**
     * <p>
     * Validates network package content. This can be used as a dry run before uploading network package content with <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html">
     * PutSolNetworkPackageContent</a>.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param validateSolNetworkPackageContentRequest
     * @return Result of the ValidateSolNetworkPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ValidateSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateSolNetworkPackageContentResponse validateSolNetworkPackageContent(
            ValidateSolNetworkPackageContentRequest validateSolNetworkPackageContentRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, TnbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates network package content. This can be used as a dry run before uploading network package content with <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html">
     * PutSolNetworkPackageContent</a>.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateSolNetworkPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateSolNetworkPackageContentRequest#builder()}
     * </p>
     *
     * @param validateSolNetworkPackageContentRequest
     *        A {@link Consumer} that will call methods on {@link ValidateSolNetworkPackageContentInput.Builder} to
     *        create a request.
     * @return Result of the ValidateSolNetworkPackageContent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error occurred. Problem on the server.
     * @throws ThrottlingException
     *         Exception caused by throttling.
     * @throws ValidationException
     *         Unable to process the request because the client provided input failed to satisfy request constraints.
     * @throws ResourceNotFoundException
     *         Request references a resource that doesn't exist.
     * @throws AccessDeniedException
     *         Insufficient permissions to make request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TnbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TnbClient.ValidateSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateSolNetworkPackageContentResponse validateSolNetworkPackageContent(
            Consumer<ValidateSolNetworkPackageContentRequest.Builder> validateSolNetworkPackageContentRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, TnbException {
        return validateSolNetworkPackageContent(ValidateSolNetworkPackageContentRequest.builder()
                .applyMutation(validateSolNetworkPackageContentRequest).build());
    }

    /**
     * Create a {@link TnbClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TnbClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TnbClient}.
     */
    static TnbClientBuilder builder() {
        return new DefaultTnbClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default TnbServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
