/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a database table in Timestream. Tables contain one or more related time series. You can modify the
 * retention duration of the memory store and the magnetic store for a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Table implements SdkPojo, Serializable, ToCopyableBuilder<Table.Builder, Table> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Table::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(Table::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(Table::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableStatus").getter(getter(Table::tableStatusAsString)).setter(setter(Builder::tableStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()).build();

    private static final SdkField<RetentionProperties> RETENTION_PROPERTIES_FIELD = SdkField
            .<RetentionProperties> builder(MarshallingType.SDK_POJO).memberName("RetentionProperties")
            .getter(getter(Table::retentionProperties)).setter(setter(Builder::retentionProperties))
            .constructor(RetentionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionProperties").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Table::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Table::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<MagneticStoreWriteProperties> MAGNETIC_STORE_WRITE_PROPERTIES_FIELD = SdkField
            .<MagneticStoreWriteProperties> builder(MarshallingType.SDK_POJO)
            .memberName("MagneticStoreWriteProperties")
            .getter(getter(Table::magneticStoreWriteProperties))
            .setter(setter(Builder::magneticStoreWriteProperties))
            .constructor(MagneticStoreWriteProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreWriteProperties")
                    .build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(Table::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TABLE_NAME_FIELD,
            DATABASE_NAME_FIELD, TABLE_STATUS_FIELD, RETENTION_PROPERTIES_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD,
            MAGNETIC_STORE_WRITE_PROPERTIES_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String tableName;

    private final String databaseName;

    private final String tableStatus;

    private final RetentionProperties retentionProperties;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final MagneticStoreWriteProperties magneticStoreWriteProperties;

    private final Schema schema;

    private Table(BuilderImpl builder) {
        this.arn = builder.arn;
        this.tableName = builder.tableName;
        this.databaseName = builder.databaseName;
        this.tableStatus = builder.tableStatus;
        this.retentionProperties = builder.retentionProperties;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.magneticStoreWriteProperties = builder.magneticStoreWriteProperties;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The Amazon Resource Name that uniquely identifies this table.
     * </p>
     * 
     * @return The Amazon Resource Name that uniquely identifies this table.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the Timestream table.
     * </p>
     * 
     * @return The name of the Timestream table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the Timestream database that contains this table.
     * </p>
     * 
     * @return The name of the Timestream database that contains this table.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The current state of the table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETING</code> - The table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The table is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableStatus} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableStatusAsString}.
     * </p>
     * 
     * @return The current state of the table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The table is ready for use.
     *         </p>
     *         </li>
     * @see TableStatus
     */
    public final TableStatus tableStatus() {
        return TableStatus.fromValue(tableStatus);
    }

    /**
     * <p>
     * The current state of the table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETING</code> - The table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The table is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableStatus} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableStatusAsString}.
     * </p>
     * 
     * @return The current state of the table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The table is ready for use.
     *         </p>
     *         </li>
     * @see TableStatus
     */
    public final String tableStatusAsString() {
        return tableStatus;
    }

    /**
     * <p>
     * The retention duration for the memory store and magnetic store.
     * </p>
     * 
     * @return The retention duration for the memory store and magnetic store.
     */
    public final RetentionProperties retentionProperties() {
        return retentionProperties;
    }

    /**
     * <p>
     * The time when the Timestream table was created.
     * </p>
     * 
     * @return The time when the Timestream table was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the Timestream table was last updated.
     * </p>
     * 
     * @return The time when the Timestream table was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Contains properties to set on the table when enabling magnetic store writes.
     * </p>
     * 
     * @return Contains properties to set on the table when enabling magnetic store writes.
     */
    public final MagneticStoreWriteProperties magneticStoreWriteProperties() {
        return magneticStoreWriteProperties;
    }

    /**
     * <p>
     * The schema of the table.
     * </p>
     * 
     * @return The schema of the table.
     */
    public final Schema schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(magneticStoreWriteProperties());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableStatusAsString(), other.tableStatusAsString())
                && Objects.equals(retentionProperties(), other.retentionProperties())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(magneticStoreWriteProperties(), other.magneticStoreWriteProperties())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Table").add("Arn", arn()).add("TableName", tableName()).add("DatabaseName", databaseName())
                .add("TableStatus", tableStatusAsString()).add("RetentionProperties", retentionProperties())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("MagneticStoreWriteProperties", magneticStoreWriteProperties()).add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableStatus":
            return Optional.ofNullable(clazz.cast(tableStatusAsString()));
        case "RetentionProperties":
            return Optional.ofNullable(clazz.cast(retentionProperties()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "MagneticStoreWriteProperties":
            return Optional.ofNullable(clazz.cast(magneticStoreWriteProperties()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableStatus", TABLE_STATUS_FIELD);
        map.put("RetentionProperties", RETENTION_PROPERTIES_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("MagneticStoreWriteProperties", MAGNETIC_STORE_WRITE_PROPERTIES_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Table, T> g) {
        return obj -> g.apply((Table) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Table> {
        /**
         * <p>
         * The Amazon Resource Name that uniquely identifies this table.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name that uniquely identifies this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the Timestream table.
         * </p>
         * 
         * @param tableName
         *        The name of the Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the Timestream database that contains this table.
         * </p>
         * 
         * @param databaseName
         *        The name of the Timestream database that contains this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The current state of the table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETING</code> - The table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The table is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The current state of the table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The table is ready for use.
         *        </p>
         *        </li>
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder tableStatus(String tableStatus);

        /**
         * <p>
         * The current state of the table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETING</code> - The table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The table is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The current state of the table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The table is ready for use.
         *        </p>
         *        </li>
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder tableStatus(TableStatus tableStatus);

        /**
         * <p>
         * The retention duration for the memory store and magnetic store.
         * </p>
         * 
         * @param retentionProperties
         *        The retention duration for the memory store and magnetic store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionProperties(RetentionProperties retentionProperties);

        /**
         * <p>
         * The retention duration for the memory store and magnetic store.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionProperties.Builder} avoiding the
         * need to create one manually via {@link RetentionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #retentionProperties(RetentionProperties)}.
         * 
         * @param retentionProperties
         *        a consumer that will call methods on {@link RetentionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionProperties(RetentionProperties)
         */
        default Builder retentionProperties(Consumer<RetentionProperties.Builder> retentionProperties) {
            return retentionProperties(RetentionProperties.builder().applyMutation(retentionProperties).build());
        }

        /**
         * <p>
         * The time when the Timestream table was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the Timestream table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the Timestream table was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the Timestream table was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Contains properties to set on the table when enabling magnetic store writes.
         * </p>
         * 
         * @param magneticStoreWriteProperties
         *        Contains properties to set on the table when enabling magnetic store writes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties);

        /**
         * <p>
         * Contains properties to set on the table when enabling magnetic store writes.
         * </p>
         * This is a convenience method that creates an instance of the {@link MagneticStoreWriteProperties.Builder}
         * avoiding the need to create one manually via {@link MagneticStoreWriteProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MagneticStoreWriteProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #magneticStoreWriteProperties(MagneticStoreWriteProperties)}.
         * 
         * @param magneticStoreWriteProperties
         *        a consumer that will call methods on {@link MagneticStoreWriteProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #magneticStoreWriteProperties(MagneticStoreWriteProperties)
         */
        default Builder magneticStoreWriteProperties(Consumer<MagneticStoreWriteProperties.Builder> magneticStoreWriteProperties) {
            return magneticStoreWriteProperties(MagneticStoreWriteProperties.builder()
                    .applyMutation(magneticStoreWriteProperties).build());
        }

        /**
         * <p>
         * The schema of the table.
         * </p>
         * 
         * @param schema
         *        The schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * <p>
         * The schema of the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schema.Builder} avoiding the need to
         * create one manually via {@link Schema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String tableName;

        private String databaseName;

        private String tableStatus;

        private RetentionProperties retentionProperties;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private MagneticStoreWriteProperties magneticStoreWriteProperties;

        private Schema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            arn(model.arn);
            tableName(model.tableName);
            databaseName(model.databaseName);
            tableStatus(model.tableStatus);
            retentionProperties(model.retentionProperties);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            magneticStoreWriteProperties(model.magneticStoreWriteProperties);
            schema(model.schema);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableStatus() {
            return tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus == null ? null : tableStatus.toString());
            return this;
        }

        public final RetentionProperties.Builder getRetentionProperties() {
            return retentionProperties != null ? retentionProperties.toBuilder() : null;
        }

        public final void setRetentionProperties(RetentionProperties.BuilderImpl retentionProperties) {
            this.retentionProperties = retentionProperties != null ? retentionProperties.build() : null;
        }

        @Override
        public final Builder retentionProperties(RetentionProperties retentionProperties) {
            this.retentionProperties = retentionProperties;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final MagneticStoreWriteProperties.Builder getMagneticStoreWriteProperties() {
            return magneticStoreWriteProperties != null ? magneticStoreWriteProperties.toBuilder() : null;
        }

        public final void setMagneticStoreWriteProperties(MagneticStoreWriteProperties.BuilderImpl magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties != null ? magneticStoreWriteProperties.build()
                    : null;
        }

        @Override
        public final Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Table build() {
            return new Table(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
