/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the metadata attributes of the time series. For example, the name and Availability Zone of an EC2 instance
 * or the name of the manufacturer of a wind turbine are dimensions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dimension implements SdkPojo, Serializable, ToCopyableBuilder<Dimension.Builder, Dimension> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Dimension::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Dimension::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> DIMENSION_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValueType").getter(getter(Dimension::dimensionValueTypeAsString))
            .setter(setter(Builder::dimensionValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            DIMENSION_VALUE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final String dimensionValueType;

    private Dimension(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.dimensionValueType = builder.dimensionValueType;
    }

    /**
     * <p>
     * Dimension represents the metadata attributes of the time series. For example, the name and Availability Zone of
     * an EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
     * </p>
     * <p>
     * For constraints on dimension names, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming">Naming
     * Constraints</a>.
     * </p>
     * 
     * @return Dimension represents the metadata attributes of the time series. For example, the name and Availability
     *         Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions. </p>
     *         <p>
     *         For constraints on dimension names, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming">Naming
     *         Constraints</a>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value of the dimension.
     * </p>
     * 
     * @return The value of the dimension.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The data type of the dimension for the time-series data point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueType} will return {@link DimensionValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #dimensionValueTypeAsString}.
     * </p>
     * 
     * @return The data type of the dimension for the time-series data point.
     * @see DimensionValueType
     */
    public final DimensionValueType dimensionValueType() {
        return DimensionValueType.fromValue(dimensionValueType);
    }

    /**
     * <p>
     * The data type of the dimension for the time-series data point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueType} will return {@link DimensionValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #dimensionValueTypeAsString}.
     * </p>
     * 
     * @return The data type of the dimension for the time-series data point.
     * @see DimensionValueType
     */
    public final String dimensionValueTypeAsString() {
        return dimensionValueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(dimensionValueTypeAsString(), other.dimensionValueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dimension").add("Name", name()).add("Value", value())
                .add("DimensionValueType", dimensionValueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "DimensionValueType":
            return Optional.ofNullable(clazz.cast(dimensionValueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("DimensionValueType", DIMENSION_VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dimension, T> g) {
        return obj -> g.apply((Dimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dimension> {
        /**
         * <p>
         * Dimension represents the metadata attributes of the time series. For example, the name and Availability Zone
         * of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
         * </p>
         * <p>
         * For constraints on dimension names, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming">Naming
         * Constraints</a>.
         * </p>
         * 
         * @param name
         *        Dimension represents the metadata attributes of the time series. For example, the name and
         *        Availability Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
         *        </p>
         *        <p>
         *        For constraints on dimension names, see <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming"
         *        >Naming Constraints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the dimension.
         * </p>
         * 
         * @param value
         *        The value of the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The data type of the dimension for the time-series data point.
         * </p>
         * 
         * @param dimensionValueType
         *        The data type of the dimension for the time-series data point.
         * @see DimensionValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueType
         */
        Builder dimensionValueType(String dimensionValueType);

        /**
         * <p>
         * The data type of the dimension for the time-series data point.
         * </p>
         * 
         * @param dimensionValueType
         *        The data type of the dimension for the time-series data point.
         * @see DimensionValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueType
         */
        Builder dimensionValueType(DimensionValueType dimensionValueType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private String dimensionValueType;

        private BuilderImpl() {
        }

        private BuilderImpl(Dimension model) {
            name(model.name);
            value(model.value);
            dimensionValueType(model.dimensionValueType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getDimensionValueType() {
            return dimensionValueType;
        }

        public final void setDimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
        }

        @Override
        public final Builder dimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
            return this;
        }

        @Override
        public final Builder dimensionValueType(DimensionValueType dimensionValueType) {
            this.dimensionValueType(dimensionValueType == null ? null : dimensionValueType.toString());
            return this;
        }

        @Override
        public Dimension build() {
            return new Dimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
