/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataModelConfiguration.Builder, DataModelConfiguration> {
    private static final SdkField<DataModel> DATA_MODEL_FIELD = SdkField.<DataModel> builder(MarshallingType.SDK_POJO)
            .memberName("DataModel").getter(getter(DataModelConfiguration::dataModel)).setter(setter(Builder::dataModel))
            .constructor(DataModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModel").build()).build();

    private static final SdkField<DataModelS3Configuration> DATA_MODEL_S3_CONFIGURATION_FIELD = SdkField
            .<DataModelS3Configuration> builder(MarshallingType.SDK_POJO).memberName("DataModelS3Configuration")
            .getter(getter(DataModelConfiguration::dataModelS3Configuration)).setter(setter(Builder::dataModelS3Configuration))
            .constructor(DataModelS3Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModelS3Configuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MODEL_FIELD,
            DATA_MODEL_S3_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataModel dataModel;

    private final DataModelS3Configuration dataModelS3Configuration;

    private DataModelConfiguration(BuilderImpl builder) {
        this.dataModel = builder.dataModel;
        this.dataModelS3Configuration = builder.dataModelS3Configuration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final DataModel dataModel() {
        return dataModel;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final DataModelS3Configuration dataModelS3Configuration() {
        return dataModelS3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataModel());
        hashCode = 31 * hashCode + Objects.hashCode(dataModelS3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataModelConfiguration)) {
            return false;
        }
        DataModelConfiguration other = (DataModelConfiguration) obj;
        return Objects.equals(dataModel(), other.dataModel())
                && Objects.equals(dataModelS3Configuration(), other.dataModelS3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataModelConfiguration").add("DataModel", dataModel())
                .add("DataModelS3Configuration", dataModelS3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataModel":
            return Optional.ofNullable(clazz.cast(dataModel()));
        case "DataModelS3Configuration":
            return Optional.ofNullable(clazz.cast(dataModelS3Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataModel", DATA_MODEL_FIELD);
        map.put("DataModelS3Configuration", DATA_MODEL_S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataModelConfiguration, T> g) {
        return obj -> g.apply((DataModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataModelConfiguration> {
        /**
         * <p/>
         * 
         * @param dataModel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataModel(DataModel dataModel);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link DataModel.Builder} avoiding the need to
         * create one manually via {@link DataModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataModel.Builder#build()} is called immediately and its result
         * is passed to {@link #dataModel(DataModel)}.
         * 
         * @param dataModel
         *        a consumer that will call methods on {@link DataModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataModel(DataModel)
         */
        default Builder dataModel(Consumer<DataModel.Builder> dataModel) {
            return dataModel(DataModel.builder().applyMutation(dataModel).build());
        }

        /**
         * <p/>
         * 
         * @param dataModelS3Configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataModelS3Configuration(DataModelS3Configuration dataModelS3Configuration);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link DataModelS3Configuration.Builder}
         * avoiding the need to create one manually via {@link DataModelS3Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataModelS3Configuration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataModelS3Configuration(DataModelS3Configuration)}.
         * 
         * @param dataModelS3Configuration
         *        a consumer that will call methods on {@link DataModelS3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataModelS3Configuration(DataModelS3Configuration)
         */
        default Builder dataModelS3Configuration(Consumer<DataModelS3Configuration.Builder> dataModelS3Configuration) {
            return dataModelS3Configuration(DataModelS3Configuration.builder().applyMutation(dataModelS3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataModel dataModel;

        private DataModelS3Configuration dataModelS3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataModelConfiguration model) {
            dataModel(model.dataModel);
            dataModelS3Configuration(model.dataModelS3Configuration);
        }

        public final DataModel.Builder getDataModel() {
            return dataModel != null ? dataModel.toBuilder() : null;
        }

        public final void setDataModel(DataModel.BuilderImpl dataModel) {
            this.dataModel = dataModel != null ? dataModel.build() : null;
        }

        @Override
        public final Builder dataModel(DataModel dataModel) {
            this.dataModel = dataModel;
            return this;
        }

        public final DataModelS3Configuration.Builder getDataModelS3Configuration() {
            return dataModelS3Configuration != null ? dataModelS3Configuration.toBuilder() : null;
        }

        public final void setDataModelS3Configuration(DataModelS3Configuration.BuilderImpl dataModelS3Configuration) {
            this.dataModelS3Configuration = dataModelS3Configuration != null ? dataModelS3Configuration.build() : null;
        }

        @Override
        public final Builder dataModelS3Configuration(DataModelS3Configuration dataModelS3Configuration) {
            this.dataModelS3Configuration = dataModelS3Configuration;
            return this;
        }

        @Override
        public DataModelConfiguration build() {
            return new DataModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
