/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTableRequest extends TimestreamWriteRequest implements
        ToCopyableBuilder<CreateTableRequest.Builder, CreateTableRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(CreateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<RetentionProperties> RETENTION_PROPERTIES_FIELD = SdkField
            .<RetentionProperties> builder(MarshallingType.SDK_POJO).memberName("RetentionProperties")
            .getter(getter(CreateTableRequest::retentionProperties)).setter(setter(Builder::retentionProperties))
            .constructor(RetentionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MagneticStoreWriteProperties> MAGNETIC_STORE_WRITE_PROPERTIES_FIELD = SdkField
            .<MagneticStoreWriteProperties> builder(MarshallingType.SDK_POJO)
            .memberName("MagneticStoreWriteProperties")
            .getter(getter(CreateTableRequest::magneticStoreWriteProperties))
            .setter(setter(Builder::magneticStoreWriteProperties))
            .constructor(MagneticStoreWriteProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreWriteProperties")
                    .build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(CreateTableRequest::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, RETENTION_PROPERTIES_FIELD, TAGS_FIELD, MAGNETIC_STORE_WRITE_PROPERTIES_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String databaseName;

    private final String tableName;

    private final RetentionProperties retentionProperties;

    private final List<Tag> tags;

    private final MagneticStoreWriteProperties magneticStoreWriteProperties;

    private final Schema schema;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.retentionProperties = builder.retentionProperties;
        this.tags = builder.tags;
        this.magneticStoreWriteProperties = builder.magneticStoreWriteProperties;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The name of the Timestream database.
     * </p>
     * 
     * @return The name of the Timestream database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the Timestream table.
     * </p>
     * 
     * @return The name of the Timestream table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The duration for which your time-series data must be stored in the memory store and the magnetic store.
     * </p>
     * 
     * @return The duration for which your time-series data must be stored in the memory store and the magnetic store.
     */
    public final RetentionProperties retentionProperties() {
        return retentionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to label the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to label the table.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains properties to set on the table when enabling magnetic store writes.
     * </p>
     * 
     * @return Contains properties to set on the table when enabling magnetic store writes.
     */
    public final MagneticStoreWriteProperties magneticStoreWriteProperties() {
        return magneticStoreWriteProperties;
    }

    /**
     * <p>
     * The schema of the table.
     * </p>
     * 
     * @return The schema of the table.
     */
    public final Schema schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(magneticStoreWriteProperties());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(retentionProperties(), other.retentionProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(magneticStoreWriteProperties(), other.magneticStoreWriteProperties())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTableRequest").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("RetentionProperties", retentionProperties()).add("Tags", hasTags() ? tags() : null)
                .add("MagneticStoreWriteProperties", magneticStoreWriteProperties()).add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "RetentionProperties":
            return Optional.ofNullable(clazz.cast(retentionProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "MagneticStoreWriteProperties":
            return Optional.ofNullable(clazz.cast(magneticStoreWriteProperties()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("RetentionProperties", RETENTION_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("MagneticStoreWriteProperties", MAGNETIC_STORE_WRITE_PROPERTIES_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamWriteRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTableRequest> {
        /**
         * <p>
         * The name of the Timestream database.
         * </p>
         * 
         * @param databaseName
         *        The name of the Timestream database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the Timestream table.
         * </p>
         * 
         * @param tableName
         *        The name of the Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The duration for which your time-series data must be stored in the memory store and the magnetic store.
         * </p>
         * 
         * @param retentionProperties
         *        The duration for which your time-series data must be stored in the memory store and the magnetic
         *        store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionProperties(RetentionProperties retentionProperties);

        /**
         * <p>
         * The duration for which your time-series data must be stored in the memory store and the magnetic store.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionProperties.Builder} avoiding the
         * need to create one manually via {@link RetentionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #retentionProperties(RetentionProperties)}.
         * 
         * @param retentionProperties
         *        a consumer that will call methods on {@link RetentionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionProperties(RetentionProperties)
         */
        default Builder retentionProperties(Consumer<RetentionProperties.Builder> retentionProperties) {
            return retentionProperties(RetentionProperties.builder().applyMutation(retentionProperties).build());
        }

        /**
         * <p>
         * A list of key-value pairs to label the table.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to label the table.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to label the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.timestreamwrite.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Contains properties to set on the table when enabling magnetic store writes.
         * </p>
         * 
         * @param magneticStoreWriteProperties
         *        Contains properties to set on the table when enabling magnetic store writes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties);

        /**
         * <p>
         * Contains properties to set on the table when enabling magnetic store writes.
         * </p>
         * This is a convenience method that creates an instance of the {@link MagneticStoreWriteProperties.Builder}
         * avoiding the need to create one manually via {@link MagneticStoreWriteProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MagneticStoreWriteProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #magneticStoreWriteProperties(MagneticStoreWriteProperties)}.
         * 
         * @param magneticStoreWriteProperties
         *        a consumer that will call methods on {@link MagneticStoreWriteProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #magneticStoreWriteProperties(MagneticStoreWriteProperties)
         */
        default Builder magneticStoreWriteProperties(Consumer<MagneticStoreWriteProperties.Builder> magneticStoreWriteProperties) {
            return magneticStoreWriteProperties(MagneticStoreWriteProperties.builder()
                    .applyMutation(magneticStoreWriteProperties).build());
        }

        /**
         * <p>
         * The schema of the table.
         * </p>
         * 
         * @param schema
         *        The schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * <p>
         * The schema of the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schema.Builder} avoiding the need to
         * create one manually via {@link Schema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamWriteRequest.BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private RetentionProperties retentionProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private MagneticStoreWriteProperties magneticStoreWriteProperties;

        private Schema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            databaseName(model.databaseName);
            tableName(model.tableName);
            retentionProperties(model.retentionProperties);
            tags(model.tags);
            magneticStoreWriteProperties(model.magneticStoreWriteProperties);
            schema(model.schema);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final RetentionProperties.Builder getRetentionProperties() {
            return retentionProperties != null ? retentionProperties.toBuilder() : null;
        }

        public final void setRetentionProperties(RetentionProperties.BuilderImpl retentionProperties) {
            this.retentionProperties = retentionProperties != null ? retentionProperties.build() : null;
        }

        @Override
        public final Builder retentionProperties(RetentionProperties retentionProperties) {
            this.retentionProperties = retentionProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MagneticStoreWriteProperties.Builder getMagneticStoreWriteProperties() {
            return magneticStoreWriteProperties != null ? magneticStoreWriteProperties.toBuilder() : null;
        }

        public final void setMagneticStoreWriteProperties(MagneticStoreWriteProperties.BuilderImpl magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties != null ? magneticStoreWriteProperties.build()
                    : null;
        }

        @Override
        public final Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
