/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBatchLoadTaskRequest extends TimestreamWriteRequest implements
        ToCopyableBuilder<CreateBatchLoadTaskRequest.Builder, CreateBatchLoadTaskRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateBatchLoadTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DataModelConfiguration> DATA_MODEL_CONFIGURATION_FIELD = SdkField
            .<DataModelConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataModelConfiguration")
            .getter(getter(CreateBatchLoadTaskRequest::dataModelConfiguration)).setter(setter(Builder::dataModelConfiguration))
            .constructor(DataModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModelConfiguration").build())
            .build();

    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataSourceConfiguration")
            .getter(getter(CreateBatchLoadTaskRequest::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build())
            .build();

    private static final SdkField<ReportConfiguration> REPORT_CONFIGURATION_FIELD = SdkField
            .<ReportConfiguration> builder(MarshallingType.SDK_POJO).memberName("ReportConfiguration")
            .getter(getter(CreateBatchLoadTaskRequest::reportConfiguration)).setter(setter(Builder::reportConfiguration))
            .constructor(ReportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportConfiguration").build())
            .build();

    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDatabaseName").getter(getter(CreateBatchLoadTaskRequest::targetDatabaseName))
            .setter(setter(Builder::targetDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build())
            .build();

    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetTableName").getter(getter(CreateBatchLoadTaskRequest::targetTableName))
            .setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final SdkField<Long> RECORD_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordVersion").getter(getter(CreateBatchLoadTaskRequest::recordVersion))
            .setter(setter(Builder::recordVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATA_MODEL_CONFIGURATION_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, REPORT_CONFIGURATION_FIELD,
            TARGET_DATABASE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, RECORD_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final DataModelConfiguration dataModelConfiguration;

    private final DataSourceConfiguration dataSourceConfiguration;

    private final ReportConfiguration reportConfiguration;

    private final String targetDatabaseName;

    private final String targetTableName;

    private final Long recordVersion;

    private CreateBatchLoadTaskRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataModelConfiguration = builder.dataModelConfiguration;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.reportConfiguration = builder.reportConfiguration;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetTableName = builder.targetTableName;
        this.recordVersion = builder.recordVersion;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the DataModelConfiguration property for this object.
     * 
     * @return The value of the DataModelConfiguration property for this object.
     */
    public final DataModelConfiguration dataModelConfiguration() {
        return dataModelConfiguration;
    }

    /**
     * <p>
     * Defines configuration details about the data source for a batch load task.
     * </p>
     * 
     * @return Defines configuration details about the data source for a batch load task.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * Returns the value of the ReportConfiguration property for this object.
     * 
     * @return The value of the ReportConfiguration property for this object.
     */
    public final ReportConfiguration reportConfiguration() {
        return reportConfiguration;
    }

    /**
     * <p>
     * Target Timestream database for a batch load task.
     * </p>
     * 
     * @return Target Timestream database for a batch load task.
     */
    public final String targetDatabaseName() {
        return targetDatabaseName;
    }

    /**
     * <p>
     * Target Timestream table for a batch load task.
     * </p>
     * 
     * @return Target Timestream table for a batch load task.
     */
    public final String targetTableName() {
        return targetTableName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long recordVersion() {
        return recordVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(reportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(recordVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchLoadTaskRequest)) {
            return false;
        }
        CreateBatchLoadTaskRequest other = (CreateBatchLoadTaskRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dataModelConfiguration(), other.dataModelConfiguration())
                && Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(reportConfiguration(), other.reportConfiguration())
                && Objects.equals(targetDatabaseName(), other.targetDatabaseName())
                && Objects.equals(targetTableName(), other.targetTableName())
                && Objects.equals(recordVersion(), other.recordVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBatchLoadTaskRequest")
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataModelConfiguration", dataModelConfiguration())
                .add("DataSourceConfiguration", dataSourceConfiguration()).add("ReportConfiguration", reportConfiguration())
                .add("TargetDatabaseName", targetDatabaseName()).add("TargetTableName", targetTableName())
                .add("RecordVersion", recordVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DataModelConfiguration":
            return Optional.ofNullable(clazz.cast(dataModelConfiguration()));
        case "DataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "ReportConfiguration":
            return Optional.ofNullable(clazz.cast(reportConfiguration()));
        case "TargetDatabaseName":
            return Optional.ofNullable(clazz.cast(targetDatabaseName()));
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "RecordVersion":
            return Optional.ofNullable(clazz.cast(recordVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DataModelConfiguration", DATA_MODEL_CONFIGURATION_FIELD);
        map.put("DataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
        map.put("ReportConfiguration", REPORT_CONFIGURATION_FIELD);
        map.put("TargetDatabaseName", TARGET_DATABASE_NAME_FIELD);
        map.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
        map.put("RecordVersion", RECORD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchLoadTaskRequest, T> g) {
        return obj -> g.apply((CreateBatchLoadTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamWriteRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBatchLoadTaskRequest> {
        /**
         * <p/>
         * 
         * @param clientToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the DataModelConfiguration property for this object.
         *
         * @param dataModelConfiguration
         *        The new value for the DataModelConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataModelConfiguration(DataModelConfiguration dataModelConfiguration);

        /**
         * Sets the value of the DataModelConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataModelConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataModelConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #dataModelConfiguration(DataModelConfiguration)}.
         * 
         * @param dataModelConfiguration
         *        a consumer that will call methods on {@link DataModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataModelConfiguration(DataModelConfiguration)
         */
        default Builder dataModelConfiguration(Consumer<DataModelConfiguration.Builder> dataModelConfiguration) {
            return dataModelConfiguration(DataModelConfiguration.builder().applyMutation(dataModelConfiguration).build());
        }

        /**
         * <p>
         * Defines configuration details about the data source for a batch load task.
         * </p>
         * 
         * @param dataSourceConfiguration
         *        Defines configuration details about the data source for a batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * <p>
         * Defines configuration details about the data source for a batch load task.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * Sets the value of the ReportConfiguration property for this object.
         *
         * @param reportConfiguration
         *        The new value for the ReportConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportConfiguration(ReportConfiguration reportConfiguration);

        /**
         * Sets the value of the ReportConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ReportConfiguration.Builder} avoiding the
         * need to create one manually via {@link ReportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #reportConfiguration(ReportConfiguration)}.
         * 
         * @param reportConfiguration
         *        a consumer that will call methods on {@link ReportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportConfiguration(ReportConfiguration)
         */
        default Builder reportConfiguration(Consumer<ReportConfiguration.Builder> reportConfiguration) {
            return reportConfiguration(ReportConfiguration.builder().applyMutation(reportConfiguration).build());
        }

        /**
         * <p>
         * Target Timestream database for a batch load task.
         * </p>
         * 
         * @param targetDatabaseName
         *        Target Timestream database for a batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseName(String targetDatabaseName);

        /**
         * <p>
         * Target Timestream table for a batch load task.
         * </p>
         * 
         * @param targetTableName
         *        Target Timestream table for a batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p/>
         * 
         * @param recordVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordVersion(Long recordVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamWriteRequest.BuilderImpl implements Builder {
        private String clientToken;

        private DataModelConfiguration dataModelConfiguration;

        private DataSourceConfiguration dataSourceConfiguration;

        private ReportConfiguration reportConfiguration;

        private String targetDatabaseName;

        private String targetTableName;

        private Long recordVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchLoadTaskRequest model) {
            super(model);
            clientToken(model.clientToken);
            dataModelConfiguration(model.dataModelConfiguration);
            dataSourceConfiguration(model.dataSourceConfiguration);
            reportConfiguration(model.reportConfiguration);
            targetDatabaseName(model.targetDatabaseName);
            targetTableName(model.targetTableName);
            recordVersion(model.recordVersion);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataModelConfiguration.Builder getDataModelConfiguration() {
            return dataModelConfiguration != null ? dataModelConfiguration.toBuilder() : null;
        }

        public final void setDataModelConfiguration(DataModelConfiguration.BuilderImpl dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration != null ? dataModelConfiguration.build() : null;
        }

        @Override
        public final Builder dataModelConfiguration(DataModelConfiguration dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration;
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final ReportConfiguration.Builder getReportConfiguration() {
            return reportConfiguration != null ? reportConfiguration.toBuilder() : null;
        }

        public final void setReportConfiguration(ReportConfiguration.BuilderImpl reportConfiguration) {
            this.reportConfiguration = reportConfiguration != null ? reportConfiguration.build() : null;
        }

        @Override
        public final Builder reportConfiguration(ReportConfiguration reportConfiguration) {
            this.reportConfiguration = reportConfiguration;
            return this;
        }

        public final String getTargetDatabaseName() {
            return targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final Long getRecordVersion() {
            return recordVersion;
        }

        public final void setRecordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
        }

        @Override
        public final Builder recordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchLoadTaskRequest build() {
            return new CreateBatchLoadTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
