/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask;
import software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTaskListCopier;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBatchLoadTasksResponse
extends TimestreamWriteResponse
implements ToCopyableBuilder<Builder, ListBatchLoadTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBatchLoadTasksResponse.getter(ListBatchLoadTasksResponse::nextToken)).setter(ListBatchLoadTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BatchLoadTask>> BATCH_LOAD_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BatchLoadTasks").getter(ListBatchLoadTasksResponse.getter(ListBatchLoadTasksResponse::batchLoadTasks)).setter(ListBatchLoadTasksResponse.setter(Builder::batchLoadTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchLoadTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchLoadTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BATCH_LOAD_TASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBatchLoadTasksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<BatchLoadTask> batchLoadTasks;

    private ListBatchLoadTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.batchLoadTasks = builder.batchLoadTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBatchLoadTasks() {
        return this.batchLoadTasks != null && !(this.batchLoadTasks instanceof SdkAutoConstructList);
    }

    public final List<BatchLoadTask> batchLoadTasks() {
        return this.batchLoadTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchLoadTasks() ? this.batchLoadTasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchLoadTasksResponse)) {
            return false;
        }
        ListBatchLoadTasksResponse other = (ListBatchLoadTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasBatchLoadTasks() == other.hasBatchLoadTasks() && Objects.equals(this.batchLoadTasks(), other.batchLoadTasks());
    }

    public final String toString() {
        return ToString.builder((String)"ListBatchLoadTasksResponse").add("NextToken", (Object)this.nextToken()).add("BatchLoadTasks", this.hasBatchLoadTasks() ? this.batchLoadTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "BatchLoadTasks": {
                return Optional.ofNullable(clazz.cast(this.batchLoadTasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("BatchLoadTasks", BATCH_LOAD_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchLoadTasksResponse, T> g) {
        return obj -> g.apply((ListBatchLoadTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamWriteResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BatchLoadTask> batchLoadTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchLoadTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.batchLoadTasks(model.batchLoadTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BatchLoadTask.Builder> getBatchLoadTasks() {
            List<BatchLoadTask.Builder> result = BatchLoadTaskListCopier.copyToBuilder(this.batchLoadTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchLoadTasks(Collection<BatchLoadTask.BuilderImpl> batchLoadTasks) {
            this.batchLoadTasks = BatchLoadTaskListCopier.copyFromBuilder(batchLoadTasks);
        }

        @Override
        public final Builder batchLoadTasks(Collection<BatchLoadTask> batchLoadTasks) {
            this.batchLoadTasks = BatchLoadTaskListCopier.copy(batchLoadTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchLoadTasks(BatchLoadTask ... batchLoadTasks) {
            this.batchLoadTasks(Arrays.asList(batchLoadTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchLoadTasks(Consumer<BatchLoadTask.Builder> ... batchLoadTasks) {
            this.batchLoadTasks(Stream.of(batchLoadTasks).map(c -> (BatchLoadTask)((BatchLoadTask.Builder)BatchLoadTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBatchLoadTasksResponse build() {
            return new ListBatchLoadTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamWriteResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBatchLoadTasksResponse> {
        public Builder nextToken(String var1);

        public Builder batchLoadTasks(Collection<BatchLoadTask> var1);

        public Builder batchLoadTasks(BatchLoadTask ... var1);

        public Builder batchLoadTasks(Consumer<BatchLoadTask.Builder> ... var1);
    }
}

