/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchLoadProgressReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchLoadProgressReport> {
    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordsProcessed").getter(BatchLoadProgressReport.getter(BatchLoadProgressReport::recordsProcessed)).setter(BatchLoadProgressReport.setter(Builder::recordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()}).build();
    private static final SdkField<Long> RECORDS_INGESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordsIngested").getter(BatchLoadProgressReport.getter(BatchLoadProgressReport::recordsIngested)).setter(BatchLoadProgressReport.setter(Builder::recordsIngested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsIngested").build()}).build();
    private static final SdkField<Long> PARSE_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ParseFailures").getter(BatchLoadProgressReport.getter(BatchLoadProgressReport::parseFailures)).setter(BatchLoadProgressReport.setter(Builder::parseFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParseFailures").build()}).build();
    private static final SdkField<Long> RECORD_INGESTION_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordIngestionFailures").getter(BatchLoadProgressReport.getter(BatchLoadProgressReport::recordIngestionFailures)).setter(BatchLoadProgressReport.setter(Builder::recordIngestionFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIngestionFailures").build()}).build();
    private static final SdkField<Long> FILE_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileFailures").getter(BatchLoadProgressReport.getter(BatchLoadProgressReport::fileFailures)).setter(BatchLoadProgressReport.setter(Builder::fileFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFailures").build()}).build();
    private static final SdkField<Long> BYTES_METERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesMetered").getter(BatchLoadProgressReport.getter(BatchLoadProgressReport::bytesMetered)).setter(BatchLoadProgressReport.setter(Builder::bytesMetered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesMetered").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_PROCESSED_FIELD, RECORDS_INGESTED_FIELD, PARSE_FAILURES_FIELD, RECORD_INGESTION_FAILURES_FIELD, FILE_FAILURES_FIELD, BYTES_METERED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchLoadProgressReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long recordsProcessed;
    private final Long recordsIngested;
    private final Long parseFailures;
    private final Long recordIngestionFailures;
    private final Long fileFailures;
    private final Long bytesMetered;

    private BatchLoadProgressReport(BuilderImpl builder) {
        this.recordsProcessed = builder.recordsProcessed;
        this.recordsIngested = builder.recordsIngested;
        this.parseFailures = builder.parseFailures;
        this.recordIngestionFailures = builder.recordIngestionFailures;
        this.fileFailures = builder.fileFailures;
        this.bytesMetered = builder.bytesMetered;
    }

    public final Long recordsProcessed() {
        return this.recordsProcessed;
    }

    public final Long recordsIngested() {
        return this.recordsIngested;
    }

    public final Long parseFailures() {
        return this.parseFailures;
    }

    public final Long recordIngestionFailures() {
        return this.recordIngestionFailures;
    }

    public final Long fileFailures() {
        return this.fileFailures;
    }

    public final Long bytesMetered() {
        return this.bytesMetered;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(this.parseFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIngestionFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesMetered());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLoadProgressReport)) {
            return false;
        }
        BatchLoadProgressReport other = (BatchLoadProgressReport)obj;
        return Objects.equals(this.recordsProcessed(), other.recordsProcessed()) && Objects.equals(this.recordsIngested(), other.recordsIngested()) && Objects.equals(this.parseFailures(), other.parseFailures()) && Objects.equals(this.recordIngestionFailures(), other.recordIngestionFailures()) && Objects.equals(this.fileFailures(), other.fileFailures()) && Objects.equals(this.bytesMetered(), other.bytesMetered());
    }

    public final String toString() {
        return ToString.builder((String)"BatchLoadProgressReport").add("RecordsProcessed", (Object)this.recordsProcessed()).add("RecordsIngested", (Object)this.recordsIngested()).add("ParseFailures", (Object)this.parseFailures()).add("RecordIngestionFailures", (Object)this.recordIngestionFailures()).add("FileFailures", (Object)this.fileFailures()).add("BytesMetered", (Object)this.bytesMetered()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.recordsProcessed()));
            }
            case "RecordsIngested": {
                return Optional.ofNullable(clazz.cast(this.recordsIngested()));
            }
            case "ParseFailures": {
                return Optional.ofNullable(clazz.cast(this.parseFailures()));
            }
            case "RecordIngestionFailures": {
                return Optional.ofNullable(clazz.cast(this.recordIngestionFailures()));
            }
            case "FileFailures": {
                return Optional.ofNullable(clazz.cast(this.fileFailures()));
            }
            case "BytesMetered": {
                return Optional.ofNullable(clazz.cast(this.bytesMetered()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("RecordsProcessed", RECORDS_PROCESSED_FIELD);
        map.put("RecordsIngested", RECORDS_INGESTED_FIELD);
        map.put("ParseFailures", PARSE_FAILURES_FIELD);
        map.put("RecordIngestionFailures", RECORD_INGESTION_FAILURES_FIELD);
        map.put("FileFailures", FILE_FAILURES_FIELD);
        map.put("BytesMetered", BYTES_METERED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchLoadProgressReport, T> g) {
        return obj -> g.apply((BatchLoadProgressReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long recordsProcessed;
        private Long recordsIngested;
        private Long parseFailures;
        private Long recordIngestionFailures;
        private Long fileFailures;
        private Long bytesMetered;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLoadProgressReport model) {
            this.recordsProcessed(model.recordsProcessed);
            this.recordsIngested(model.recordsIngested);
            this.parseFailures(model.parseFailures);
            this.recordIngestionFailures(model.recordIngestionFailures);
            this.fileFailures(model.fileFailures);
            this.bytesMetered(model.bytesMetered);
        }

        public final Long getRecordsProcessed() {
            return this.recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final Long getRecordsIngested() {
            return this.recordsIngested;
        }

        public final void setRecordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
        }

        @Override
        public final Builder recordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
            return this;
        }

        public final Long getParseFailures() {
            return this.parseFailures;
        }

        public final void setParseFailures(Long parseFailures) {
            this.parseFailures = parseFailures;
        }

        @Override
        public final Builder parseFailures(Long parseFailures) {
            this.parseFailures = parseFailures;
            return this;
        }

        public final Long getRecordIngestionFailures() {
            return this.recordIngestionFailures;
        }

        public final void setRecordIngestionFailures(Long recordIngestionFailures) {
            this.recordIngestionFailures = recordIngestionFailures;
        }

        @Override
        public final Builder recordIngestionFailures(Long recordIngestionFailures) {
            this.recordIngestionFailures = recordIngestionFailures;
            return this;
        }

        public final Long getFileFailures() {
            return this.fileFailures;
        }

        public final void setFileFailures(Long fileFailures) {
            this.fileFailures = fileFailures;
        }

        @Override
        public final Builder fileFailures(Long fileFailures) {
            this.fileFailures = fileFailures;
            return this;
        }

        public final Long getBytesMetered() {
            return this.bytesMetered;
        }

        public final void setBytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
        }

        @Override
        public final Builder bytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
            return this;
        }

        public BatchLoadProgressReport build() {
            return new BatchLoadProgressReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchLoadProgressReport> {
        public Builder recordsProcessed(Long var1);

        public Builder recordsIngested(Long var1);

        public Builder parseFailures(Long var1);

        public Builder recordIngestionFailures(Long var1);

        public Builder fileFailures(Long var1);

        public Builder bytesMetered(Long var1);
    }
}

