/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecord;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsCopier;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectedRecordsException
extends TimestreamWriteException
implements ToCopyableBuilder<Builder, RejectedRecordsException> {
    private static final SdkField<List<RejectedRecord>> REJECTED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RejectedRecords").getter(RejectedRecordsException.getter(RejectedRecordsException::rejectedRecords)).setter(RejectedRecordsException.setter(Builder::rejectedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RejectedRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REJECTED_RECORDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<RejectedRecord> rejectedRecords;

    private RejectedRecordsException(BuilderImpl builder) {
        super(builder);
        this.rejectedRecords = builder.rejectedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasRejectedRecords() {
        return this.rejectedRecords != null && !(this.rejectedRecords instanceof SdkAutoConstructList);
    }

    public List<RejectedRecord> rejectedRecords() {
        return this.rejectedRecords;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectedRecordsException, T> g) {
        return obj -> g.apply((RejectedRecordsException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamWriteException.BuilderImpl
    implements Builder {
        private List<RejectedRecord> rejectedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedRecordsException model) {
            super(model);
            this.rejectedRecords(model.rejectedRecords);
        }

        public final Collection<RejectedRecord.Builder> getRejectedRecords() {
            if (this.rejectedRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rejectedRecords != null ? (Collection)this.rejectedRecords.stream().map(RejectedRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rejectedRecords(Collection<RejectedRecord> rejectedRecords) {
            this.rejectedRecords = RejectedRecordsCopier.copy(rejectedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedRecords(RejectedRecord ... rejectedRecords) {
            this.rejectedRecords(Arrays.asList(rejectedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedRecords(Consumer<RejectedRecord.Builder> ... rejectedRecords) {
            this.rejectedRecords(Stream.of(rejectedRecords).map(c -> (RejectedRecord)((RejectedRecord.Builder)RejectedRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRejectedRecords(Collection<RejectedRecord.BuilderImpl> rejectedRecords) {
            this.rejectedRecords = RejectedRecordsCopier.copyFromBuilder(rejectedRecords);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public RejectedRecordsException build() {
            return new RejectedRecordsException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RejectedRecordsException>,
    TimestreamWriteException.Builder {
        public Builder rejectedRecords(Collection<RejectedRecord> var1);

        public Builder rejectedRecords(RejectedRecord ... var1);

        public Builder rejectedRecords(Consumer<RejectedRecord.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

