/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.DimensionValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionMapping> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DimensionMapping.getter(DimensionMapping::name)).setter(DimensionMapping.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DIMENSION_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionValueType").getter(DimensionMapping.getter(DimensionMapping::dimensionValueTypeAsString)).setter(DimensionMapping.setter(Builder::dimensionValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DIMENSION_VALUE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DimensionMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dimensionValueType;

    private DimensionMapping(BuilderImpl builder) {
        this.name = builder.name;
        this.dimensionValueType = builder.dimensionValueType;
    }

    public final String name() {
        return this.name;
    }

    public final DimensionValueType dimensionValueType() {
        return DimensionValueType.fromValue(this.dimensionValueType);
    }

    public final String dimensionValueTypeAsString() {
        return this.dimensionValueType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValueTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionMapping)) {
            return false;
        }
        DimensionMapping other = (DimensionMapping)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dimensionValueTypeAsString(), other.dimensionValueTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionMapping").add("Name", (Object)this.name()).add("DimensionValueType", (Object)this.dimensionValueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DimensionValueType": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("DimensionValueType", DIMENSION_VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionMapping, T> g) {
        return obj -> g.apply((DimensionMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dimensionValueType;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionMapping model) {
            this.name(model.name);
            this.dimensionValueType(model.dimensionValueType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDimensionValueType() {
            return this.dimensionValueType;
        }

        public final void setDimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
        }

        @Override
        public final Builder dimensionValueType(String dimensionValueType) {
            this.dimensionValueType = dimensionValueType;
            return this;
        }

        @Override
        public final Builder dimensionValueType(DimensionValueType dimensionValueType) {
            this.dimensionValueType(dimensionValueType == null ? null : dimensionValueType.toString());
            return this;
        }

        public DimensionMapping build() {
            return new DimensionMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionMapping> {
        public Builder name(String var1);

        public Builder dimensionValueType(String var1);

        public Builder dimensionValueType(DimensionValueType var1);
    }
}

