/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ParameterMapping;
import software.amazon.awssdk.services.timestreamquery.model.ParameterMappingListCopier;
import software.amazon.awssdk.services.timestreamquery.model.SelectColumn;
import software.amazon.awssdk.services.timestreamquery.model.SelectColumnListCopier;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrepareQueryResponse
extends TimestreamQueryResponse
implements ToCopyableBuilder<Builder, PrepareQueryResponse> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(PrepareQueryResponse.getter(PrepareQueryResponse::queryString)).setter(PrepareQueryResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<List<SelectColumn>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Columns").getter(PrepareQueryResponse.getter(PrepareQueryResponse::columns)).setter(PrepareQueryResponse.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SelectColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterMapping>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(PrepareQueryResponse.getter(PrepareQueryResponse::parameters)).setter(PrepareQueryResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD, COLUMNS_FIELD, PARAMETERS_FIELD));
    private final String queryString;
    private final List<SelectColumn> columns;
    private final List<ParameterMapping> parameters;

    private PrepareQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.columns = builder.columns;
        this.parameters = builder.parameters;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<SelectColumn> columns() {
        return this.columns;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ParameterMapping> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrepareQueryResponse)) {
            return false;
        }
        PrepareQueryResponse other = (PrepareQueryResponse)((Object)obj);
        return Objects.equals(this.queryString(), other.queryString()) && this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"PrepareQueryResponse").add("QueryString", (Object)(this.queryString() == null ? null : "*** Sensitive Data Redacted ***")).add("Columns", this.hasColumns() ? this.columns() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrepareQueryResponse, T> g) {
        return obj -> g.apply((PrepareQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryResponse.BuilderImpl
    implements Builder {
        private String queryString;
        private List<SelectColumn> columns = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterMapping> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrepareQueryResponse model) {
            super(model);
            this.queryString(model.queryString);
            this.columns(model.columns);
            this.parameters(model.parameters);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final List<SelectColumn.Builder> getColumns() {
            List<SelectColumn.Builder> result = SelectColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<SelectColumn.BuilderImpl> columns) {
            this.columns = SelectColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        @Transient
        public final Builder columns(Collection<SelectColumn> columns) {
            this.columns = SelectColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(SelectColumn ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(Consumer<SelectColumn.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (SelectColumn)((SelectColumn.Builder)SelectColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterMapping.Builder> getParameters() {
            List<ParameterMapping.Builder> result = ParameterMappingListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ParameterMapping.BuilderImpl> parameters) {
            this.parameters = ParameterMappingListCopier.copyFromBuilder(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Collection<ParameterMapping> parameters) {
            this.parameters = ParameterMappingListCopier.copy(parameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(ParameterMapping ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Consumer<ParameterMapping.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ParameterMapping)((ParameterMapping.Builder)ParameterMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PrepareQueryResponse build() {
            return new PrepareQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TimestreamQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PrepareQueryResponse> {
        public Builder queryString(String var1);

        public Builder columns(Collection<SelectColumn> var1);

        public Builder columns(SelectColumn ... var1);

        public Builder columns(Consumer<SelectColumn.Builder> ... var1);

        public Builder parameters(Collection<ParameterMapping> var1);

        public Builder parameters(ParameterMapping ... var1);

        public Builder parameters(Consumer<ParameterMapping.Builder> ... var1);
    }
}

