/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalarType {
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    BIGINT("BIGINT"),
    DOUBLE("DOUBLE"),
    TIMESTAMP("TIMESTAMP"),
    DATE("DATE"),
    TIME("TIME"),
    INTERVAL_DAY_TO_SECOND("INTERVAL_DAY_TO_SECOND"),
    INTERVAL_YEAR_TO_MONTH("INTERVAL_YEAR_TO_MONTH"),
    UNKNOWN("UNKNOWN"),
    INTEGER("INTEGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalarType> VALUE_MAP;
    private final String value;

    private ScalarType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalarType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalarType> knownValues() {
        EnumSet<ScalarType> knownValues = EnumSet.allOf(ScalarType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalarType.class, ScalarType::toString);
    }
}

