/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ClusterDeploymentType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ClusterStatus;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbStorageType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.FailoverMode;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogDeliveryConfiguration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.NetworkType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.services.timestreaminfluxdb.model.VpcSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDbClusterResponse
extends TimestreamInfluxDbResponse
implements ToCopyableBuilder<Builder, GetDbClusterResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetDbClusterResponse.getter(GetDbClusterResponse::id)).setter(GetDbClusterResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetDbClusterResponse.getter(GetDbClusterResponse::name)).setter(GetDbClusterResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetDbClusterResponse.getter(GetDbClusterResponse::arn)).setter(GetDbClusterResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDbClusterResponse.getter(GetDbClusterResponse::statusAsString)).setter(GetDbClusterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(GetDbClusterResponse.getter(GetDbClusterResponse::endpoint)).setter(GetDbClusterResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readerEndpoint").getter(GetDbClusterResponse.getter(GetDbClusterResponse::readerEndpoint)).setter(GetDbClusterResponse.setter(Builder::readerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readerEndpoint").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(GetDbClusterResponse.getter(GetDbClusterResponse::port)).setter(GetDbClusterResponse.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(GetDbClusterResponse.getter(GetDbClusterResponse::deploymentTypeAsString)).setter(GetDbClusterResponse.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceType").getter(GetDbClusterResponse.getter(GetDbClusterResponse::dbInstanceTypeAsString)).setter(GetDbClusterResponse.setter(Builder::dbInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkType").getter(GetDbClusterResponse.getter(GetDbClusterResponse::networkTypeAsString)).setter(GetDbClusterResponse.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()}).build();
    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbStorageType").getter(GetDbClusterResponse.getter(GetDbClusterResponse::dbStorageTypeAsString)).setter(GetDbClusterResponse.setter(Builder::dbStorageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allocatedStorage").getter(GetDbClusterResponse.getter(GetDbClusterResponse::allocatedStorage)).setter(GetDbClusterResponse.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(GetDbClusterResponse.getter(GetDbClusterResponse::publiclyAccessible)).setter(GetDbClusterResponse.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbParameterGroupIdentifier").getter(GetDbClusterResponse.getter(GetDbClusterResponse::dbParameterGroupIdentifier)).setter(GetDbClusterResponse.setter(Builder::dbParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build()}).build();
    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration").getter(GetDbClusterResponse.getter(GetDbClusterResponse::logDeliveryConfiguration)).setter(GetDbClusterResponse.setter(Builder::logDeliveryConfiguration)).constructor(LogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build()}).build();
    private static final SdkField<String> INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("influxAuthParametersSecretArn").getter(GetDbClusterResponse.getter(GetDbClusterResponse::influxAuthParametersSecretArn)).setter(GetDbClusterResponse.setter(Builder::influxAuthParametersSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxAuthParametersSecretArn").build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSubnetIds").getter(GetDbClusterResponse.getter(GetDbClusterResponse::vpcSubnetIds)).setter(GetDbClusterResponse.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(GetDbClusterResponse.getter(GetDbClusterResponse::vpcSecurityGroupIds)).setter(GetDbClusterResponse.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILOVER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failoverMode").getter(GetDbClusterResponse.getter(GetDbClusterResponse::failoverModeAsString)).setter(GetDbClusterResponse.setter(Builder::failoverMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, STATUS_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, PORT_FIELD, DEPLOYMENT_TYPE_FIELD, DB_INSTANCE_TYPE_FIELD, NETWORK_TYPE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, PUBLICLY_ACCESSIBLE_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, LOG_DELIVERY_CONFIGURATION_FIELD, INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, FAILOVER_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDbClusterResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String arn;
    private final String status;
    private final String endpoint;
    private final String readerEndpoint;
    private final Integer port;
    private final String deploymentType;
    private final String dbInstanceType;
    private final String networkType;
    private final String dbStorageType;
    private final Integer allocatedStorage;
    private final Boolean publiclyAccessible;
    private final String dbParameterGroupIdentifier;
    private final LogDeliveryConfiguration logDeliveryConfiguration;
    private final String influxAuthParametersSecretArn;
    private final List<String> vpcSubnetIds;
    private final List<String> vpcSecurityGroupIds;
    private final String failoverMode;

    private GetDbClusterResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.port = builder.port;
        this.deploymentType = builder.deploymentType;
        this.dbInstanceType = builder.dbInstanceType;
        this.networkType = builder.networkType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.influxAuthParametersSecretArn = builder.influxAuthParametersSecretArn;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.failoverMode = builder.failoverMode;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String readerEndpoint() {
        return this.readerEndpoint;
    }

    public final Integer port() {
        return this.port;
    }

    public final ClusterDeploymentType deploymentType() {
        return ClusterDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(this.dbInstanceType);
    }

    public final String dbInstanceTypeAsString() {
        return this.dbInstanceType;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(this.dbStorageType);
    }

    public final String dbStorageTypeAsString() {
        return this.dbStorageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final String dbParameterGroupIdentifier() {
        return this.dbParameterGroupIdentifier;
    }

    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return this.logDeliveryConfiguration;
    }

    public final String influxAuthParametersSecretArn() {
        return this.influxAuthParametersSecretArn;
    }

    public final boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final FailoverMode failoverMode() {
        return FailoverMode.fromValue(this.failoverMode);
    }

    public final String failoverModeAsString() {
        return this.failoverMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxAuthParametersSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDbClusterResponse)) {
            return false;
        }
        GetDbClusterResponse other = (GetDbClusterResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.dbInstanceTypeAsString(), other.dbInstanceTypeAsString()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && Objects.equals(this.dbStorageTypeAsString(), other.dbStorageTypeAsString()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier()) && Objects.equals(this.logDeliveryConfiguration(), other.logDeliveryConfiguration()) && Objects.equals(this.influxAuthParametersSecretArn(), other.influxAuthParametersSecretArn()) && this.hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.failoverModeAsString(), other.failoverModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDbClusterResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("Endpoint", (Object)this.endpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("Port", (Object)this.port()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("DbInstanceType", (Object)this.dbInstanceTypeAsString()).add("NetworkType", (Object)this.networkTypeAsString()).add("DbStorageType", (Object)this.dbStorageTypeAsString()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("DbParameterGroupIdentifier", (Object)this.dbParameterGroupIdentifier()).add("LogDeliveryConfiguration", (Object)this.logDeliveryConfiguration()).add("InfluxAuthParametersSecretArn", (Object)this.influxAuthParametersSecretArn()).add("VpcSubnetIds", this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("FailoverMode", (Object)this.failoverModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "readerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readerEndpoint()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "dbInstanceType": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceTypeAsString()));
            }
            case "networkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "dbStorageType": {
                return Optional.ofNullable(clazz.cast(this.dbStorageTypeAsString()));
            }
            case "allocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "dbParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupIdentifier()));
            }
            case "logDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfiguration()));
            }
            case "influxAuthParametersSecretArn": {
                return Optional.ofNullable(clazz.cast(this.influxAuthParametersSecretArn()));
            }
            case "vpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "failoverMode": {
                return Optional.ofNullable(clazz.cast(this.failoverModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("readerEndpoint", READER_ENDPOINT_FIELD);
        map.put("port", PORT_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        map.put("dbStorageType", DB_STORAGE_TYPE_FIELD);
        map.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("influxAuthParametersSecretArn", INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD);
        map.put("vpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("failoverMode", FAILOVER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDbClusterResponse, T> g) {
        return obj -> g.apply((GetDbClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamInfluxDbResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String status;
        private String endpoint;
        private String readerEndpoint;
        private Integer port;
        private String deploymentType;
        private String dbInstanceType;
        private String networkType;
        private String dbStorageType;
        private Integer allocatedStorage;
        private Boolean publiclyAccessible;
        private String dbParameterGroupIdentifier;
        private LogDeliveryConfiguration logDeliveryConfiguration;
        private String influxAuthParametersSecretArn;
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String failoverMode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDbClusterResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.status(model.status);
            this.endpoint(model.endpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.port(model.port);
            this.deploymentType(model.deploymentType);
            this.dbInstanceType(model.dbInstanceType);
            this.networkType(model.networkType);
            this.dbStorageType(model.dbStorageType);
            this.allocatedStorage(model.allocatedStorage);
            this.publiclyAccessible(model.publiclyAccessible);
            this.dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            this.logDeliveryConfiguration(model.logDeliveryConfiguration);
            this.influxAuthParametersSecretArn(model.influxAuthParametersSecretArn);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.failoverMode(model.failoverMode);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return this.readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(ClusterDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDbInstanceType() {
            return this.dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return this.dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return this.dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return this.logDeliveryConfiguration != null ? this.logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getInfluxAuthParametersSecretArn() {
            return this.influxAuthParametersSecretArn;
        }

        public final void setInfluxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
        }

        @Override
        public final Builder influxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (this.vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getFailoverMode() {
            return this.failoverMode;
        }

        public final void setFailoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
        }

        @Override
        public final Builder failoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
            return this;
        }

        @Override
        public final Builder failoverMode(FailoverMode failoverMode) {
            this.failoverMode(failoverMode == null ? null : failoverMode.toString());
            return this;
        }

        @Override
        public GetDbClusterResponse build() {
            return new GetDbClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamInfluxDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDbClusterResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder endpoint(String var1);

        public Builder readerEndpoint(String var1);

        public Builder port(Integer var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(ClusterDeploymentType var1);

        public Builder dbInstanceType(String var1);

        public Builder dbInstanceType(DbInstanceType var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder dbStorageType(String var1);

        public Builder dbStorageType(DbStorageType var1);

        public Builder allocatedStorage(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder dbParameterGroupIdentifier(String var1);

        public Builder logDeliveryConfiguration(LogDeliveryConfiguration var1);

        default public Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return this.logDeliveryConfiguration((LogDeliveryConfiguration)((LogDeliveryConfiguration.Builder)LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration)).build());
        }

        public Builder influxAuthParametersSecretArn(String var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder failoverMode(String var1);

        public Builder failoverMode(FailoverMode var1);
    }
}

