/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.FailoverMode;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogDeliveryConfiguration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDbClusterRequest
extends TimestreamInfluxDbRequest
implements ToCopyableBuilder<Builder, UpdateDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbClusterId").getter(UpdateDbClusterRequest.getter(UpdateDbClusterRequest::dbClusterId)).setter(UpdateDbClusterRequest.setter(Builder::dbClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterId").build()}).build();
    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration").getter(UpdateDbClusterRequest.getter(UpdateDbClusterRequest::logDeliveryConfiguration)).setter(UpdateDbClusterRequest.setter(Builder::logDeliveryConfiguration)).constructor(LogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbParameterGroupIdentifier").getter(UpdateDbClusterRequest.getter(UpdateDbClusterRequest::dbParameterGroupIdentifier)).setter(UpdateDbClusterRequest.setter(Builder::dbParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(UpdateDbClusterRequest.getter(UpdateDbClusterRequest::port)).setter(UpdateDbClusterRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceType").getter(UpdateDbClusterRequest.getter(UpdateDbClusterRequest::dbInstanceTypeAsString)).setter(UpdateDbClusterRequest.setter(Builder::dbInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()}).build();
    private static final SdkField<String> FAILOVER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failoverMode").getter(UpdateDbClusterRequest.getter(UpdateDbClusterRequest::failoverModeAsString)).setter(UpdateDbClusterRequest.setter(Builder::failoverMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ID_FIELD, LOG_DELIVERY_CONFIGURATION_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, PORT_FIELD, DB_INSTANCE_TYPE_FIELD, FAILOVER_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDbClusterRequest.memberNameToFieldInitializer();
    private final String dbClusterId;
    private final LogDeliveryConfiguration logDeliveryConfiguration;
    private final String dbParameterGroupIdentifier;
    private final Integer port;
    private final String dbInstanceType;
    private final String failoverMode;

    private UpdateDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterId = builder.dbClusterId;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.port = builder.port;
        this.dbInstanceType = builder.dbInstanceType;
        this.failoverMode = builder.failoverMode;
    }

    public final String dbClusterId() {
        return this.dbClusterId;
    }

    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return this.logDeliveryConfiguration;
    }

    public final String dbParameterGroupIdentifier() {
        return this.dbParameterGroupIdentifier;
    }

    public final Integer port() {
        return this.port;
    }

    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(this.dbInstanceType);
    }

    public final String dbInstanceTypeAsString() {
        return this.dbInstanceType;
    }

    public final FailoverMode failoverMode() {
        return FailoverMode.fromValue(this.failoverMode);
    }

    public final String failoverModeAsString() {
        return this.failoverMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDbClusterRequest)) {
            return false;
        }
        UpdateDbClusterRequest other = (UpdateDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterId(), other.dbClusterId()) && Objects.equals(this.logDeliveryConfiguration(), other.logDeliveryConfiguration()) && Objects.equals(this.dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbInstanceTypeAsString(), other.dbInstanceTypeAsString()) && Objects.equals(this.failoverModeAsString(), other.failoverModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDbClusterRequest").add("DbClusterId", (Object)this.dbClusterId()).add("LogDeliveryConfiguration", (Object)this.logDeliveryConfiguration()).add("DbParameterGroupIdentifier", (Object)this.dbParameterGroupIdentifier()).add("Port", (Object)this.port()).add("DbInstanceType", (Object)this.dbInstanceTypeAsString()).add("FailoverMode", (Object)this.failoverModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbClusterId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterId()));
            }
            case "logDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfiguration()));
            }
            case "dbParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupIdentifier()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "dbInstanceType": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceTypeAsString()));
            }
            case "failoverMode": {
                return Optional.ofNullable(clazz.cast(this.failoverModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbClusterId", DB_CLUSTER_ID_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("port", PORT_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("failoverMode", FAILOVER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDbClusterRequest, T> g) {
        return obj -> g.apply((UpdateDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamInfluxDbRequest.BuilderImpl
    implements Builder {
        private String dbClusterId;
        private LogDeliveryConfiguration logDeliveryConfiguration;
        private String dbParameterGroupIdentifier;
        private Integer port;
        private String dbInstanceType;
        private String failoverMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDbClusterRequest model) {
            super(model);
            this.dbClusterId(model.dbClusterId);
            this.logDeliveryConfiguration(model.logDeliveryConfiguration);
            this.dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            this.port(model.port);
            this.dbInstanceType(model.dbInstanceType);
            this.failoverMode(model.failoverMode);
        }

        public final String getDbClusterId() {
            return this.dbClusterId;
        }

        public final void setDbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
        }

        @Override
        public final Builder dbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return this.logDeliveryConfiguration != null ? this.logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return this.dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbInstanceType() {
            return this.dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getFailoverMode() {
            return this.failoverMode;
        }

        public final void setFailoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
        }

        @Override
        public final Builder failoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
            return this;
        }

        @Override
        public final Builder failoverMode(FailoverMode failoverMode) {
            this.failoverMode(failoverMode == null ? null : failoverMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDbClusterRequest build() {
            return new UpdateDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TimestreamInfluxDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDbClusterRequest> {
        public Builder dbClusterId(String var1);

        public Builder logDeliveryConfiguration(LogDeliveryConfiguration var1);

        default public Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return this.logDeliveryConfiguration((LogDeliveryConfiguration)((LogDeliveryConfiguration.Builder)LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration)).build());
        }

        public Builder dbParameterGroupIdentifier(String var1);

        public Builder port(Integer var1);

        public Builder dbInstanceType(String var1);

        public Builder dbInstanceType(DbInstanceType var1);

        public Builder failoverMode(String var1);

        public Builder failoverMode(FailoverMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

