/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DbStorageType {
    INFLUX_IO_INCLUDED_T1("InfluxIOIncludedT1"),
    INFLUX_IO_INCLUDED_T2("InfluxIOIncludedT2"),
    INFLUX_IO_INCLUDED_T3("InfluxIOIncludedT3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DbStorageType> VALUE_MAP;
    private final String value;

    private DbStorageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DbStorageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DbStorageType> knownValues() {
        EnumSet<DbStorageType> knownValues = EnumSet.allOf(DbStorageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DbStorageType.class, DbStorageType::toString);
    }
}

