/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbStorageType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeploymentType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DbInstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DbInstanceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DbInstanceSummary.getter(DbInstanceSummary::id)).setter(DbInstanceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DbInstanceSummary.getter(DbInstanceSummary::name)).setter(DbInstanceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DbInstanceSummary.getter(DbInstanceSummary::arn)).setter(DbInstanceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DbInstanceSummary.getter(DbInstanceSummary::statusAsString)).setter(DbInstanceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(DbInstanceSummary.getter(DbInstanceSummary::endpoint)).setter(DbInstanceSummary.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(DbInstanceSummary.getter(DbInstanceSummary::port)).setter(DbInstanceSummary.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceType").getter(DbInstanceSummary.getter(DbInstanceSummary::dbInstanceTypeAsString)).setter(DbInstanceSummary.setter(Builder::dbInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()}).build();
    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbStorageType").getter(DbInstanceSummary.getter(DbInstanceSummary::dbStorageTypeAsString)).setter(DbInstanceSummary.setter(Builder::dbStorageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allocatedStorage").getter(DbInstanceSummary.getter(DbInstanceSummary::allocatedStorage)).setter(DbInstanceSummary.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(DbInstanceSummary.getter(DbInstanceSummary::deploymentTypeAsString)).setter(DbInstanceSummary.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, STATUS_FIELD, ENDPOINT_FIELD, PORT_FIELD, DB_INSTANCE_TYPE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, DEPLOYMENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String arn;
    private final String status;
    private final String endpoint;
    private final Integer port;
    private final String dbInstanceType;
    private final String dbStorageType;
    private final Integer allocatedStorage;
    private final String deploymentType;

    private DbInstanceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.port = builder.port;
        this.dbInstanceType = builder.dbInstanceType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.deploymentType = builder.deploymentType;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Integer port() {
        return this.port;
    }

    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(this.dbInstanceType);
    }

    public final String dbInstanceTypeAsString() {
        return this.dbInstanceType;
    }

    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(this.dbStorageType);
    }

    public final String dbStorageTypeAsString() {
        return this.dbStorageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbInstanceSummary)) {
            return false;
        }
        DbInstanceSummary other = (DbInstanceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbInstanceTypeAsString(), other.dbInstanceTypeAsString()) && Objects.equals(this.dbStorageTypeAsString(), other.dbStorageTypeAsString()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DbInstanceSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("Endpoint", (Object)this.endpoint()).add("Port", (Object)this.port()).add("DbInstanceType", (Object)this.dbInstanceTypeAsString()).add("DbStorageType", (Object)this.dbStorageTypeAsString()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("DeploymentType", (Object)this.deploymentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "dbInstanceType": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceTypeAsString()));
            }
            case "dbStorageType": {
                return Optional.ofNullable(clazz.cast(this.dbStorageTypeAsString()));
            }
            case "allocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DbInstanceSummary, T> g) {
        return obj -> g.apply((DbInstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String status;
        private String endpoint;
        private Integer port;
        private String dbInstanceType;
        private String dbStorageType;
        private Integer allocatedStorage;
        private String deploymentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DbInstanceSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.status(model.status);
            this.endpoint(model.endpoint);
            this.port(model.port);
            this.dbInstanceType(model.dbInstanceType);
            this.dbStorageType(model.dbStorageType);
            this.allocatedStorage(model.allocatedStorage);
            this.deploymentType(model.deploymentType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbInstanceType() {
            return this.dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return this.dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public DbInstanceSummary build() {
            return new DbInstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DbInstanceSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder endpoint(String var1);

        public Builder port(Integer var1);

        public Builder dbInstanceType(String var1);

        public Builder dbInstanceType(DbInstanceType var1);

        public Builder dbStorageType(String var1);

        public Builder dbStorageType(DbStorageType var1);

        public Builder allocatedStorage(Integer var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);
    }
}

