/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Duration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Duration> {
    private static final SdkField<String> DURATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("durationType").getter(Duration.getter(Duration::durationTypeAsString)).setter(Duration.setter(Builder::durationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationType").build()}).build();
    private static final SdkField<Long> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("value").getter(Duration.getter(Duration::value)).setter(Duration.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_TYPE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String durationType;
    private final Long value;

    private Duration(BuilderImpl builder) {
        this.durationType = builder.durationType;
        this.value = builder.value;
    }

    public final DurationType durationType() {
        return DurationType.fromValue(this.durationType);
    }

    public final String durationTypeAsString() {
        return this.durationType;
    }

    public final Long value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)obj;
        return Objects.equals(this.durationTypeAsString(), other.durationTypeAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"Duration").add("DurationType", (Object)this.durationTypeAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "durationType": {
                return Optional.ofNullable(clazz.cast(this.durationTypeAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Duration, T> g) {
        return obj -> g.apply((Duration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String durationType;
        private Long value;

        private BuilderImpl() {
        }

        private BuilderImpl(Duration model) {
            this.durationType(model.durationType);
            this.value(model.value);
        }

        public final String getDurationType() {
            return this.durationType;
        }

        public final void setDurationType(String durationType) {
            this.durationType = durationType;
        }

        @Override
        public final Builder durationType(String durationType) {
            this.durationType = durationType;
            return this;
        }

        @Override
        public final Builder durationType(DurationType durationType) {
            this.durationType(durationType == null ? null : durationType.toString());
            return this;
        }

        public final Long getValue() {
            return this.value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public Duration build() {
            return new Duration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Duration> {
        public Builder durationType(String var1);

        public Builder durationType(DurationType var1);

        public Builder value(Long var1);
    }
}

