/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbAsyncClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbParameterGroupSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsResponse;

public class ListDbParameterGroupsPublisher
implements SdkPublisher<ListDbParameterGroupsResponse> {
    private final TimestreamInfluxDbAsyncClient client;
    private final ListDbParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbParameterGroupsPublisher(TimestreamInfluxDbAsyncClient client, ListDbParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbParameterGroupsPublisher(TimestreamInfluxDbAsyncClient client, ListDbParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbParameterGroupSummary> items() {
        Function<ListDbParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbParameterGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbParameterGroupsResponseFetcher
    implements AsyncPageFetcher<ListDbParameterGroupsResponse> {
        private ListDbParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDbParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbParameterGroupsResponse> nextPage(ListDbParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDbParameterGroupsPublisher.this.client.listDbParameterGroups(ListDbParameterGroupsPublisher.this.firstRequest);
            }
            return ListDbParameterGroupsPublisher.this.client.listDbParameterGroups((ListDbParameterGroupsRequest)((Object)ListDbParameterGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

