/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Status {
    CREATING("CREATING"),
    AVAILABLE("AVAILABLE"),
    DELETING("DELETING"),
    MODIFYING("MODIFYING"),
    UPDATING("UPDATING"),
    DELETED("DELETED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Status> VALUE_MAP;
    private final String value;

    private Status(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Status fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Status> knownValues() {
        EnumSet<Status> knownValues = EnumSet.allOf(Status.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Status.class, Status::toString);
    }
}

