/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeDocumentRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, AnalyzeDocumentRequest> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::document)).setter(AnalyzeDocumentRequest.setter(Builder::document)).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::featureTypesAsStrings)).setter(AnalyzeDocumentRequest.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, FEATURE_TYPES_FIELD));
    private final Document document;
    private final List<String> featureTypes;

    private AnalyzeDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
        this.featureTypes = builder.featureTypes;
    }

    public Document document() {
        return this.document;
    }

    public List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeDocumentRequest)) {
            return false;
        }
        AnalyzeDocumentRequest other = (AnalyzeDocumentRequest)((Object)obj);
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"AnalyzeDocumentRequest").add("Document", (Object)this.document()).add("FeatureTypes", this.featureTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeDocumentRequest, T> g) {
        return obj -> g.apply((AnalyzeDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private Document document;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeDocumentRequest model) {
            super(model);
            this.document(model.document);
            this.featureTypesWithStrings(model.featureTypes);
        }

        public final Document.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        public final Collection<String> getFeatureTypesAsStrings() {
            return this.featureTypes;
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final void setFeatureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AnalyzeDocumentRequest build() {
            return new AnalyzeDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AnalyzeDocumentRequest> {
        public Builder document(Document var1);

        default public Builder document(Consumer<Document.Builder> document) {
            return this.document((Document)((Document.Builder)Document.builder().applyMutation(document)).build());
        }

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

