/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DocumentLocation;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.NotificationChannel;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDocumentAnalysisRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, StartDocumentAnalysisRequest> {
    private static final SdkField<DocumentLocation> DOCUMENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::documentLocation)).setter(StartDocumentAnalysisRequest.setter(Builder::documentLocation)).constructor(DocumentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentLocation").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::featureTypesAsStrings)).setter(StartDocumentAnalysisRequest.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::clientRequestToken)).setter(StartDocumentAnalysisRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::jobTag)).setter(StartDocumentAnalysisRequest.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::notificationChannel)).setter(StartDocumentAnalysisRequest.setter(Builder::notificationChannel)).constructor(NotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_LOCATION_FIELD, FEATURE_TYPES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, JOB_TAG_FIELD, NOTIFICATION_CHANNEL_FIELD));
    private final DocumentLocation documentLocation;
    private final List<String> featureTypes;
    private final String clientRequestToken;
    private final String jobTag;
    private final NotificationChannel notificationChannel;

    private StartDocumentAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.documentLocation = builder.documentLocation;
        this.featureTypes = builder.featureTypes;
        this.clientRequestToken = builder.clientRequestToken;
        this.jobTag = builder.jobTag;
        this.notificationChannel = builder.notificationChannel;
    }

    public DocumentLocation documentLocation() {
        return this.documentLocation;
    }

    public List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String jobTag() {
        return this.jobTag;
    }

    public NotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDocumentAnalysisRequest)) {
            return false;
        }
        StartDocumentAnalysisRequest other = (StartDocumentAnalysisRequest)((Object)obj);
        return Objects.equals(this.documentLocation(), other.documentLocation()) && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.jobTag(), other.jobTag()) && Objects.equals(this.notificationChannel(), other.notificationChannel());
    }

    public String toString() {
        return ToString.builder((String)"StartDocumentAnalysisRequest").add("DocumentLocation", (Object)this.documentLocation()).add("FeatureTypes", this.featureTypesAsStrings()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("JobTag", (Object)this.jobTag()).add("NotificationChannel", (Object)this.notificationChannel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentLocation": {
                return Optional.ofNullable(clazz.cast(this.documentLocation()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDocumentAnalysisRequest, T> g) {
        return obj -> g.apply((StartDocumentAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private DocumentLocation documentLocation;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private String jobTag;
        private NotificationChannel notificationChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDocumentAnalysisRequest model) {
            super(model);
            this.documentLocation(model.documentLocation);
            this.featureTypesWithStrings(model.featureTypes);
            this.clientRequestToken(model.clientRequestToken);
            this.jobTag(model.jobTag);
            this.notificationChannel(model.notificationChannel);
        }

        public final DocumentLocation.Builder getDocumentLocation() {
            return this.documentLocation != null ? this.documentLocation.toBuilder() : null;
        }

        @Override
        public final Builder documentLocation(DocumentLocation documentLocation) {
            this.documentLocation = documentLocation;
            return this;
        }

        public final void setDocumentLocation(DocumentLocation.BuilderImpl documentLocation) {
            this.documentLocation = documentLocation != null ? documentLocation.build() : null;
        }

        public final Collection<String> getFeatureTypesAsStrings() {
            return this.featureTypes;
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final void setFeatureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDocumentAnalysisRequest build() {
            return new StartDocumentAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDocumentAnalysisRequest> {
        public Builder documentLocation(DocumentLocation var1);

        default public Builder documentLocation(Consumer<DocumentLocation.Builder> documentLocation) {
            return this.documentLocation((DocumentLocation)((DocumentLocation.Builder)DocumentLocation.builder().applyMutation(documentLocation)).build());
        }

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder clientRequestToken(String var1);

        public Builder jobTag(String var1);

        public Builder notificationChannel(NotificationChannel var1);

        default public Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

