/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.ExpenseCurrency;
import software.amazon.awssdk.services.textract.model.ExpenseDetection;
import software.amazon.awssdk.services.textract.model.ExpenseGroupProperty;
import software.amazon.awssdk.services.textract.model.ExpenseGroupPropertyListCopier;
import software.amazon.awssdk.services.textract.model.ExpenseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpenseField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpenseField> {
    private static final SdkField<ExpenseType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Type").getter(ExpenseField.getter(ExpenseField::type)).setter(ExpenseField.setter(Builder::type)).constructor(ExpenseType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ExpenseDetection> LABEL_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelDetection").getter(ExpenseField.getter(ExpenseField::labelDetection)).setter(ExpenseField.setter(Builder::labelDetection)).constructor(ExpenseDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDetection").build()}).build();
    private static final SdkField<ExpenseDetection> VALUE_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueDetection").getter(ExpenseField.getter(ExpenseField::valueDetection)).setter(ExpenseField.setter(Builder::valueDetection)).constructor(ExpenseDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetection").build()}).build();
    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageNumber").getter(ExpenseField.getter(ExpenseField::pageNumber)).setter(ExpenseField.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()}).build();
    private static final SdkField<ExpenseCurrency> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Currency").getter(ExpenseField.getter(ExpenseField::currency)).setter(ExpenseField.setter(Builder::currency)).constructor(ExpenseCurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()}).build();
    private static final SdkField<List<ExpenseGroupProperty>> GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupProperties").getter(ExpenseField.getter(ExpenseField::groupProperties)).setter(ExpenseField.setter(Builder::groupProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpenseGroupProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LABEL_DETECTION_FIELD, VALUE_DETECTION_FIELD, PAGE_NUMBER_FIELD, CURRENCY_FIELD, GROUP_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpenseField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExpenseType type;
    private final ExpenseDetection labelDetection;
    private final ExpenseDetection valueDetection;
    private final Integer pageNumber;
    private final ExpenseCurrency currency;
    private final List<ExpenseGroupProperty> groupProperties;

    private ExpenseField(BuilderImpl builder) {
        this.type = builder.type;
        this.labelDetection = builder.labelDetection;
        this.valueDetection = builder.valueDetection;
        this.pageNumber = builder.pageNumber;
        this.currency = builder.currency;
        this.groupProperties = builder.groupProperties;
    }

    public final ExpenseType type() {
        return this.type;
    }

    public final ExpenseDetection labelDetection() {
        return this.labelDetection;
    }

    public final ExpenseDetection valueDetection() {
        return this.valueDetection;
    }

    public final Integer pageNumber() {
        return this.pageNumber;
    }

    public final ExpenseCurrency currency() {
        return this.currency;
    }

    public final boolean hasGroupProperties() {
        return this.groupProperties != null && !(this.groupProperties instanceof SdkAutoConstructList);
    }

    public final List<ExpenseGroupProperty> groupProperties() {
        return this.groupProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupProperties() ? this.groupProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseField)) {
            return false;
        }
        ExpenseField other = (ExpenseField)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.labelDetection(), other.labelDetection()) && Objects.equals(this.valueDetection(), other.valueDetection()) && Objects.equals(this.pageNumber(), other.pageNumber()) && Objects.equals(this.currency(), other.currency()) && this.hasGroupProperties() == other.hasGroupProperties() && Objects.equals(this.groupProperties(), other.groupProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ExpenseField").add("Type", (Object)this.type()).add("LabelDetection", (Object)this.labelDetection()).add("ValueDetection", (Object)this.valueDetection()).add("PageNumber", (Object)this.pageNumber()).add("Currency", (Object)this.currency()).add("GroupProperties", this.hasGroupProperties() ? this.groupProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "LabelDetection": {
                return Optional.ofNullable(clazz.cast(this.labelDetection()));
            }
            case "ValueDetection": {
                return Optional.ofNullable(clazz.cast(this.valueDetection()));
            }
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
            case "Currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
            case "GroupProperties": {
                return Optional.ofNullable(clazz.cast(this.groupProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("LabelDetection", LABEL_DETECTION_FIELD);
        map.put("ValueDetection", VALUE_DETECTION_FIELD);
        map.put("PageNumber", PAGE_NUMBER_FIELD);
        map.put("Currency", CURRENCY_FIELD);
        map.put("GroupProperties", GROUP_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpenseField, T> g) {
        return obj -> g.apply((ExpenseField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExpenseType type;
        private ExpenseDetection labelDetection;
        private ExpenseDetection valueDetection;
        private Integer pageNumber;
        private ExpenseCurrency currency;
        private List<ExpenseGroupProperty> groupProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseField model) {
            this.type(model.type);
            this.labelDetection(model.labelDetection);
            this.valueDetection(model.valueDetection);
            this.pageNumber(model.pageNumber);
            this.currency(model.currency);
            this.groupProperties(model.groupProperties);
        }

        public final ExpenseType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(ExpenseType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ExpenseType type) {
            this.type = type;
            return this;
        }

        public final ExpenseDetection.Builder getLabelDetection() {
            return this.labelDetection != null ? this.labelDetection.toBuilder() : null;
        }

        public final void setLabelDetection(ExpenseDetection.BuilderImpl labelDetection) {
            this.labelDetection = labelDetection != null ? labelDetection.build() : null;
        }

        @Override
        public final Builder labelDetection(ExpenseDetection labelDetection) {
            this.labelDetection = labelDetection;
            return this;
        }

        public final ExpenseDetection.Builder getValueDetection() {
            return this.valueDetection != null ? this.valueDetection.toBuilder() : null;
        }

        public final void setValueDetection(ExpenseDetection.BuilderImpl valueDetection) {
            this.valueDetection = valueDetection != null ? valueDetection.build() : null;
        }

        @Override
        public final Builder valueDetection(ExpenseDetection valueDetection) {
            this.valueDetection = valueDetection;
            return this;
        }

        public final Integer getPageNumber() {
            return this.pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final ExpenseCurrency.Builder getCurrency() {
            return this.currency != null ? this.currency.toBuilder() : null;
        }

        public final void setCurrency(ExpenseCurrency.BuilderImpl currency) {
            this.currency = currency != null ? currency.build() : null;
        }

        @Override
        public final Builder currency(ExpenseCurrency currency) {
            this.currency = currency;
            return this;
        }

        public final List<ExpenseGroupProperty.Builder> getGroupProperties() {
            List<ExpenseGroupProperty.Builder> result = ExpenseGroupPropertyListCopier.copyToBuilder(this.groupProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupProperties(Collection<ExpenseGroupProperty.BuilderImpl> groupProperties) {
            this.groupProperties = ExpenseGroupPropertyListCopier.copyFromBuilder(groupProperties);
        }

        @Override
        public final Builder groupProperties(Collection<ExpenseGroupProperty> groupProperties) {
            this.groupProperties = ExpenseGroupPropertyListCopier.copy(groupProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupProperties(ExpenseGroupProperty ... groupProperties) {
            this.groupProperties(Arrays.asList(groupProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupProperties(Consumer<ExpenseGroupProperty.Builder> ... groupProperties) {
            this.groupProperties(Stream.of(groupProperties).map(c -> (ExpenseGroupProperty)((ExpenseGroupProperty.Builder)ExpenseGroupProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExpenseField build() {
            return new ExpenseField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpenseField> {
        public Builder type(ExpenseType var1);

        default public Builder type(Consumer<ExpenseType.Builder> type) {
            return this.type((ExpenseType)((ExpenseType.Builder)ExpenseType.builder().applyMutation(type)).build());
        }

        public Builder labelDetection(ExpenseDetection var1);

        default public Builder labelDetection(Consumer<ExpenseDetection.Builder> labelDetection) {
            return this.labelDetection((ExpenseDetection)((ExpenseDetection.Builder)ExpenseDetection.builder().applyMutation(labelDetection)).build());
        }

        public Builder valueDetection(ExpenseDetection var1);

        default public Builder valueDetection(Consumer<ExpenseDetection.Builder> valueDetection) {
            return this.valueDetection((ExpenseDetection)((ExpenseDetection.Builder)ExpenseDetection.builder().applyMutation(valueDetection)).build());
        }

        public Builder pageNumber(Integer var1);

        public Builder currency(ExpenseCurrency var1);

        default public Builder currency(Consumer<ExpenseCurrency.Builder> currency) {
            return this.currency((ExpenseCurrency)((ExpenseCurrency.Builder)ExpenseCurrency.builder().applyMutation(currency)).build());
        }

        public Builder groupProperties(Collection<ExpenseGroupProperty> var1);

        public Builder groupProperties(ExpenseGroupProperty ... var1);

        public Builder groupProperties(Consumer<ExpenseGroupProperty.Builder> ... var1);
    }
}

