/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Holds the structured data returned by AnalyzeDocument for lending documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LendingDocument implements SdkPojo, Serializable, ToCopyableBuilder<LendingDocument.Builder, LendingDocument> {
    private static final SdkField<List<LendingField>> LENDING_FIELDS_FIELD = SdkField
            .<List<LendingField>> builder(MarshallingType.LIST)
            .memberName("LendingFields")
            .getter(getter(LendingDocument::lendingFields))
            .setter(setter(Builder::lendingFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LendingFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LendingField> builder(MarshallingType.SDK_POJO)
                                            .constructor(LendingField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SignatureDetection>> SIGNATURE_DETECTIONS_FIELD = SdkField
            .<List<SignatureDetection>> builder(MarshallingType.LIST)
            .memberName("SignatureDetections")
            .getter(getter(LendingDocument::signatureDetections))
            .setter(setter(Builder::signatureDetections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignatureDetections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignatureDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignatureDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENDING_FIELDS_FIELD,
            SIGNATURE_DETECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LendingField> lendingFields;

    private final List<SignatureDetection> signatureDetections;

    private LendingDocument(BuilderImpl builder) {
        this.lendingFields = builder.lendingFields;
        this.signatureDetections = builder.signatureDetections;
    }

    /**
     * For responses, this returns true if the service returned a value for the LendingFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLendingFields() {
        return lendingFields != null && !(lendingFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of LendingField objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLendingFields} method.
     * </p>
     * 
     * @return An array of LendingField objects.
     */
    public final List<LendingField> lendingFields() {
        return lendingFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignatureDetections property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSignatureDetections() {
        return signatureDetections != null && !(signatureDetections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signatures detected in a lending document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignatureDetections} method.
     * </p>
     * 
     * @return A list of signatures detected in a lending document.
     */
    public final List<SignatureDetection> signatureDetections() {
        return signatureDetections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLendingFields() ? lendingFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSignatureDetections() ? signatureDetections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingDocument)) {
            return false;
        }
        LendingDocument other = (LendingDocument) obj;
        return hasLendingFields() == other.hasLendingFields() && Objects.equals(lendingFields(), other.lendingFields())
                && hasSignatureDetections() == other.hasSignatureDetections()
                && Objects.equals(signatureDetections(), other.signatureDetections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LendingDocument").add("LendingFields", hasLendingFields() ? lendingFields() : null)
                .add("SignatureDetections", hasSignatureDetections() ? signatureDetections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LendingFields":
            return Optional.ofNullable(clazz.cast(lendingFields()));
        case "SignatureDetections":
            return Optional.ofNullable(clazz.cast(signatureDetections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LendingFields", LENDING_FIELDS_FIELD);
        map.put("SignatureDetections", SIGNATURE_DETECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LendingDocument, T> g) {
        return obj -> g.apply((LendingDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LendingDocument> {
        /**
         * <p>
         * An array of LendingField objects.
         * </p>
         * 
         * @param lendingFields
         *        An array of LendingField objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lendingFields(Collection<LendingField> lendingFields);

        /**
         * <p>
         * An array of LendingField objects.
         * </p>
         * 
         * @param lendingFields
         *        An array of LendingField objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lendingFields(LendingField... lendingFields);

        /**
         * <p>
         * An array of LendingField objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.LendingField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.LendingField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.LendingField.Builder#build()} is called immediately and
         * its result is passed to {@link #lendingFields(List<LendingField>)}.
         * 
         * @param lendingFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.LendingField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lendingFields(java.util.Collection<LendingField>)
         */
        Builder lendingFields(Consumer<LendingField.Builder>... lendingFields);

        /**
         * <p>
         * A list of signatures detected in a lending document.
         * </p>
         * 
         * @param signatureDetections
         *        A list of signatures detected in a lending document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureDetections(Collection<SignatureDetection> signatureDetections);

        /**
         * <p>
         * A list of signatures detected in a lending document.
         * </p>
         * 
         * @param signatureDetections
         *        A list of signatures detected in a lending document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureDetections(SignatureDetection... signatureDetections);

        /**
         * <p>
         * A list of signatures detected in a lending document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.SignatureDetection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.textract.model.SignatureDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.SignatureDetection.Builder#build()} is called
         * immediately and its result is passed to {@link #signatureDetections(List<SignatureDetection>)}.
         * 
         * @param signatureDetections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.SignatureDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signatureDetections(java.util.Collection<SignatureDetection>)
         */
        Builder signatureDetections(Consumer<SignatureDetection.Builder>... signatureDetections);
    }

    static final class BuilderImpl implements Builder {
        private List<LendingField> lendingFields = DefaultSdkAutoConstructList.getInstance();

        private List<SignatureDetection> signatureDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingDocument model) {
            lendingFields(model.lendingFields);
            signatureDetections(model.signatureDetections);
        }

        public final List<LendingField.Builder> getLendingFields() {
            List<LendingField.Builder> result = LendingFieldListCopier.copyToBuilder(this.lendingFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLendingFields(Collection<LendingField.BuilderImpl> lendingFields) {
            this.lendingFields = LendingFieldListCopier.copyFromBuilder(lendingFields);
        }

        @Override
        public final Builder lendingFields(Collection<LendingField> lendingFields) {
            this.lendingFields = LendingFieldListCopier.copy(lendingFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lendingFields(LendingField... lendingFields) {
            lendingFields(Arrays.asList(lendingFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lendingFields(Consumer<LendingField.Builder>... lendingFields) {
            lendingFields(Stream.of(lendingFields).map(c -> LendingField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SignatureDetection.Builder> getSignatureDetections() {
            List<SignatureDetection.Builder> result = SignatureDetectionListCopier.copyToBuilder(this.signatureDetections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignatureDetections(Collection<SignatureDetection.BuilderImpl> signatureDetections) {
            this.signatureDetections = SignatureDetectionListCopier.copyFromBuilder(signatureDetections);
        }

        @Override
        public final Builder signatureDetections(Collection<SignatureDetection> signatureDetections) {
            this.signatureDetections = SignatureDetectionListCopier.copy(signatureDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signatureDetections(SignatureDetection... signatureDetections) {
            signatureDetections(Arrays.asList(signatureDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signatureDetections(Consumer<SignatureDetection.Builder>... signatureDetections) {
            signatureDetections(Stream.of(signatureDetections).map(c -> SignatureDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LendingDocument build() {
            return new LendingDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
