/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLendingAnalysisSummaryResponse extends TextractResponse implements
        ToCopyableBuilder<GetLendingAnalysisSummaryResponse.Builder, GetLendingAnalysisSummaryResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(GetLendingAnalysisSummaryResponse::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetLendingAnalysisSummaryResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<LendingSummary> SUMMARY_FIELD = SdkField.<LendingSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Summary").getter(getter(GetLendingAnalysisSummaryResponse::summary)).setter(setter(Builder::summary))
            .constructor(LendingSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField
            .<List<Warning>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(GetLendingAnalysisSummaryResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Warning> builder(MarshallingType.SDK_POJO)
                                            .constructor(Warning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetLendingAnalysisSummaryResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> ANALYZE_LENDING_MODEL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnalyzeLendingModelVersion")
            .getter(getter(GetLendingAnalysisSummaryResponse::analyzeLendingModelVersion))
            .setter(setter(Builder::analyzeLendingModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeLendingModelVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD,
            JOB_STATUS_FIELD, SUMMARY_FIELD, WARNINGS_FIELD, STATUS_MESSAGE_FIELD, ANALYZE_LENDING_MODEL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DocumentMetadata documentMetadata;

    private final String jobStatus;

    private final LendingSummary summary;

    private final List<Warning> warnings;

    private final String statusMessage;

    private final String analyzeLendingModelVersion;

    private GetLendingAnalysisSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.jobStatus = builder.jobStatus;
        this.summary = builder.summary;
        this.warnings = builder.warnings;
        this.statusMessage = builder.statusMessage;
        this.analyzeLendingModelVersion = builder.analyzeLendingModelVersion;
    }

    /**
     * Returns the value of the DocumentMetadata property for this object.
     * 
     * @return The value of the DocumentMetadata property for this object.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * <p>
     * The current status of the lending analysis job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the lending analysis job.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the lending analysis job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the lending analysis job.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * Contains summary information for documents grouped by type.
     * </p>
     * 
     * @return Contains summary information for documents grouped by type.
     */
    public final LendingSummary summary() {
        return summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of warnings that occurred during the lending analysis operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return A list of warnings that occurred during the lending analysis operation.
     */
    public final List<Warning> warnings() {
        return warnings;
    }

    /**
     * <p>
     * Returns if the lending analysis could not be completed. Contains explanation for what error occurred.
     * </p>
     * 
     * @return Returns if the lending analysis could not be completed. Contains explanation for what error occurred.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The current model version of the Analyze Lending API.
     * </p>
     * 
     * @return The current model version of the Analyze Lending API.
     */
    public final String analyzeLendingModelVersion() {
        return analyzeLendingModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(analyzeLendingModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLendingAnalysisSummaryResponse)) {
            return false;
        }
        GetLendingAnalysisSummaryResponse other = (GetLendingAnalysisSummaryResponse) obj;
        return Objects.equals(documentMetadata(), other.documentMetadata())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(summary(), other.summary())
                && hasWarnings() == other.hasWarnings() && Objects.equals(warnings(), other.warnings())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(analyzeLendingModelVersion(), other.analyzeLendingModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLendingAnalysisSummaryResponse").add("DocumentMetadata", documentMetadata())
                .add("JobStatus", jobStatusAsString()).add("Summary", summary())
                .add("Warnings", hasWarnings() ? warnings() : null).add("StatusMessage", statusMessage())
                .add("AnalyzeLendingModelVersion", analyzeLendingModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "AnalyzeLendingModelVersion":
            return Optional.ofNullable(clazz.cast(analyzeLendingModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("AnalyzeLendingModelVersion", ANALYZE_LENDING_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLendingAnalysisSummaryResponse, T> g) {
        return obj -> g.apply((GetLendingAnalysisSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TextractResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLendingAnalysisSummaryResponse> {
        /**
         * Sets the value of the DocumentMetadata property for this object.
         *
         * @param documentMetadata
         *        The new value for the DocumentMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * Sets the value of the DocumentMetadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * The current status of the lending analysis job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the lending analysis job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the lending analysis job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the lending analysis job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * Contains summary information for documents grouped by type.
         * </p>
         * 
         * @param summary
         *        Contains summary information for documents grouped by type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(LendingSummary summary);

        /**
         * <p>
         * Contains summary information for documents grouped by type.
         * </p>
         * This is a convenience method that creates an instance of the {@link LendingSummary.Builder} avoiding the need
         * to create one manually via {@link LendingSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LendingSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(LendingSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link LendingSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(LendingSummary)
         */
        default Builder summary(Consumer<LendingSummary.Builder> summary) {
            return summary(LendingSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * A list of warnings that occurred during the lending analysis operation.
         * </p>
         * 
         * @param warnings
         *        A list of warnings that occurred during the lending analysis operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<Warning> warnings);

        /**
         * <p>
         * A list of warnings that occurred during the lending analysis operation.
         * </p>
         * 
         * @param warnings
         *        A list of warnings that occurred during the lending analysis operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Warning... warnings);

        /**
         * <p>
         * A list of warnings that occurred during the lending analysis operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Warning.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.Warning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Warning.Builder#build()} is called immediately and its
         * result is passed to {@link #warnings(List<Warning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Warning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(java.util.Collection<Warning>)
         */
        Builder warnings(Consumer<Warning.Builder>... warnings);

        /**
         * <p>
         * Returns if the lending analysis could not be completed. Contains explanation for what error occurred.
         * </p>
         * 
         * @param statusMessage
         *        Returns if the lending analysis could not be completed. Contains explanation for what error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The current model version of the Analyze Lending API.
         * </p>
         * 
         * @param analyzeLendingModelVersion
         *        The current model version of the Analyze Lending API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzeLendingModelVersion(String analyzeLendingModelVersion);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private DocumentMetadata documentMetadata;

        private String jobStatus;

        private LendingSummary summary;

        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private String statusMessage;

        private String analyzeLendingModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLendingAnalysisSummaryResponse model) {
            super(model);
            documentMetadata(model.documentMetadata);
            jobStatus(model.jobStatus);
            summary(model.summary);
            warnings(model.warnings);
            statusMessage(model.statusMessage);
            analyzeLendingModelVersion(model.analyzeLendingModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final LendingSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(LendingSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(LendingSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> Warning.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAnalyzeLendingModelVersion() {
            return analyzeLendingModelVersion;
        }

        public final void setAnalyzeLendingModelVersion(String analyzeLendingModelVersion) {
            this.analyzeLendingModelVersion = analyzeLendingModelVersion;
        }

        @Override
        public final Builder analyzeLendingModelVersion(String analyzeLendingModelVersion) {
            this.analyzeLendingModelVersion = analyzeLendingModelVersion;
            return this;
        }

        @Override
        public GetLendingAnalysisSummaryResponse build() {
            return new GetLendingAnalysisSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
