/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary info for an adapter version. Contains information on the AdapterId, AdapterVersion, CreationTime,
 * FeatureTypes, and Status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdapterVersionOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<AdapterVersionOverview.Builder, AdapterVersionOverview> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterId").getter(getter(AdapterVersionOverview::adapterId)).setter(setter(Builder::adapterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()).build();

    private static final SdkField<String> ADAPTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterVersion").getter(getter(AdapterVersionOverview::adapterVersion))
            .setter(setter(Builder::adapterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AdapterVersionOverview::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeatureTypes")
            .getter(getter(AdapterVersionOverview::featureTypesAsStrings))
            .setter(setter(Builder::featureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AdapterVersionOverview::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(AdapterVersionOverview::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD,
            ADAPTER_VERSION_FIELD, CREATION_TIME_FIELD, FEATURE_TYPES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adapterId;

    private final String adapterVersion;

    private final Instant creationTime;

    private final List<String> featureTypes;

    private final String status;

    private final String statusMessage;

    private AdapterVersionOverview(BuilderImpl builder) {
        this.adapterId = builder.adapterId;
        this.adapterVersion = builder.adapterVersion;
        this.creationTime = builder.creationTime;
        this.featureTypes = builder.featureTypes;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * A unique identifier for the adapter associated with a given adapter version.
     * </p>
     * 
     * @return A unique identifier for the adapter associated with a given adapter version.
     */
    public final String adapterId() {
        return adapterId;
    }

    /**
     * <p>
     * An identified for a given adapter version.
     * </p>
     * 
     * @return An identified for a given adapter version.
     */
    public final String adapterVersion() {
        return adapterVersion;
    }

    /**
     * <p>
     * The date and time that a given adapter version was created.
     * </p>
     * 
     * @return The date and time that a given adapter version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The feature types that the adapter version is operating on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return The feature types that the adapter version is operating on.
     */
    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(featureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureTypes() {
        return featureTypes != null && !(featureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The feature types that the adapter version is operating on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return The feature types that the adapter version is operating on.
     */
    public final List<String> featureTypesAsStrings() {
        return featureTypes;
    }

    /**
     * <p>
     * Contains information on the status of a given adapter version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AdapterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Contains information on the status of a given adapter version.
     * @see AdapterVersionStatus
     */
    public final AdapterVersionStatus status() {
        return AdapterVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * Contains information on the status of a given adapter version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AdapterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Contains information on the status of a given adapter version.
     * @see AdapterVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message explaining the status of a given adapter vesion.
     * </p>
     * 
     * @return A message explaining the status of a given adapter vesion.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(adapterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureTypes() ? featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdapterVersionOverview)) {
            return false;
        }
        AdapterVersionOverview other = (AdapterVersionOverview) obj;
        return Objects.equals(adapterId(), other.adapterId()) && Objects.equals(adapterVersion(), other.adapterVersion())
                && Objects.equals(creationTime(), other.creationTime()) && hasFeatureTypes() == other.hasFeatureTypes()
                && Objects.equals(featureTypesAsStrings(), other.featureTypesAsStrings())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdapterVersionOverview").add("AdapterId", adapterId()).add("AdapterVersion", adapterVersion())
                .add("CreationTime", creationTime()).add("FeatureTypes", hasFeatureTypes() ? featureTypesAsStrings() : null)
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterId":
            return Optional.ofNullable(clazz.cast(adapterId()));
        case "AdapterVersion":
            return Optional.ofNullable(clazz.cast(adapterVersion()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FeatureTypes":
            return Optional.ofNullable(clazz.cast(featureTypesAsStrings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("AdapterVersion", ADAPTER_VERSION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FeatureTypes", FEATURE_TYPES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdapterVersionOverview, T> g) {
        return obj -> g.apply((AdapterVersionOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdapterVersionOverview> {
        /**
         * <p>
         * A unique identifier for the adapter associated with a given adapter version.
         * </p>
         * 
         * @param adapterId
         *        A unique identifier for the adapter associated with a given adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterId(String adapterId);

        /**
         * <p>
         * An identified for a given adapter version.
         * </p>
         * 
         * @param adapterVersion
         *        An identified for a given adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterVersion(String adapterVersion);

        /**
         * <p>
         * The date and time that a given adapter version was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a given adapter version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The feature types that the adapter version is operating on.
         * </p>
         * 
         * @param featureTypes
         *        The feature types that the adapter version is operating on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(Collection<String> featureTypes);

        /**
         * <p>
         * The feature types that the adapter version is operating on.
         * </p>
         * 
         * @param featureTypes
         *        The feature types that the adapter version is operating on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(String... featureTypes);

        /**
         * <p>
         * The feature types that the adapter version is operating on.
         * </p>
         * 
         * @param featureTypes
         *        The feature types that the adapter version is operating on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(Collection<FeatureType> featureTypes);

        /**
         * <p>
         * The feature types that the adapter version is operating on.
         * </p>
         * 
         * @param featureTypes
         *        The feature types that the adapter version is operating on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(FeatureType... featureTypes);

        /**
         * <p>
         * Contains information on the status of a given adapter version.
         * </p>
         * 
         * @param status
         *        Contains information on the status of a given adapter version.
         * @see AdapterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdapterVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Contains information on the status of a given adapter version.
         * </p>
         * 
         * @param status
         *        Contains information on the status of a given adapter version.
         * @see AdapterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdapterVersionStatus
         */
        Builder status(AdapterVersionStatus status);

        /**
         * <p>
         * A message explaining the status of a given adapter vesion.
         * </p>
         * 
         * @param statusMessage
         *        A message explaining the status of a given adapter vesion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String adapterId;

        private String adapterVersion;

        private Instant creationTime;

        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AdapterVersionOverview model) {
            adapterId(model.adapterId);
            adapterVersion(model.adapterVersion);
            creationTime(model.creationTime);
            featureTypesWithStrings(model.featureTypes);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getAdapterId() {
            return adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterVersion() {
            return adapterVersion;
        }

        public final void setAdapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
        }

        @Override
        public final Builder adapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String... featureTypes) {
            featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType... featureTypes) {
            featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AdapterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public AdapterVersionOverview build() {
            return new AdapterVersionOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
