/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.TextractServiceClientConfiguration;
import software.amazon.awssdk.services.textract.internal.TextractServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.textract.model.AccessDeniedException;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeIdRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeIdResponse;
import software.amazon.awssdk.services.textract.model.BadDocumentException;
import software.amazon.awssdk.services.textract.model.ConflictException;
import software.amazon.awssdk.services.textract.model.CreateAdapterRequest;
import software.amazon.awssdk.services.textract.model.CreateAdapterResponse;
import software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.DeleteAdapterRequest;
import software.amazon.awssdk.services.textract.model.DeleteAdapterResponse;
import software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.DeleteAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse;
import software.amazon.awssdk.services.textract.model.DocumentTooLargeException;
import software.amazon.awssdk.services.textract.model.GetAdapterRequest;
import software.amazon.awssdk.services.textract.model.GetAdapterResponse;
import software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse;
import software.amazon.awssdk.services.textract.model.HumanLoopQuotaExceededException;
import software.amazon.awssdk.services.textract.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.textract.model.InternalServerErrorException;
import software.amazon.awssdk.services.textract.model.InvalidJobIdException;
import software.amazon.awssdk.services.textract.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.textract.model.InvalidParameterException;
import software.amazon.awssdk.services.textract.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.textract.model.LimitExceededException;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse;
import software.amazon.awssdk.services.textract.model.ListAdaptersRequest;
import software.amazon.awssdk.services.textract.model.ListAdaptersResponse;
import software.amazon.awssdk.services.textract.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.textract.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.textract.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.textract.model.ResourceNotFoundException;
import software.amazon.awssdk.services.textract.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.TagResourceRequest;
import software.amazon.awssdk.services.textract.model.TagResourceResponse;
import software.amazon.awssdk.services.textract.model.TextractException;
import software.amazon.awssdk.services.textract.model.ThrottlingException;
import software.amazon.awssdk.services.textract.model.UnsupportedDocumentException;
import software.amazon.awssdk.services.textract.model.UntagResourceRequest;
import software.amazon.awssdk.services.textract.model.UntagResourceResponse;
import software.amazon.awssdk.services.textract.model.UpdateAdapterRequest;
import software.amazon.awssdk.services.textract.model.UpdateAdapterResponse;
import software.amazon.awssdk.services.textract.model.ValidationException;
import software.amazon.awssdk.services.textract.transform.AnalyzeDocumentRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.AnalyzeExpenseRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.AnalyzeIdRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.CreateAdapterRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.CreateAdapterVersionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.DeleteAdapterRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.DeleteAdapterVersionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.DetectDocumentTextRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetAdapterRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetAdapterVersionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetDocumentAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetDocumentTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetExpenseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetLendingAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetLendingAnalysisSummaryRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.ListAdapterVersionsRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.ListAdaptersRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartDocumentAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartDocumentTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartExpenseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartLendingAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.UpdateAdapterRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTextractClient
implements TextractClient {
    private static final Logger log = Logger.loggerFor(DefaultTextractClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTextractClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Textract#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyzeDocumentResponse analyzeDocument(AnalyzeDocumentRequest analyzeDocumentRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, HumanLoopQuotaExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AnalyzeDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)analyzeDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, analyzeDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AnalyzeDocument");
            AnalyzeDocumentResponse analyzeDocumentResponse = (AnalyzeDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AnalyzeDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)analyzeDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AnalyzeDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return analyzeDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$analyzeDocument$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyzeExpenseResponse analyzeExpense(AnalyzeExpenseRequest analyzeExpenseRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AnalyzeExpenseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)analyzeExpenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, analyzeExpenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AnalyzeExpense");
            AnalyzeExpenseResponse analyzeExpenseResponse = (AnalyzeExpenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AnalyzeExpense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)analyzeExpenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AnalyzeExpenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return analyzeExpenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$analyzeExpense$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyzeIdResponse analyzeID(AnalyzeIdRequest analyzeIdRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AnalyzeIdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)analyzeIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, analyzeIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AnalyzeID");
            AnalyzeIdResponse analyzeIdResponse = (AnalyzeIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AnalyzeID").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)analyzeIdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AnalyzeIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return analyzeIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$analyzeID$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAdapterResponse createAdapter(CreateAdapterRequest createAdapterRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAdapterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, createAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAdapter");
            CreateAdapterResponse createAdapterResponse = (CreateAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAdapter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$createAdapter$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAdapterVersionResponse createAdapterVersion(CreateAdapterVersionRequest createAdapterVersionRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAdapterVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAdapterVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, createAdapterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAdapterVersion");
            CreateAdapterVersionResponse createAdapterVersionResponse = (CreateAdapterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAdapterVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAdapterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAdapterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAdapterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$createAdapterVersion$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAdapterResponse deleteAdapter(DeleteAdapterRequest deleteAdapterRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdapterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, deleteAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAdapter");
            DeleteAdapterResponse deleteAdapterResponse = (DeleteAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAdapter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$deleteAdapter$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAdapterVersionResponse deleteAdapterVersion(DeleteAdapterVersionRequest deleteAdapterVersionRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdapterVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdapterVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, deleteAdapterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAdapterVersion");
            DeleteAdapterVersionResponse deleteAdapterVersionResponse = (DeleteAdapterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAdapterVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAdapterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAdapterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAdapterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$deleteAdapterVersion$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectDocumentTextResponse detectDocumentText(DetectDocumentTextRequest detectDocumentTextRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectDocumentTextResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectDocumentTextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, detectDocumentTextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectDocumentText");
            DetectDocumentTextResponse detectDocumentTextResponse = (DetectDocumentTextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectDocumentText").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectDocumentTextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectDocumentTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectDocumentTextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$detectDocumentText$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAdapterResponse getAdapter(GetAdapterRequest getAdapterRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAdapterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAdapter");
            GetAdapterResponse getAdapterResponse = (GetAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAdapter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getAdapter$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAdapterVersionResponse getAdapterVersion(GetAdapterVersionRequest getAdapterVersionRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAdapterVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAdapterVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getAdapterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAdapterVersion");
            GetAdapterVersionResponse getAdapterVersionResponse = (GetAdapterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAdapterVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAdapterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAdapterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAdapterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getAdapterVersion$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentAnalysisResponse getDocumentAnalysis(GetDocumentAnalysisRequest getDocumentAnalysisRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getDocumentAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentAnalysis");
            GetDocumentAnalysisResponse getDocumentAnalysisResponse = (GetDocumentAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getDocumentAnalysis$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentTextDetectionResponse getDocumentTextDetection(GetDocumentTextDetectionRequest getDocumentTextDetectionRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentTextDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentTextDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getDocumentTextDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentTextDetection");
            GetDocumentTextDetectionResponse getDocumentTextDetectionResponse = (GetDocumentTextDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentTextDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentTextDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentTextDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentTextDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getDocumentTextDetection$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExpenseAnalysisResponse getExpenseAnalysis(GetExpenseAnalysisRequest getExpenseAnalysisRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExpenseAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExpenseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getExpenseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExpenseAnalysis");
            GetExpenseAnalysisResponse getExpenseAnalysisResponse = (GetExpenseAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExpenseAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getExpenseAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExpenseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExpenseAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getExpenseAnalysis$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLendingAnalysisResponse getLendingAnalysis(GetLendingAnalysisRequest getLendingAnalysisRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLendingAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLendingAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getLendingAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLendingAnalysis");
            GetLendingAnalysisResponse getLendingAnalysisResponse = (GetLendingAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLendingAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLendingAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLendingAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLendingAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getLendingAnalysis$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLendingAnalysisSummaryResponse getLendingAnalysisSummary(GetLendingAnalysisSummaryRequest getLendingAnalysisSummaryRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLendingAnalysisSummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLendingAnalysisSummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getLendingAnalysisSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLendingAnalysisSummary");
            GetLendingAnalysisSummaryResponse getLendingAnalysisSummaryResponse = (GetLendingAnalysisSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLendingAnalysisSummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLendingAnalysisSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLendingAnalysisSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLendingAnalysisSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getLendingAnalysisSummary$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAdapterVersionsResponse listAdapterVersions(ListAdapterVersionsRequest listAdapterVersionsRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAdapterVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAdapterVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, listAdapterVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAdapterVersions");
            ListAdapterVersionsResponse listAdapterVersionsResponse = (ListAdapterVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAdapterVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAdapterVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAdapterVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAdapterVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$listAdapterVersions$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAdaptersResponse listAdapters(ListAdaptersRequest listAdaptersRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAdaptersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAdaptersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, listAdaptersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAdapters");
            ListAdaptersResponse listAdaptersResponse = (ListAdaptersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAdapters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAdaptersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAdaptersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAdaptersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$listAdapters$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$listTagsForResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDocumentAnalysisResponse startDocumentAnalysis(StartDocumentAnalysisRequest startDocumentAnalysisRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDocumentAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startDocumentAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentAnalysis");
            StartDocumentAnalysisResponse startDocumentAnalysisResponse = (StartDocumentAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDocumentAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDocumentAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDocumentAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startDocumentAnalysis$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDocumentTextDetectionResponse startDocumentTextDetection(StartDocumentTextDetectionRequest startDocumentTextDetectionRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentTextDetectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDocumentTextDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startDocumentTextDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentTextDetection");
            StartDocumentTextDetectionResponse startDocumentTextDetectionResponse = (StartDocumentTextDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentTextDetection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDocumentTextDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDocumentTextDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDocumentTextDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startDocumentTextDetection$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExpenseAnalysisResponse startExpenseAnalysis(StartExpenseAnalysisRequest startExpenseAnalysisRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExpenseAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startExpenseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startExpenseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExpenseAnalysis");
            StartExpenseAnalysisResponse startExpenseAnalysisResponse = (StartExpenseAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExpenseAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startExpenseAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartExpenseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startExpenseAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startExpenseAnalysis$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLendingAnalysisResponse startLendingAnalysis(StartLendingAnalysisRequest startLendingAnalysisRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLendingAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startLendingAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startLendingAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLendingAnalysis");
            StartLendingAnalysisResponse startLendingAnalysisResponse = (StartLendingAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLendingAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startLendingAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartLendingAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startLendingAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startLendingAnalysis$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InvalidParameterException, ServiceQuotaExceededException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$tagResource$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$untagResource$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAdapterResponse updateAdapter(UpdateAdapterRequest updateAdapterRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAdapterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "BadDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadDocumentException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "HumanLoopQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "DocumentTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DocumentTooLargeException::builder).build());
                }
                case "UnsupportedDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDocumentException::builder).build());
                }
                case "InvalidS3ObjectException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3ObjectException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "InvalidJobIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobIdException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, updateAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAdapter");
            UpdateAdapterResponse updateAdapterResponse = (UpdateAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAdapter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$updateAdapter$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "textract";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        TextractServiceClientConfigurationBuilder serviceConfigBuilder = new TextractServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TextractException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final TextractServiceClientConfiguration serviceClientConfiguration() {
        return new TextractServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAdapter$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startLendingAnalysis$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExpenseAnalysis$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentTextDetection$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentAnalysis$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAdapters$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAdapterVersions$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLendingAnalysisSummary$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLendingAnalysis$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExpenseAnalysis$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentTextDetection$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentAnalysis$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAdapterVersion$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAdapter$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectDocumentText$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAdapterVersion$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAdapter$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAdapterVersion$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAdapter$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$analyzeID$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$analyzeExpense$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$analyzeDocument$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

