/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AdaptersConfig;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.HumanLoopConfig;
import software.amazon.awssdk.services.textract.model.QueriesConfig;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeDocumentRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, AnalyzeDocumentRequest> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Document").getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::document)).setter(AnalyzeDocumentRequest.setter(Builder::document)).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::featureTypesAsStrings)).setter(AnalyzeDocumentRequest.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopConfig").getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::humanLoopConfig)).setter(AnalyzeDocumentRequest.setter(Builder::humanLoopConfig)).constructor(HumanLoopConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()}).build();
    private static final SdkField<QueriesConfig> QUERIES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueriesConfig").getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::queriesConfig)).setter(AnalyzeDocumentRequest.setter(Builder::queriesConfig)).constructor(QueriesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueriesConfig").build()}).build();
    private static final SdkField<AdaptersConfig> ADAPTERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdaptersConfig").getter(AnalyzeDocumentRequest.getter(AnalyzeDocumentRequest::adaptersConfig)).setter(AnalyzeDocumentRequest.setter(Builder::adaptersConfig)).constructor(AdaptersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdaptersConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, FEATURE_TYPES_FIELD, HUMAN_LOOP_CONFIG_FIELD, QUERIES_CONFIG_FIELD, ADAPTERS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyzeDocumentRequest.memberNameToFieldInitializer();
    private final Document document;
    private final List<String> featureTypes;
    private final HumanLoopConfig humanLoopConfig;
    private final QueriesConfig queriesConfig;
    private final AdaptersConfig adaptersConfig;

    private AnalyzeDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
        this.featureTypes = builder.featureTypes;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.queriesConfig = builder.queriesConfig;
        this.adaptersConfig = builder.adaptersConfig;
    }

    public final Document document() {
        return this.document;
    }

    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public final HumanLoopConfig humanLoopConfig() {
        return this.humanLoopConfig;
    }

    public final QueriesConfig queriesConfig() {
        return this.queriesConfig;
    }

    public final AdaptersConfig adaptersConfig() {
        return this.adaptersConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.queriesConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptersConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeDocumentRequest)) {
            return false;
        }
        AnalyzeDocumentRequest other = (AnalyzeDocumentRequest)((Object)obj);
        return Objects.equals(this.document(), other.document()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.humanLoopConfig(), other.humanLoopConfig()) && Objects.equals(this.queriesConfig(), other.queriesConfig()) && Objects.equals(this.adaptersConfig(), other.adaptersConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzeDocumentRequest").add("Document", (Object)this.document()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).add("HumanLoopConfig", (Object)this.humanLoopConfig()).add("QueriesConfig", (Object)this.queriesConfig()).add("AdaptersConfig", (Object)this.adaptersConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "HumanLoopConfig": {
                return Optional.ofNullable(clazz.cast(this.humanLoopConfig()));
            }
            case "QueriesConfig": {
                return Optional.ofNullable(clazz.cast(this.queriesConfig()));
            }
            case "AdaptersConfig": {
                return Optional.ofNullable(clazz.cast(this.adaptersConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Document", DOCUMENT_FIELD);
        map.put("FeatureTypes", FEATURE_TYPES_FIELD);
        map.put("HumanLoopConfig", HUMAN_LOOP_CONFIG_FIELD);
        map.put("QueriesConfig", QUERIES_CONFIG_FIELD);
        map.put("AdaptersConfig", ADAPTERS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeDocumentRequest, T> g) {
        return obj -> g.apply((AnalyzeDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private Document document;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private HumanLoopConfig humanLoopConfig;
        private QueriesConfig queriesConfig;
        private AdaptersConfig adaptersConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeDocumentRequest model) {
            super(model);
            this.document(model.document);
            this.featureTypesWithStrings(model.featureTypes);
            this.humanLoopConfig(model.humanLoopConfig);
            this.queriesConfig(model.queriesConfig);
            this.adaptersConfig(model.adaptersConfig);
        }

        public final Document.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return this.humanLoopConfig != null ? this.humanLoopConfig.toBuilder() : null;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        @Override
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final QueriesConfig.Builder getQueriesConfig() {
            return this.queriesConfig != null ? this.queriesConfig.toBuilder() : null;
        }

        public final void setQueriesConfig(QueriesConfig.BuilderImpl queriesConfig) {
            this.queriesConfig = queriesConfig != null ? queriesConfig.build() : null;
        }

        @Override
        public final Builder queriesConfig(QueriesConfig queriesConfig) {
            this.queriesConfig = queriesConfig;
            return this;
        }

        public final AdaptersConfig.Builder getAdaptersConfig() {
            return this.adaptersConfig != null ? this.adaptersConfig.toBuilder() : null;
        }

        public final void setAdaptersConfig(AdaptersConfig.BuilderImpl adaptersConfig) {
            this.adaptersConfig = adaptersConfig != null ? adaptersConfig.build() : null;
        }

        @Override
        public final Builder adaptersConfig(AdaptersConfig adaptersConfig) {
            this.adaptersConfig = adaptersConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AnalyzeDocumentRequest build() {
            return new AnalyzeDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AnalyzeDocumentRequest> {
        public Builder document(Document var1);

        default public Builder document(Consumer<Document.Builder> document) {
            return this.document((Document)((Document.Builder)Document.builder().applyMutation(document)).build());
        }

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder humanLoopConfig(HumanLoopConfig var1);

        default public Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return this.humanLoopConfig((HumanLoopConfig)((HumanLoopConfig.Builder)HumanLoopConfig.builder().applyMutation(humanLoopConfig)).build());
        }

        public Builder queriesConfig(QueriesConfig var1);

        default public Builder queriesConfig(Consumer<QueriesConfig.Builder> queriesConfig) {
            return this.queriesConfig((QueriesConfig)((QueriesConfig.Builder)QueriesConfig.builder().applyMutation(queriesConfig)).build());
        }

        public Builder adaptersConfig(AdaptersConfig var1);

        default public Builder adaptersConfig(Consumer<AdaptersConfig.Builder> adaptersConfig) {
            return this.adaptersConfig((AdaptersConfig)((AdaptersConfig.Builder)AdaptersConfig.builder().applyMutation(adaptersConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

