/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AutoUpdate;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAdapterResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, UpdateAdapterResponse> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(UpdateAdapterResponse.getter(UpdateAdapterResponse::adapterId)).setter(UpdateAdapterResponse.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<String> ADAPTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterName").getter(UpdateAdapterResponse.getter(UpdateAdapterResponse::adapterName)).setter(UpdateAdapterResponse.setter(Builder::adapterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateAdapterResponse.getter(UpdateAdapterResponse::creationTime)).setter(UpdateAdapterResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAdapterResponse.getter(UpdateAdapterResponse::description)).setter(UpdateAdapterResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(UpdateAdapterResponse.getter(UpdateAdapterResponse::featureTypesAsStrings)).setter(UpdateAdapterResponse.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoUpdate").getter(UpdateAdapterResponse.getter(UpdateAdapterResponse::autoUpdateAsString)).setter(UpdateAdapterResponse.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, ADAPTER_NAME_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, FEATURE_TYPES_FIELD, AUTO_UPDATE_FIELD));
    private final String adapterId;
    private final String adapterName;
    private final Instant creationTime;
    private final String description;
    private final List<String> featureTypes;
    private final String autoUpdate;

    private UpdateAdapterResponse(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.adapterName = builder.adapterName;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.featureTypes = builder.featureTypes;
        this.autoUpdate = builder.autoUpdate;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final String adapterName() {
        return this.adapterName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public final AutoUpdate autoUpdate() {
        return AutoUpdate.fromValue(this.autoUpdate);
    }

    public final String autoUpdateAsString() {
        return this.autoUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAdapterResponse)) {
            return false;
        }
        UpdateAdapterResponse other = (UpdateAdapterResponse)((Object)obj);
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.adapterName(), other.adapterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.autoUpdateAsString(), other.autoUpdateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAdapterResponse").add("AdapterId", (Object)this.adapterId()).add("AdapterName", (Object)this.adapterName()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).add("AutoUpdate", (Object)this.autoUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "AdapterName": {
                return Optional.ofNullable(clazz.cast(this.adapterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "AutoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAdapterResponse, T> g) {
        return obj -> g.apply((UpdateAdapterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private String adapterId;
        private String adapterName;
        private Instant creationTime;
        private String description;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private String autoUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAdapterResponse model) {
            super(model);
            this.adapterId(model.adapterId);
            this.adapterName(model.adapterName);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.featureTypesWithStrings(model.featureTypes);
            this.autoUpdate(model.autoUpdate);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterName() {
            return this.adapterName;
        }

        public final void setAdapterName(String adapterName) {
            this.adapterName = adapterName;
        }

        @Override
        public final Builder adapterName(String adapterName) {
            this.adapterName = adapterName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public final Builder autoUpdate(AutoUpdate autoUpdate) {
            this.autoUpdate(autoUpdate == null ? null : autoUpdate.toString());
            return this;
        }

        @Override
        public UpdateAdapterResponse build() {
            return new UpdateAdapterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAdapterResponse> {
        public Builder adapterId(String var1);

        public Builder adapterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder autoUpdate(String var1);

        public Builder autoUpdate(AutoUpdate var1);
    }
}

