/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.textract.DefaultTextractAsyncClient;
import software.amazon.awssdk.services.textract.DefaultTextractBaseClientBuilder;
import software.amazon.awssdk.services.textract.TextractAsyncClient;
import software.amazon.awssdk.services.textract.TextractAsyncClientBuilder;
import software.amazon.awssdk.services.textract.TextractServiceClientConfiguration;
import software.amazon.awssdk.services.textract.endpoints.TextractEndpointProvider;

@SdkInternalApi
final class DefaultTextractAsyncClientBuilder
extends DefaultTextractBaseClientBuilder<TextractAsyncClientBuilder, TextractAsyncClient>
implements TextractAsyncClientBuilder {
    DefaultTextractAsyncClientBuilder() {
    }

    @Override
    public DefaultTextractAsyncClientBuilder endpointProvider(TextractEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TextractAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultTextractAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        TextractServiceClientConfiguration serviceClientConfiguration = TextractServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultTextractAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

