/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.textract.DefaultTextractAsyncClientBuilder;
import software.amazon.awssdk.services.textract.TextractAsyncClientBuilder;
import software.amazon.awssdk.services.textract.TextractServiceClientConfiguration;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeIdRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeIdResponse;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse;

@SdkPublicApi
@ThreadSafe
public interface TextractAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "textract";
    public static final String SERVICE_METADATA_ID = "textract";

    default public CompletableFuture<AnalyzeDocumentResponse> analyzeDocument(AnalyzeDocumentRequest analyzeDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AnalyzeDocumentResponse> analyzeDocument(Consumer<AnalyzeDocumentRequest.Builder> analyzeDocumentRequest) {
        return this.analyzeDocument((AnalyzeDocumentRequest)((Object)((AnalyzeDocumentRequest.Builder)AnalyzeDocumentRequest.builder().applyMutation(analyzeDocumentRequest)).build()));
    }

    default public CompletableFuture<AnalyzeExpenseResponse> analyzeExpense(AnalyzeExpenseRequest analyzeExpenseRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AnalyzeExpenseResponse> analyzeExpense(Consumer<AnalyzeExpenseRequest.Builder> analyzeExpenseRequest) {
        return this.analyzeExpense((AnalyzeExpenseRequest)((Object)((AnalyzeExpenseRequest.Builder)AnalyzeExpenseRequest.builder().applyMutation(analyzeExpenseRequest)).build()));
    }

    default public CompletableFuture<AnalyzeIdResponse> analyzeID(AnalyzeIdRequest analyzeIdRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<AnalyzeIdResponse> analyzeID(Consumer<AnalyzeIdRequest.Builder> analyzeIdRequest) {
        return this.analyzeID((AnalyzeIdRequest)((Object)((AnalyzeIdRequest.Builder)AnalyzeIdRequest.builder().applyMutation(analyzeIdRequest)).build()));
    }

    default public CompletableFuture<DetectDocumentTextResponse> detectDocumentText(DetectDocumentTextRequest detectDocumentTextRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DetectDocumentTextResponse> detectDocumentText(Consumer<DetectDocumentTextRequest.Builder> detectDocumentTextRequest) {
        return this.detectDocumentText((DetectDocumentTextRequest)((Object)((DetectDocumentTextRequest.Builder)DetectDocumentTextRequest.builder().applyMutation(detectDocumentTextRequest)).build()));
    }

    default public CompletableFuture<GetDocumentAnalysisResponse> getDocumentAnalysis(GetDocumentAnalysisRequest getDocumentAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDocumentAnalysisResponse> getDocumentAnalysis(Consumer<GetDocumentAnalysisRequest.Builder> getDocumentAnalysisRequest) {
        return this.getDocumentAnalysis((GetDocumentAnalysisRequest)((Object)((GetDocumentAnalysisRequest.Builder)GetDocumentAnalysisRequest.builder().applyMutation(getDocumentAnalysisRequest)).build()));
    }

    default public CompletableFuture<GetDocumentTextDetectionResponse> getDocumentTextDetection(GetDocumentTextDetectionRequest getDocumentTextDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDocumentTextDetectionResponse> getDocumentTextDetection(Consumer<GetDocumentTextDetectionRequest.Builder> getDocumentTextDetectionRequest) {
        return this.getDocumentTextDetection((GetDocumentTextDetectionRequest)((Object)((GetDocumentTextDetectionRequest.Builder)GetDocumentTextDetectionRequest.builder().applyMutation(getDocumentTextDetectionRequest)).build()));
    }

    default public CompletableFuture<GetExpenseAnalysisResponse> getExpenseAnalysis(GetExpenseAnalysisRequest getExpenseAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetExpenseAnalysisResponse> getExpenseAnalysis(Consumer<GetExpenseAnalysisRequest.Builder> getExpenseAnalysisRequest) {
        return this.getExpenseAnalysis((GetExpenseAnalysisRequest)((Object)((GetExpenseAnalysisRequest.Builder)GetExpenseAnalysisRequest.builder().applyMutation(getExpenseAnalysisRequest)).build()));
    }

    default public CompletableFuture<GetLendingAnalysisResponse> getLendingAnalysis(GetLendingAnalysisRequest getLendingAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetLendingAnalysisResponse> getLendingAnalysis(Consumer<GetLendingAnalysisRequest.Builder> getLendingAnalysisRequest) {
        return this.getLendingAnalysis((GetLendingAnalysisRequest)((Object)((GetLendingAnalysisRequest.Builder)GetLendingAnalysisRequest.builder().applyMutation(getLendingAnalysisRequest)).build()));
    }

    default public CompletableFuture<GetLendingAnalysisSummaryResponse> getLendingAnalysisSummary(GetLendingAnalysisSummaryRequest getLendingAnalysisSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetLendingAnalysisSummaryResponse> getLendingAnalysisSummary(Consumer<GetLendingAnalysisSummaryRequest.Builder> getLendingAnalysisSummaryRequest) {
        return this.getLendingAnalysisSummary((GetLendingAnalysisSummaryRequest)((Object)((GetLendingAnalysisSummaryRequest.Builder)GetLendingAnalysisSummaryRequest.builder().applyMutation(getLendingAnalysisSummaryRequest)).build()));
    }

    default public CompletableFuture<StartDocumentAnalysisResponse> startDocumentAnalysis(StartDocumentAnalysisRequest startDocumentAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartDocumentAnalysisResponse> startDocumentAnalysis(Consumer<StartDocumentAnalysisRequest.Builder> startDocumentAnalysisRequest) {
        return this.startDocumentAnalysis((StartDocumentAnalysisRequest)((Object)((StartDocumentAnalysisRequest.Builder)StartDocumentAnalysisRequest.builder().applyMutation(startDocumentAnalysisRequest)).build()));
    }

    default public CompletableFuture<StartDocumentTextDetectionResponse> startDocumentTextDetection(StartDocumentTextDetectionRequest startDocumentTextDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartDocumentTextDetectionResponse> startDocumentTextDetection(Consumer<StartDocumentTextDetectionRequest.Builder> startDocumentTextDetectionRequest) {
        return this.startDocumentTextDetection((StartDocumentTextDetectionRequest)((Object)((StartDocumentTextDetectionRequest.Builder)StartDocumentTextDetectionRequest.builder().applyMutation(startDocumentTextDetectionRequest)).build()));
    }

    default public CompletableFuture<StartExpenseAnalysisResponse> startExpenseAnalysis(StartExpenseAnalysisRequest startExpenseAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartExpenseAnalysisResponse> startExpenseAnalysis(Consumer<StartExpenseAnalysisRequest.Builder> startExpenseAnalysisRequest) {
        return this.startExpenseAnalysis((StartExpenseAnalysisRequest)((Object)((StartExpenseAnalysisRequest.Builder)StartExpenseAnalysisRequest.builder().applyMutation(startExpenseAnalysisRequest)).build()));
    }

    default public CompletableFuture<StartLendingAnalysisResponse> startLendingAnalysis(StartLendingAnalysisRequest startLendingAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartLendingAnalysisResponse> startLendingAnalysis(Consumer<StartLendingAnalysisRequest.Builder> startLendingAnalysisRequest) {
        return this.startLendingAnalysis((StartLendingAnalysisRequest)((Object)((StartLendingAnalysisRequest.Builder)StartLendingAnalysisRequest.builder().applyMutation(startLendingAnalysisRequest)).build()));
    }

    public TextractServiceClientConfiguration serviceClientConfiguration();

    public static TextractAsyncClient create() {
        return (TextractAsyncClient)TextractAsyncClient.builder().build();
    }

    public static TextractAsyncClientBuilder builder() {
        return new DefaultTextractAsyncClientBuilder();
    }
}

