/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.JobStatus;
import software.amazon.awssdk.services.textract.model.LendingSummary;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.services.textract.model.Warning;
import software.amazon.awssdk.services.textract.model.WarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLendingAnalysisSummaryResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, GetLendingAnalysisSummaryResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(GetLendingAnalysisSummaryResponse.getter(GetLendingAnalysisSummaryResponse::documentMetadata)).setter(GetLendingAnalysisSummaryResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetLendingAnalysisSummaryResponse.getter(GetLendingAnalysisSummaryResponse::jobStatusAsString)).setter(GetLendingAnalysisSummaryResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<LendingSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(GetLendingAnalysisSummaryResponse.getter(GetLendingAnalysisSummaryResponse::summary)).setter(GetLendingAnalysisSummaryResponse.setter(Builder::summary)).constructor(LendingSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(GetLendingAnalysisSummaryResponse.getter(GetLendingAnalysisSummaryResponse::warnings)).setter(GetLendingAnalysisSummaryResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Warning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetLendingAnalysisSummaryResponse.getter(GetLendingAnalysisSummaryResponse::statusMessage)).setter(GetLendingAnalysisSummaryResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ANALYZE_LENDING_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalyzeLendingModelVersion").getter(GetLendingAnalysisSummaryResponse.getter(GetLendingAnalysisSummaryResponse::analyzeLendingModelVersion)).setter(GetLendingAnalysisSummaryResponse.setter(Builder::analyzeLendingModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeLendingModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD, JOB_STATUS_FIELD, SUMMARY_FIELD, WARNINGS_FIELD, STATUS_MESSAGE_FIELD, ANALYZE_LENDING_MODEL_VERSION_FIELD));
    private final DocumentMetadata documentMetadata;
    private final String jobStatus;
    private final LendingSummary summary;
    private final List<Warning> warnings;
    private final String statusMessage;
    private final String analyzeLendingModelVersion;

    private GetLendingAnalysisSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.jobStatus = builder.jobStatus;
        this.summary = builder.summary;
        this.warnings = builder.warnings;
        this.statusMessage = builder.statusMessage;
        this.analyzeLendingModelVersion = builder.analyzeLendingModelVersion;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final LendingSummary summary() {
        return this.summary;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<Warning> warnings() {
        return this.warnings;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String analyzeLendingModelVersion() {
        return this.analyzeLendingModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzeLendingModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLendingAnalysisSummaryResponse)) {
            return false;
        }
        GetLendingAnalysisSummaryResponse other = (GetLendingAnalysisSummaryResponse)((Object)obj);
        return Objects.equals(this.documentMetadata(), other.documentMetadata()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.summary(), other.summary()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.analyzeLendingModelVersion(), other.analyzeLendingModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetLendingAnalysisSummaryResponse").add("DocumentMetadata", (Object)this.documentMetadata()).add("JobStatus", (Object)this.jobStatusAsString()).add("Summary", (Object)this.summary()).add("Warnings", this.hasWarnings() ? this.warnings() : null).add("StatusMessage", (Object)this.statusMessage()).add("AnalyzeLendingModelVersion", (Object)this.analyzeLendingModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "AnalyzeLendingModelVersion": {
                return Optional.ofNullable(clazz.cast(this.analyzeLendingModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLendingAnalysisSummaryResponse, T> g) {
        return obj -> g.apply((GetLendingAnalysisSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata documentMetadata;
        private String jobStatus;
        private LendingSummary summary;
        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;
        private String analyzeLendingModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLendingAnalysisSummaryResponse model) {
            super(model);
            this.documentMetadata(model.documentMetadata);
            this.jobStatus(model.jobStatus);
            this.summary(model.summary);
            this.warnings(model.warnings);
            this.statusMessage(model.statusMessage);
            this.analyzeLendingModelVersion(model.analyzeLendingModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final LendingSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(LendingSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(LendingSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (Warning)((Warning.Builder)Warning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAnalyzeLendingModelVersion() {
            return this.analyzeLendingModelVersion;
        }

        public final void setAnalyzeLendingModelVersion(String analyzeLendingModelVersion) {
            this.analyzeLendingModelVersion = analyzeLendingModelVersion;
        }

        @Override
        public final Builder analyzeLendingModelVersion(String analyzeLendingModelVersion) {
            this.analyzeLendingModelVersion = analyzeLendingModelVersion;
            return this;
        }

        @Override
        public GetLendingAnalysisSummaryResponse build() {
            return new GetLendingAnalysisSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLendingAnalysisSummaryResponse> {
        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder summary(LendingSummary var1);

        default public Builder summary(Consumer<LendingSummary.Builder> summary) {
            return this.summary((LendingSummary)((LendingSummary.Builder)LendingSummary.builder().applyMutation(summary)).build());
        }

        public Builder warnings(Collection<Warning> var1);

        public Builder warnings(Warning ... var1);

        public Builder warnings(Consumer<Warning.Builder> ... var1);

        public Builder statusMessage(String var1);

        public Builder analyzeLendingModelVersion(String var1);
    }
}

