/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.ExpenseField;
import software.amazon.awssdk.services.textract.model.ExpenseFieldListCopier;
import software.amazon.awssdk.services.textract.model.LineItemGroup;
import software.amazon.awssdk.services.textract.model.LineItemGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpenseDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpenseDocument> {
    private static final SdkField<Integer> EXPENSE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpenseIndex").getter(ExpenseDocument.getter(ExpenseDocument::expenseIndex)).setter(ExpenseDocument.setter(Builder::expenseIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseIndex").build()}).build();
    private static final SdkField<List<ExpenseField>> SUMMARY_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SummaryFields").getter(ExpenseDocument.getter(ExpenseDocument::summaryFields)).setter(ExpenseDocument.setter(Builder::summaryFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpenseField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LineItemGroup>> LINE_ITEM_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItemGroups").getter(ExpenseDocument.getter(ExpenseDocument::lineItemGroups)).setter(ExpenseDocument.setter(Builder::lineItemGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItemGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPENSE_INDEX_FIELD, SUMMARY_FIELDS_FIELD, LINE_ITEM_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer expenseIndex;
    private final List<ExpenseField> summaryFields;
    private final List<LineItemGroup> lineItemGroups;

    private ExpenseDocument(BuilderImpl builder) {
        this.expenseIndex = builder.expenseIndex;
        this.summaryFields = builder.summaryFields;
        this.lineItemGroups = builder.lineItemGroups;
    }

    public final Integer expenseIndex() {
        return this.expenseIndex;
    }

    public final boolean hasSummaryFields() {
        return this.summaryFields != null && !(this.summaryFields instanceof SdkAutoConstructList);
    }

    public final List<ExpenseField> summaryFields() {
        return this.summaryFields;
    }

    public final boolean hasLineItemGroups() {
        return this.lineItemGroups != null && !(this.lineItemGroups instanceof SdkAutoConstructList);
    }

    public final List<LineItemGroup> lineItemGroups() {
        return this.lineItemGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expenseIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryFields() ? this.summaryFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItemGroups() ? this.lineItemGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseDocument)) {
            return false;
        }
        ExpenseDocument other = (ExpenseDocument)obj;
        return Objects.equals(this.expenseIndex(), other.expenseIndex()) && this.hasSummaryFields() == other.hasSummaryFields() && Objects.equals(this.summaryFields(), other.summaryFields()) && this.hasLineItemGroups() == other.hasLineItemGroups() && Objects.equals(this.lineItemGroups(), other.lineItemGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ExpenseDocument").add("ExpenseIndex", (Object)this.expenseIndex()).add("SummaryFields", this.hasSummaryFields() ? this.summaryFields() : null).add("LineItemGroups", this.hasLineItemGroups() ? this.lineItemGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpenseIndex": {
                return Optional.ofNullable(clazz.cast(this.expenseIndex()));
            }
            case "SummaryFields": {
                return Optional.ofNullable(clazz.cast(this.summaryFields()));
            }
            case "LineItemGroups": {
                return Optional.ofNullable(clazz.cast(this.lineItemGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpenseDocument, T> g) {
        return obj -> g.apply((ExpenseDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer expenseIndex;
        private List<ExpenseField> summaryFields = DefaultSdkAutoConstructList.getInstance();
        private List<LineItemGroup> lineItemGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseDocument model) {
            this.expenseIndex(model.expenseIndex);
            this.summaryFields(model.summaryFields);
            this.lineItemGroups(model.lineItemGroups);
        }

        public final Integer getExpenseIndex() {
            return this.expenseIndex;
        }

        public final void setExpenseIndex(Integer expenseIndex) {
            this.expenseIndex = expenseIndex;
        }

        @Override
        @Transient
        public final Builder expenseIndex(Integer expenseIndex) {
            this.expenseIndex = expenseIndex;
            return this;
        }

        public final List<ExpenseField.Builder> getSummaryFields() {
            List<ExpenseField.Builder> result = ExpenseFieldListCopier.copyToBuilder(this.summaryFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryFields(Collection<ExpenseField.BuilderImpl> summaryFields) {
            this.summaryFields = ExpenseFieldListCopier.copyFromBuilder(summaryFields);
        }

        @Override
        @Transient
        public final Builder summaryFields(Collection<ExpenseField> summaryFields) {
            this.summaryFields = ExpenseFieldListCopier.copy(summaryFields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaryFields(ExpenseField ... summaryFields) {
            this.summaryFields(Arrays.asList(summaryFields));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaryFields(Consumer<ExpenseField.Builder> ... summaryFields) {
            this.summaryFields(Stream.of(summaryFields).map(c -> (ExpenseField)((ExpenseField.Builder)ExpenseField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LineItemGroup.Builder> getLineItemGroups() {
            List<LineItemGroup.Builder> result = LineItemGroupListCopier.copyToBuilder(this.lineItemGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemGroups(Collection<LineItemGroup.BuilderImpl> lineItemGroups) {
            this.lineItemGroups = LineItemGroupListCopier.copyFromBuilder(lineItemGroups);
        }

        @Override
        @Transient
        public final Builder lineItemGroups(Collection<LineItemGroup> lineItemGroups) {
            this.lineItemGroups = LineItemGroupListCopier.copy(lineItemGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineItemGroups(LineItemGroup ... lineItemGroups) {
            this.lineItemGroups(Arrays.asList(lineItemGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineItemGroups(Consumer<LineItemGroup.Builder> ... lineItemGroups) {
            this.lineItemGroups(Stream.of(lineItemGroups).map(c -> (LineItemGroup)((LineItemGroup.Builder)LineItemGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExpenseDocument build() {
            return new ExpenseDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpenseDocument> {
        public Builder expenseIndex(Integer var1);

        public Builder summaryFields(Collection<ExpenseField> var1);

        public Builder summaryFields(ExpenseField ... var1);

        public Builder summaryFields(Consumer<ExpenseField.Builder> ... var1);

        public Builder lineItemGroups(Collection<LineItemGroup> var1);

        public Builder lineItemGroups(LineItemGroup ... var1);

        public Builder lineItemGroups(Consumer<LineItemGroup.Builder> ... var1);
    }
}

