/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.Authority;
import software.amazon.awssdk.services.taxsettings.model.ExemptionCertificate;
import software.amazon.awssdk.services.taxsettings.model.PutTaxExemptionRequestAccountIdsListCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTaxExemptionRequest
extends TaxSettingsRequest
implements ToCopyableBuilder<Builder, PutTaxExemptionRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(PutTaxExemptionRequest.getter(PutTaxExemptionRequest::accountIds)).setter(PutTaxExemptionRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Authority> AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authority").getter(PutTaxExemptionRequest.getter(PutTaxExemptionRequest::authority)).setter(PutTaxExemptionRequest.setter(Builder::authority)).constructor(Authority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authority").build()}).build();
    private static final SdkField<ExemptionCertificate> EXEMPTION_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exemptionCertificate").getter(PutTaxExemptionRequest.getter(PutTaxExemptionRequest::exemptionCertificate)).setter(PutTaxExemptionRequest.setter(Builder::exemptionCertificate)).constructor(ExemptionCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exemptionCertificate").build()}).build();
    private static final SdkField<String> EXEMPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exemptionType").getter(PutTaxExemptionRequest.getter(PutTaxExemptionRequest::exemptionType)).setter(PutTaxExemptionRequest.setter(Builder::exemptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exemptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, AUTHORITY_FIELD, EXEMPTION_CERTIFICATE_FIELD, EXEMPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutTaxExemptionRequest.memberNameToFieldInitializer();
    private final List<String> accountIds;
    private final Authority authority;
    private final ExemptionCertificate exemptionCertificate;
    private final String exemptionType;

    private PutTaxExemptionRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.authority = builder.authority;
        this.exemptionCertificate = builder.exemptionCertificate;
        this.exemptionType = builder.exemptionType;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final Authority authority() {
        return this.authority;
    }

    public final ExemptionCertificate exemptionCertificate() {
        return this.exemptionCertificate;
    }

    public final String exemptionType() {
        return this.exemptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authority());
        hashCode = 31 * hashCode + Objects.hashCode(this.exemptionCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.exemptionType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTaxExemptionRequest)) {
            return false;
        }
        PutTaxExemptionRequest other = (PutTaxExemptionRequest)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.authority(), other.authority()) && Objects.equals(this.exemptionCertificate(), other.exemptionCertificate()) && Objects.equals(this.exemptionType(), other.exemptionType());
    }

    public final String toString() {
        return ToString.builder((String)"PutTaxExemptionRequest").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("Authority", (Object)this.authority()).add("ExemptionCertificate", (Object)this.exemptionCertificate()).add("ExemptionType", (Object)this.exemptionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "authority": {
                return Optional.ofNullable(clazz.cast(this.authority()));
            }
            case "exemptionCertificate": {
                return Optional.ofNullable(clazz.cast(this.exemptionCertificate()));
            }
            case "exemptionType": {
                return Optional.ofNullable(clazz.cast(this.exemptionType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("authority", AUTHORITY_FIELD);
        map.put("exemptionCertificate", EXEMPTION_CERTIFICATE_FIELD);
        map.put("exemptionType", EXEMPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTaxExemptionRequest, T> g) {
        return obj -> g.apply((PutTaxExemptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsRequest.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private Authority authority;
        private ExemptionCertificate exemptionCertificate;
        private String exemptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTaxExemptionRequest model) {
            super(model);
            this.accountIds(model.accountIds);
            this.authority(model.authority);
            this.exemptionCertificate(model.exemptionCertificate);
            this.exemptionType(model.exemptionType);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = PutTaxExemptionRequestAccountIdsListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = PutTaxExemptionRequestAccountIdsListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Authority.Builder getAuthority() {
            return this.authority != null ? this.authority.toBuilder() : null;
        }

        public final void setAuthority(Authority.BuilderImpl authority) {
            this.authority = authority != null ? authority.build() : null;
        }

        @Override
        public final Builder authority(Authority authority) {
            this.authority = authority;
            return this;
        }

        public final ExemptionCertificate.Builder getExemptionCertificate() {
            return this.exemptionCertificate != null ? this.exemptionCertificate.toBuilder() : null;
        }

        public final void setExemptionCertificate(ExemptionCertificate.BuilderImpl exemptionCertificate) {
            this.exemptionCertificate = exemptionCertificate != null ? exemptionCertificate.build() : null;
        }

        @Override
        public final Builder exemptionCertificate(ExemptionCertificate exemptionCertificate) {
            this.exemptionCertificate = exemptionCertificate;
            return this;
        }

        public final String getExemptionType() {
            return this.exemptionType;
        }

        public final void setExemptionType(String exemptionType) {
            this.exemptionType = exemptionType;
        }

        @Override
        public final Builder exemptionType(String exemptionType) {
            this.exemptionType = exemptionType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTaxExemptionRequest build() {
            return new PutTaxExemptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TaxSettingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTaxExemptionRequest> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder authority(Authority var1);

        default public Builder authority(Consumer<Authority.Builder> authority) {
            return this.authority((Authority)((Authority.Builder)Authority.builder().applyMutation(authority)).build());
        }

        public Builder exemptionCertificate(ExemptionCertificate var1);

        default public Builder exemptionCertificate(Consumer<ExemptionCertificate.Builder> exemptionCertificate) {
            return this.exemptionCertificate((ExemptionCertificate)((ExemptionCertificate.Builder)ExemptionCertificate.builder().applyMutation(exemptionCertificate)).build());
        }

        public Builder exemptionType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

