/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tax registration document information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxRegistrationDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxRegistrationDocument.Builder, TaxRegistrationDocument> {
    private static final SdkField<TaxRegistrationDocFile> FILE_FIELD = SdkField
            .<TaxRegistrationDocFile> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(TaxRegistrationDocument::file)).setter(setter(Builder::file))
            .constructor(TaxRegistrationDocFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<SourceS3Location> S3_LOCATION_FIELD = SdkField
            .<SourceS3Location> builder(MarshallingType.SDK_POJO).memberName("s3Location")
            .getter(getter(TaxRegistrationDocument::s3Location)).setter(setter(Builder::s3Location))
            .constructor(SourceS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FILE_FIELD, S3_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TaxRegistrationDocFile file;

    private final SourceS3Location s3Location;

    private TaxRegistrationDocument(BuilderImpl builder) {
        this.file = builder.file;
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * The tax registration document.
     * </p>
     * 
     * @return The tax registration document.
     */
    public final TaxRegistrationDocFile file() {
        return file;
    }

    /**
     * <p>
     * The Amazon S3 location where your tax registration document is stored.
     * </p>
     * 
     * @return The Amazon S3 location where your tax registration document is stored.
     */
    public final SourceS3Location s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistrationDocument)) {
            return false;
        }
        TaxRegistrationDocument other = (TaxRegistrationDocument) obj;
        return Objects.equals(file(), other.file()) && Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxRegistrationDocument").add("File", file()).add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("file", FILE_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistrationDocument, T> g) {
        return obj -> g.apply((TaxRegistrationDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxRegistrationDocument> {
        /**
         * <p>
         * The tax registration document.
         * </p>
         * 
         * @param file
         *        The tax registration document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(TaxRegistrationDocFile file);

        /**
         * <p>
         * The tax registration document.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxRegistrationDocFile.Builder} avoiding
         * the need to create one manually via {@link TaxRegistrationDocFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxRegistrationDocFile.Builder#build()} is called immediately and
         * its result is passed to {@link #file(TaxRegistrationDocFile)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link TaxRegistrationDocFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(TaxRegistrationDocFile)
         */
        default Builder file(Consumer<TaxRegistrationDocFile.Builder> file) {
            return file(TaxRegistrationDocFile.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * The Amazon S3 location where your tax registration document is stored.
         * </p>
         * 
         * @param s3Location
         *        The Amazon S3 location where your tax registration document is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(SourceS3Location s3Location);

        /**
         * <p>
         * The Amazon S3 location where your tax registration document is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceS3Location.Builder} avoiding the
         * need to create one manually via {@link SourceS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceS3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Location(SourceS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link SourceS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(SourceS3Location)
         */
        default Builder s3Location(Consumer<SourceS3Location.Builder> s3Location) {
            return s3Location(SourceS3Location.builder().applyMutation(s3Location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TaxRegistrationDocFile file;

        private SourceS3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistrationDocument model) {
            file(model.file);
            s3Location(model.s3Location);
        }

        public final TaxRegistrationDocFile.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(TaxRegistrationDocFile.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public final Builder file(TaxRegistrationDocFile file) {
            this.file = file;
            return this;
        }

        public final SourceS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(SourceS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(SourceS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Override
        public TaxRegistrationDocument build() {
            return new TaxRegistrationDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
