/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax registration document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxRegistrationDocFile implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxRegistrationDocFile.Builder, TaxRegistrationDocFile> {
    private static final SdkField<SdkBytes> FILE_CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("fileContent").getter(getter(TaxRegistrationDocFile::fileContent)).setter(setter(Builder::fileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContent").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(TaxRegistrationDocFile::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CONTENT_FIELD,
            FILE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes fileContent;

    private final String fileName;

    private TaxRegistrationDocFile(BuilderImpl builder) {
        this.fileContent = builder.fileContent;
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The tax registration document content.
     * </p>
     * 
     * @return The tax registration document content.
     */
    public final SdkBytes fileContent() {
        return fileContent;
    }

    /**
     * <p>
     * The tax registration document name.
     * </p>
     * 
     * @return The tax registration document name.
     */
    public final String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileContent());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistrationDocFile)) {
            return false;
        }
        TaxRegistrationDocFile other = (TaxRegistrationDocFile) obj;
        return Objects.equals(fileContent(), other.fileContent()) && Objects.equals(fileName(), other.fileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxRegistrationDocFile").add("FileContent", fileContent()).add("FileName", fileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileContent":
            return Optional.ofNullable(clazz.cast(fileContent()));
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileContent", FILE_CONTENT_FIELD);
        map.put("fileName", FILE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistrationDocFile, T> g) {
        return obj -> g.apply((TaxRegistrationDocFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxRegistrationDocFile> {
        /**
         * <p>
         * The tax registration document content.
         * </p>
         * 
         * @param fileContent
         *        The tax registration document content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileContent(SdkBytes fileContent);

        /**
         * <p>
         * The tax registration document name.
         * </p>
         * 
         * @param fileName
         *        The tax registration document name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes fileContent;

        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistrationDocFile model) {
            fileContent(model.fileContent);
            fileName(model.fileName);
        }

        public final ByteBuffer getFileContent() {
            return fileContent == null ? null : fileContent.asByteBuffer();
        }

        public final void setFileContent(ByteBuffer fileContent) {
            fileContent(fileContent == null ? null : SdkBytes.fromByteBuffer(fileContent));
        }

        @Override
        public final Builder fileContent(SdkBytes fileContent) {
            this.fileContent = fileContent;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public TaxRegistrationDocFile build() {
            return new TaxRegistrationDocFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
