/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTaxExemptionRequest extends TaxSettingsRequest implements
        ToCopyableBuilder<PutTaxExemptionRequest.Builder, PutTaxExemptionRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(PutTaxExemptionRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Authority> AUTHORITY_FIELD = SdkField.<Authority> builder(MarshallingType.SDK_POJO)
            .memberName("authority").getter(getter(PutTaxExemptionRequest::authority)).setter(setter(Builder::authority))
            .constructor(Authority::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authority").build()).build();

    private static final SdkField<ExemptionCertificate> EXEMPTION_CERTIFICATE_FIELD = SdkField
            .<ExemptionCertificate> builder(MarshallingType.SDK_POJO).memberName("exemptionCertificate")
            .getter(getter(PutTaxExemptionRequest::exemptionCertificate)).setter(setter(Builder::exemptionCertificate))
            .constructor(ExemptionCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exemptionCertificate").build())
            .build();

    private static final SdkField<String> EXEMPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exemptionType").getter(getter(PutTaxExemptionRequest::exemptionType))
            .setter(setter(Builder::exemptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exemptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            AUTHORITY_FIELD, EXEMPTION_CERTIFICATE_FIELD, EXEMPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> accountIds;

    private final Authority authority;

    private final ExemptionCertificate exemptionCertificate;

    private final String exemptionType;

    private PutTaxExemptionRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.authority = builder.authority;
        this.exemptionCertificate = builder.exemptionCertificate;
        this.exemptionType = builder.exemptionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of unique account identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The list of unique account identifiers.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * Returns the value of the Authority property for this object.
     * 
     * @return The value of the Authority property for this object.
     */
    public final Authority authority() {
        return authority;
    }

    /**
     * Returns the value of the ExemptionCertificate property for this object.
     * 
     * @return The value of the ExemptionCertificate property for this object.
     */
    public final ExemptionCertificate exemptionCertificate() {
        return exemptionCertificate;
    }

    /**
     * <p>
     * The exemption type. Use the supported tax exemption type description.
     * </p>
     * 
     * @return The exemption type. Use the supported tax exemption type description.
     */
    public final String exemptionType() {
        return exemptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authority());
        hashCode = 31 * hashCode + Objects.hashCode(exemptionCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(exemptionType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTaxExemptionRequest)) {
            return false;
        }
        PutTaxExemptionRequest other = (PutTaxExemptionRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(authority(), other.authority())
                && Objects.equals(exemptionCertificate(), other.exemptionCertificate())
                && Objects.equals(exemptionType(), other.exemptionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutTaxExemptionRequest").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("Authority", authority()).add("ExemptionCertificate", exemptionCertificate())
                .add("ExemptionType", exemptionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "authority":
            return Optional.ofNullable(clazz.cast(authority()));
        case "exemptionCertificate":
            return Optional.ofNullable(clazz.cast(exemptionCertificate()));
        case "exemptionType":
            return Optional.ofNullable(clazz.cast(exemptionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("authority", AUTHORITY_FIELD);
        map.put("exemptionCertificate", EXEMPTION_CERTIFICATE_FIELD);
        map.put("exemptionType", EXEMPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTaxExemptionRequest, T> g) {
        return obj -> g.apply((PutTaxExemptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutTaxExemptionRequest> {
        /**
         * <p>
         * The list of unique account identifiers.
         * </p>
         * 
         * @param accountIds
         *        The list of unique account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The list of unique account identifiers.
         * </p>
         * 
         * @param accountIds
         *        The list of unique account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * Sets the value of the Authority property for this object.
         *
         * @param authority
         *        The new value for the Authority property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authority(Authority authority);

        /**
         * Sets the value of the Authority property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Authority.Builder} avoiding the need to
         * create one manually via {@link Authority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Authority.Builder#build()} is called immediately and its result
         * is passed to {@link #authority(Authority)}.
         * 
         * @param authority
         *        a consumer that will call methods on {@link Authority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authority(Authority)
         */
        default Builder authority(Consumer<Authority.Builder> authority) {
            return authority(Authority.builder().applyMutation(authority).build());
        }

        /**
         * Sets the value of the ExemptionCertificate property for this object.
         *
         * @param exemptionCertificate
         *        The new value for the ExemptionCertificate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exemptionCertificate(ExemptionCertificate exemptionCertificate);

        /**
         * Sets the value of the ExemptionCertificate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExemptionCertificate.Builder} avoiding
         * the need to create one manually via {@link ExemptionCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExemptionCertificate.Builder#build()} is called immediately and
         * its result is passed to {@link #exemptionCertificate(ExemptionCertificate)}.
         * 
         * @param exemptionCertificate
         *        a consumer that will call methods on {@link ExemptionCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exemptionCertificate(ExemptionCertificate)
         */
        default Builder exemptionCertificate(Consumer<ExemptionCertificate.Builder> exemptionCertificate) {
            return exemptionCertificate(ExemptionCertificate.builder().applyMutation(exemptionCertificate).build());
        }

        /**
         * <p>
         * The exemption type. Use the supported tax exemption type description.
         * </p>
         * 
         * @param exemptionType
         *        The exemption type. Use the supported tax exemption type description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exemptionType(String exemptionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TaxSettingsRequest.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private Authority authority;

        private ExemptionCertificate exemptionCertificate;

        private String exemptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTaxExemptionRequest model) {
            super(model);
            accountIds(model.accountIds);
            authority(model.authority);
            exemptionCertificate(model.exemptionCertificate);
            exemptionType(model.exemptionType);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = PutTaxExemptionRequestAccountIdsListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = PutTaxExemptionRequestAccountIdsListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Authority.Builder getAuthority() {
            return authority != null ? authority.toBuilder() : null;
        }

        public final void setAuthority(Authority.BuilderImpl authority) {
            this.authority = authority != null ? authority.build() : null;
        }

        @Override
        public final Builder authority(Authority authority) {
            this.authority = authority;
            return this;
        }

        public final ExemptionCertificate.Builder getExemptionCertificate() {
            return exemptionCertificate != null ? exemptionCertificate.toBuilder() : null;
        }

        public final void setExemptionCertificate(ExemptionCertificate.BuilderImpl exemptionCertificate) {
            this.exemptionCertificate = exemptionCertificate != null ? exemptionCertificate.build() : null;
        }

        @Override
        public final Builder exemptionCertificate(ExemptionCertificate exemptionCertificate) {
            this.exemptionCertificate = exemptionCertificate;
            return this;
        }

        public final String getExemptionType() {
            return exemptionType;
        }

        public final void setExemptionType(String exemptionType) {
            this.exemptionType = exemptionType;
        }

        @Override
        public final Builder exemptionType(String exemptionType) {
            this.exemptionType = exemptionType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTaxExemptionRequest build() {
            return new PutTaxExemptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
