/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Brazil.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrazilAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BrazilAdditionalInfo.Builder, BrazilAdditionalInfo> {
    private static final SdkField<String> CCM_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ccmCode").getter(getter(BrazilAdditionalInfo::ccmCode)).setter(setter(Builder::ccmCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccmCode").build()).build();

    private static final SdkField<String> LEGAL_NATURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("legalNatureCode").getter(getter(BrazilAdditionalInfo::legalNatureCode))
            .setter(setter(Builder::legalNatureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalNatureCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CCM_CODE_FIELD,
            LEGAL_NATURE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ccmCode;

    private final String legalNatureCode;

    private BrazilAdditionalInfo(BuilderImpl builder) {
        this.ccmCode = builder.ccmCode;
        this.legalNatureCode = builder.legalNatureCode;
    }

    /**
     * <p>
     * The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil. This only applies for a CNPJ tax
     * type for the São Paulo municipality.
     * </p>
     * 
     * @return The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil. This only applies for a CNPJ
     *         tax type for the São Paulo municipality.
     */
    public final String ccmCode() {
        return ccmCode;
    }

    /**
     * <p>
     * Legal nature of business, based on your TRN in Brazil. This only applies for a CNPJ tax type.
     * </p>
     * 
     * @return Legal nature of business, based on your TRN in Brazil. This only applies for a CNPJ tax type.
     */
    public final String legalNatureCode() {
        return legalNatureCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ccmCode());
        hashCode = 31 * hashCode + Objects.hashCode(legalNatureCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrazilAdditionalInfo)) {
            return false;
        }
        BrazilAdditionalInfo other = (BrazilAdditionalInfo) obj;
        return Objects.equals(ccmCode(), other.ccmCode()) && Objects.equals(legalNatureCode(), other.legalNatureCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrazilAdditionalInfo").add("CcmCode", ccmCode()).add("LegalNatureCode", legalNatureCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ccmCode":
            return Optional.ofNullable(clazz.cast(ccmCode()));
        case "legalNatureCode":
            return Optional.ofNullable(clazz.cast(legalNatureCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ccmCode", CCM_CODE_FIELD);
        map.put("legalNatureCode", LEGAL_NATURE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrazilAdditionalInfo, T> g) {
        return obj -> g.apply((BrazilAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrazilAdditionalInfo> {
        /**
         * <p>
         * The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil. This only applies for a CNPJ tax
         * type for the São Paulo municipality.
         * </p>
         * 
         * @param ccmCode
         *        The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil. This only applies for a
         *        CNPJ tax type for the São Paulo municipality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccmCode(String ccmCode);

        /**
         * <p>
         * Legal nature of business, based on your TRN in Brazil. This only applies for a CNPJ tax type.
         * </p>
         * 
         * @param legalNatureCode
         *        Legal nature of business, based on your TRN in Brazil. This only applies for a CNPJ tax type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalNatureCode(String legalNatureCode);
    }

    static final class BuilderImpl implements Builder {
        private String ccmCode;

        private String legalNatureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BrazilAdditionalInfo model) {
            ccmCode(model.ccmCode);
            legalNatureCode(model.legalNatureCode);
        }

        public final String getCcmCode() {
            return ccmCode;
        }

        public final void setCcmCode(String ccmCode) {
            this.ccmCode = ccmCode;
        }

        @Override
        public final Builder ccmCode(String ccmCode) {
            this.ccmCode = ccmCode;
            return this;
        }

        public final String getLegalNatureCode() {
            return legalNatureCode;
        }

        public final void setLegalNatureCode(String legalNatureCode) {
            this.legalNatureCode = legalNatureCode;
        }

        @Override
        public final Builder legalNatureCode(String legalNatureCode) {
            this.legalNatureCode = legalNatureCode;
            return this;
        }

        @Override
        public BrazilAdditionalInfo build() {
            return new BrazilAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
