/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.taxsettings.TaxSettingsClient;
import software.amazon.awssdk.services.taxsettings.TaxSettingsServiceClientConfiguration;
import software.amazon.awssdk.services.taxsettings.internal.TaxSettingsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.taxsettings.model.AccessDeniedException;
import software.amazon.awssdk.services.taxsettings.model.AttachmentUploadException;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.BatchGetTaxExemptionsRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchGetTaxExemptionsResponse;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.CaseCreationLimitExceededException;
import software.amazon.awssdk.services.taxsettings.model.ConflictException;
import software.amazon.awssdk.services.taxsettings.model.DeleteSupplementalTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.DeleteSupplementalTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxExemptionTypesRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxExemptionTypesResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxInheritanceRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxInheritanceResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.InternalServerException;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsResponse;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.PutSupplementalTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.PutSupplementalTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxExemptionRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxExemptionResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxInheritanceRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxInheritanceResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.ResourceNotFoundException;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsException;
import software.amazon.awssdk.services.taxsettings.model.ValidationException;
import software.amazon.awssdk.services.taxsettings.transform.BatchDeleteTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.BatchGetTaxExemptionsRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.BatchPutTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.DeleteSupplementalTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.DeleteTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.GetTaxExemptionTypesRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.GetTaxInheritanceRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.GetTaxRegistrationDocumentRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.GetTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.ListSupplementalTaxRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.ListTaxExemptionsRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.ListTaxRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.PutSupplementalTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.PutTaxExemptionRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.PutTaxInheritanceRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.PutTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTaxSettingsClient
implements TaxSettingsClient {
    private static final Logger log = Logger.loggerFor(DefaultTaxSettingsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTaxSettingsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteTaxRegistrationResponse batchDeleteTaxRegistration(BatchDeleteTaxRegistrationRequest batchDeleteTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, batchDeleteTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteTaxRegistration");
            BatchDeleteTaxRegistrationResponse batchDeleteTaxRegistrationResponse = (BatchDeleteTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$batchDeleteTaxRegistration$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetTaxExemptionsResponse batchGetTaxExemptions(BatchGetTaxExemptionsRequest batchGetTaxExemptionsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetTaxExemptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetTaxExemptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, batchGetTaxExemptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetTaxExemptions");
            BatchGetTaxExemptionsResponse batchGetTaxExemptionsResponse = (BatchGetTaxExemptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetTaxExemptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetTaxExemptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetTaxExemptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetTaxExemptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$batchGetTaxExemptions$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutTaxRegistrationResponse batchPutTaxRegistration(BatchPutTaxRegistrationRequest batchPutTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchPutTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, batchPutTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutTaxRegistration");
            BatchPutTaxRegistrationResponse batchPutTaxRegistrationResponse = (BatchPutTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchPutTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchPutTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$batchPutTaxRegistration$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSupplementalTaxRegistrationResponse deleteSupplementalTaxRegistration(DeleteSupplementalTaxRegistrationRequest deleteSupplementalTaxRegistrationRequest) throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSupplementalTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSupplementalTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, deleteSupplementalTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSupplementalTaxRegistration");
            DeleteSupplementalTaxRegistrationResponse deleteSupplementalTaxRegistrationResponse = (DeleteSupplementalTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSupplementalTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSupplementalTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSupplementalTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSupplementalTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$deleteSupplementalTaxRegistration$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTaxRegistrationResponse deleteTaxRegistration(DeleteTaxRegistrationRequest deleteTaxRegistrationRequest) throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, deleteTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTaxRegistration");
            DeleteTaxRegistrationResponse deleteTaxRegistrationResponse = (DeleteTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$deleteTaxRegistration$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaxExemptionTypesResponse getTaxExemptionTypes(GetTaxExemptionTypesRequest getTaxExemptionTypesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaxExemptionTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaxExemptionTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, getTaxExemptionTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaxExemptionTypes");
            GetTaxExemptionTypesResponse getTaxExemptionTypesResponse = (GetTaxExemptionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaxExemptionTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaxExemptionTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaxExemptionTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaxExemptionTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$getTaxExemptionTypes$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaxInheritanceResponse getTaxInheritance(GetTaxInheritanceRequest getTaxInheritanceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaxInheritanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaxInheritanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, getTaxInheritanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaxInheritance");
            GetTaxInheritanceResponse getTaxInheritanceResponse = (GetTaxInheritanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaxInheritance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaxInheritanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaxInheritanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaxInheritanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$getTaxInheritance$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaxRegistrationResponse getTaxRegistration(GetTaxRegistrationRequest getTaxRegistrationRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, getTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaxRegistration");
            GetTaxRegistrationResponse getTaxRegistrationResponse = (GetTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$getTaxRegistration$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaxRegistrationDocumentResponse getTaxRegistrationDocument(GetTaxRegistrationDocumentRequest getTaxRegistrationDocumentRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaxRegistrationDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaxRegistrationDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, getTaxRegistrationDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaxRegistrationDocument");
            GetTaxRegistrationDocumentResponse getTaxRegistrationDocumentResponse = (GetTaxRegistrationDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaxRegistrationDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaxRegistrationDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaxRegistrationDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaxRegistrationDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$getTaxRegistrationDocument$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSupplementalTaxRegistrationsResponse listSupplementalTaxRegistrations(ListSupplementalTaxRegistrationsRequest listSupplementalTaxRegistrationsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSupplementalTaxRegistrationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSupplementalTaxRegistrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, listSupplementalTaxRegistrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSupplementalTaxRegistrations");
            ListSupplementalTaxRegistrationsResponse listSupplementalTaxRegistrationsResponse = (ListSupplementalTaxRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSupplementalTaxRegistrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSupplementalTaxRegistrationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSupplementalTaxRegistrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSupplementalTaxRegistrationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$listSupplementalTaxRegistrations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaxExemptionsResponse listTaxExemptions(ListTaxExemptionsRequest listTaxExemptionsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaxExemptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaxExemptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, listTaxExemptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaxExemptions");
            ListTaxExemptionsResponse listTaxExemptionsResponse = (ListTaxExemptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaxExemptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTaxExemptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTaxExemptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTaxExemptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$listTaxExemptions$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaxRegistrationsResponse listTaxRegistrations(ListTaxRegistrationsRequest listTaxRegistrationsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaxRegistrationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaxRegistrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, listTaxRegistrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaxRegistrations");
            ListTaxRegistrationsResponse listTaxRegistrationsResponse = (ListTaxRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaxRegistrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTaxRegistrationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTaxRegistrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTaxRegistrationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$listTaxRegistrations$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSupplementalTaxRegistrationResponse putSupplementalTaxRegistration(PutSupplementalTaxRegistrationRequest putSupplementalTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSupplementalTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putSupplementalTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, putSupplementalTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSupplementalTaxRegistration");
            PutSupplementalTaxRegistrationResponse putSupplementalTaxRegistrationResponse = (PutSupplementalTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSupplementalTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putSupplementalTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSupplementalTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSupplementalTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$putSupplementalTaxRegistration$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTaxExemptionResponse putTaxExemption(PutTaxExemptionRequest putTaxExemptionRequest) throws ValidationException, AccessDeniedException, CaseCreationLimitExceededException, ResourceNotFoundException, AttachmentUploadException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTaxExemptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTaxExemptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, putTaxExemptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTaxExemption");
            PutTaxExemptionResponse putTaxExemptionResponse = (PutTaxExemptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTaxExemption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTaxExemptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTaxExemptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTaxExemptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$putTaxExemption$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTaxInheritanceResponse putTaxInheritance(PutTaxInheritanceRequest putTaxInheritanceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTaxInheritanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTaxInheritanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, putTaxInheritanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTaxInheritance");
            PutTaxInheritanceResponse putTaxInheritanceResponse = (PutTaxInheritanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTaxInheritance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTaxInheritanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTaxInheritanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTaxInheritanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$putTaxInheritance$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTaxRegistrationResponse putTaxRegistration(PutTaxRegistrationRequest putTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTaxRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "CaseCreationLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CaseCreationLimitExceededException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(CaseCreationLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "AttachmentUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentUploadException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, putTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTaxRegistration");
            PutTaxRegistrationResponse putTaxRegistrationResponse = (PutTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$putTaxRegistration$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "tax";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        TaxSettingsServiceClientConfigurationBuilder serviceConfigBuilder = new TaxSettingsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TaxSettingsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final TaxSettingsServiceClientConfiguration serviceClientConfiguration() {
        return new TaxSettingsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putTaxRegistration$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putTaxInheritance$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putTaxExemption$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSupplementalTaxRegistration$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaxRegistrations$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaxExemptions$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSupplementalTaxRegistrations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaxRegistrationDocument$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaxRegistration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaxInheritance$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaxExemptionTypes$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTaxRegistration$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSupplementalTaxRegistration$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutTaxRegistration$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetTaxExemptions$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteTaxRegistration$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

