/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.taxsettings.TaxSettingsAsyncClient;
import software.amazon.awssdk.services.taxsettings.internal.UserAgentUtils;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration;

public class ListSupplementalTaxRegistrationsPublisher
implements SdkPublisher<ListSupplementalTaxRegistrationsResponse> {
    private final TaxSettingsAsyncClient client;
    private final ListSupplementalTaxRegistrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSupplementalTaxRegistrationsPublisher(TaxSettingsAsyncClient client, ListSupplementalTaxRegistrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSupplementalTaxRegistrationsPublisher(TaxSettingsAsyncClient client, ListSupplementalTaxRegistrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSupplementalTaxRegistrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSupplementalTaxRegistrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SupplementalTaxRegistration> taxRegistrations() {
        Function<ListSupplementalTaxRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taxRegistrations() != null) {
                return response.taxRegistrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSupplementalTaxRegistrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSupplementalTaxRegistrationsResponseFetcher
    implements AsyncPageFetcher<ListSupplementalTaxRegistrationsResponse> {
        private ListSupplementalTaxRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSupplementalTaxRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSupplementalTaxRegistrationsResponse> nextPage(ListSupplementalTaxRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListSupplementalTaxRegistrationsPublisher.this.client.listSupplementalTaxRegistrations(ListSupplementalTaxRegistrationsPublisher.this.firstRequest);
            }
            return ListSupplementalTaxRegistrationsPublisher.this.client.listSupplementalTaxRegistrations((ListSupplementalTaxRegistrationsRequest)((Object)ListSupplementalTaxRegistrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

