/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionDetails;
import software.amazon.awssdk.services.taxsettings.model.TaxExemptionDetailsMapCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaxExemptionsResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, ListTaxExemptionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTaxExemptionsResponse.getter(ListTaxExemptionsResponse::nextToken)).setter(ListTaxExemptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Map<String, TaxExemptionDetails>> TAX_EXEMPTION_DETAILS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taxExemptionDetailsMap").getter(ListTaxExemptionsResponse.getter(ListTaxExemptionsResponse::taxExemptionDetailsMap)).setter(ListTaxExemptionsResponse.setter(Builder::taxExemptionDetailsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptionDetailsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaxExemptionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TAX_EXEMPTION_DETAILS_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("taxExemptionDetailsMap", TAX_EXEMPTION_DETAILS_MAP_FIELD);
        }
    });
    private final String nextToken;
    private final Map<String, TaxExemptionDetails> taxExemptionDetailsMap;

    private ListTaxExemptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taxExemptionDetailsMap = builder.taxExemptionDetailsMap;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTaxExemptionDetailsMap() {
        return this.taxExemptionDetailsMap != null && !(this.taxExemptionDetailsMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, TaxExemptionDetails> taxExemptionDetailsMap() {
        return this.taxExemptionDetailsMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaxExemptionDetailsMap() ? this.taxExemptionDetailsMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaxExemptionsResponse)) {
            return false;
        }
        ListTaxExemptionsResponse other = (ListTaxExemptionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTaxExemptionDetailsMap() == other.hasTaxExemptionDetailsMap() && Objects.equals(this.taxExemptionDetailsMap(), other.taxExemptionDetailsMap());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaxExemptionsResponse").add("NextToken", (Object)this.nextToken()).add("TaxExemptionDetailsMap", this.hasTaxExemptionDetailsMap() ? this.taxExemptionDetailsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "taxExemptionDetailsMap": {
                return Optional.ofNullable(clazz.cast(this.taxExemptionDetailsMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTaxExemptionsResponse, T> g) {
        return obj -> g.apply((ListTaxExemptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Map<String, TaxExemptionDetails> taxExemptionDetailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaxExemptionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.taxExemptionDetailsMap(model.taxExemptionDetailsMap);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Map<String, TaxExemptionDetails.Builder> getTaxExemptionDetailsMap() {
            Map<String, TaxExemptionDetails.Builder> result = TaxExemptionDetailsMapCopier.copyToBuilder(this.taxExemptionDetailsMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaxExemptionDetailsMap(Map<String, TaxExemptionDetails.BuilderImpl> taxExemptionDetailsMap) {
            this.taxExemptionDetailsMap = TaxExemptionDetailsMapCopier.copyFromBuilder(taxExemptionDetailsMap);
        }

        @Override
        public final Builder taxExemptionDetailsMap(Map<String, TaxExemptionDetails> taxExemptionDetailsMap) {
            this.taxExemptionDetailsMap = TaxExemptionDetailsMapCopier.copy(taxExemptionDetailsMap);
            return this;
        }

        @Override
        public ListTaxExemptionsResponse build() {
            return new ListTaxExemptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaxExemptionsResponse> {
        public Builder nextToken(String var1);

        public Builder taxExemptionDetailsMap(Map<String, TaxExemptionDetails> var1);
    }
}

