/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.taxsettings.TaxSettingsClient;
import software.amazon.awssdk.services.taxsettings.TaxSettingsServiceClientConfiguration;
import software.amazon.awssdk.services.taxsettings.internal.TaxSettingsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.ConflictException;
import software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.InternalServerException;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.ResourceNotFoundException;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsException;
import software.amazon.awssdk.services.taxsettings.model.ValidationException;
import software.amazon.awssdk.services.taxsettings.transform.BatchDeleteTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.BatchPutTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.DeleteTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.GetTaxRegistrationDocumentRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.GetTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.ListTaxRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.taxsettings.transform.PutTaxRegistrationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTaxSettingsClient
implements TaxSettingsClient {
    private static final Logger log = Logger.loggerFor(DefaultTaxSettingsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTaxSettingsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteTaxRegistrationResponse batchDeleteTaxRegistration(BatchDeleteTaxRegistrationRequest batchDeleteTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteTaxRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, batchDeleteTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteTaxRegistration");
            BatchDeleteTaxRegistrationResponse batchDeleteTaxRegistrationResponse = (BatchDeleteTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$batchDeleteTaxRegistration$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutTaxRegistrationResponse batchPutTaxRegistration(BatchPutTaxRegistrationRequest batchPutTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutTaxRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchPutTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, batchPutTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutTaxRegistration");
            BatchPutTaxRegistrationResponse batchPutTaxRegistrationResponse = (BatchPutTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchPutTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchPutTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$batchPutTaxRegistration$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTaxRegistrationResponse deleteTaxRegistration(DeleteTaxRegistrationRequest deleteTaxRegistrationRequest) throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTaxRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, deleteTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTaxRegistration");
            DeleteTaxRegistrationResponse deleteTaxRegistrationResponse = (DeleteTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$deleteTaxRegistration$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaxRegistrationResponse getTaxRegistration(GetTaxRegistrationRequest getTaxRegistrationRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaxRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, getTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaxRegistration");
            GetTaxRegistrationResponse getTaxRegistrationResponse = (GetTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$getTaxRegistration$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTaxRegistrationDocumentResponse getTaxRegistrationDocument(GetTaxRegistrationDocumentRequest getTaxRegistrationDocumentRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTaxRegistrationDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTaxRegistrationDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, getTaxRegistrationDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTaxRegistrationDocument");
            GetTaxRegistrationDocumentResponse getTaxRegistrationDocumentResponse = (GetTaxRegistrationDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTaxRegistrationDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTaxRegistrationDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTaxRegistrationDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTaxRegistrationDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$getTaxRegistrationDocument$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaxRegistrationsResponse listTaxRegistrations(ListTaxRegistrationsRequest listTaxRegistrationsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTaxRegistrationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTaxRegistrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, listTaxRegistrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTaxRegistrations");
            ListTaxRegistrationsResponse listTaxRegistrationsResponse = (ListTaxRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTaxRegistrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTaxRegistrationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTaxRegistrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTaxRegistrationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$listTaxRegistrations$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTaxRegistrationResponse putTaxRegistration(PutTaxRegistrationRequest putTaxRegistrationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTaxRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTaxRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTaxSettingsClient.resolveMetricPublishers(clientConfiguration, putTaxRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TaxSettings");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTaxRegistration");
            PutTaxRegistrationResponse putTaxRegistrationResponse = (PutTaxRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTaxRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTaxRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTaxRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTaxRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTaxSettingsClient.lambda$putTaxRegistration$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "tax";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        TaxSettingsServiceClientConfigurationBuilder serviceConfigBuilder = new TaxSettingsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TaxSettingsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final TaxSettingsServiceClientConfiguration serviceClientConfiguration() {
        return new TaxSettingsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putTaxRegistration$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTaxRegistrations$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaxRegistrationDocument$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTaxRegistration$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTaxRegistration$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutTaxRegistration$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteTaxRegistration$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

