/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCanaryDryRunRequest extends SyntheticsRequest implements
        ToCopyableBuilder<StartCanaryDryRunRequest.Builder, StartCanaryDryRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartCanaryDryRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<CanaryCodeInput> CODE_FIELD = SdkField.<CanaryCodeInput> builder(MarshallingType.SDK_POJO)
            .memberName("Code").getter(getter(StartCanaryDryRunRequest::code)).setter(setter(Builder::code))
            .constructor(CanaryCodeInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeVersion").getter(getter(StartCanaryDryRunRequest::runtimeVersion))
            .setter(setter(Builder::runtimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()).build();

    private static final SdkField<CanaryRunConfigInput> RUN_CONFIG_FIELD = SdkField
            .<CanaryRunConfigInput> builder(MarshallingType.SDK_POJO).memberName("RunConfig")
            .getter(getter(StartCanaryDryRunRequest::runConfig)).setter(setter(Builder::runConfig))
            .constructor(CanaryRunConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()).build();

    private static final SdkField<VpcConfigInput> VPC_CONFIG_FIELD = SdkField.<VpcConfigInput> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(StartCanaryDryRunRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(StartCanaryDryRunRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuccessRetentionPeriodInDays")
            .getter(getter(StartCanaryDryRunRequest::successRetentionPeriodInDays))
            .setter(setter(Builder::successRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailureRetentionPeriodInDays")
            .getter(getter(StartCanaryDryRunRequest::failureRetentionPeriodInDays))
            .setter(setter(Builder::failureRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<VisualReferenceInput> VISUAL_REFERENCE_FIELD = SdkField
            .<VisualReferenceInput> builder(MarshallingType.SDK_POJO).memberName("VisualReference")
            .getter(getter(StartCanaryDryRunRequest::visualReference)).setter(setter(Builder::visualReference))
            .constructor(VisualReferenceInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReference").build()).build();

    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactS3Location").getter(getter(StartCanaryDryRunRequest::artifactS3Location))
            .setter(setter(Builder::artifactS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build())
            .build();

    private static final SdkField<ArtifactConfigInput> ARTIFACT_CONFIG_FIELD = SdkField
            .<ArtifactConfigInput> builder(MarshallingType.SDK_POJO).memberName("ArtifactConfig")
            .getter(getter(StartCanaryDryRunRequest::artifactConfig)).setter(setter(Builder::artifactConfig))
            .constructor(ArtifactConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactConfig").build()).build();

    private static final SdkField<String> PROVISIONED_RESOURCE_CLEANUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedResourceCleanup")
            .getter(getter(StartCanaryDryRunRequest::provisionedResourceCleanupAsString))
            .setter(setter(Builder::provisionedResourceCleanup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedResourceCleanup").build())
            .build();

    private static final SdkField<List<BrowserConfig>> BROWSER_CONFIGS_FIELD = SdkField
            .<List<BrowserConfig>> builder(MarshallingType.LIST)
            .memberName("BrowserConfigs")
            .getter(getter(StartCanaryDryRunRequest::browserConfigs))
            .setter(setter(Builder::browserConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrowserConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrowserConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrowserConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VisualReferenceInput>> VISUAL_REFERENCES_FIELD = SdkField
            .<List<VisualReferenceInput>> builder(MarshallingType.LIST)
            .memberName("VisualReferences")
            .getter(getter(StartCanaryDryRunRequest::visualReferences))
            .setter(setter(Builder::visualReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VisualReferenceInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(VisualReferenceInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_FIELD,
            RUNTIME_VERSION_FIELD, RUN_CONFIG_FIELD, VPC_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD,
            SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, VISUAL_REFERENCE_FIELD,
            ARTIFACT_S3_LOCATION_FIELD, ARTIFACT_CONFIG_FIELD, PROVISIONED_RESOURCE_CLEANUP_FIELD, BROWSER_CONFIGS_FIELD,
            VISUAL_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final CanaryCodeInput code;

    private final String runtimeVersion;

    private final CanaryRunConfigInput runConfig;

    private final VpcConfigInput vpcConfig;

    private final String executionRoleArn;

    private final Integer successRetentionPeriodInDays;

    private final Integer failureRetentionPeriodInDays;

    private final VisualReferenceInput visualReference;

    private final String artifactS3Location;

    private final ArtifactConfigInput artifactConfig;

    private final String provisionedResourceCleanup;

    private final List<BrowserConfig> browserConfigs;

    private final List<VisualReferenceInput> visualReferences;

    private StartCanaryDryRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.code = builder.code;
        this.runtimeVersion = builder.runtimeVersion;
        this.runConfig = builder.runConfig;
        this.vpcConfig = builder.vpcConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.visualReference = builder.visualReference;
        this.artifactS3Location = builder.artifactS3Location;
        this.artifactConfig = builder.artifactConfig;
        this.provisionedResourceCleanup = builder.provisionedResourceCleanup;
        this.browserConfigs = builder.browserConfigs;
        this.visualReferences = builder.visualReferences;
    }

    /**
     * <p>
     * The name of the canary that you want to dry run. To find canary names, use <a
     * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
     * >DescribeCanaries</a>.
     * </p>
     * 
     * @return The name of the canary that you want to dry run. To find canary names, use <a
     *         href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
     *         >DescribeCanaries</a>.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public final CanaryCodeInput code() {
        return code;
    }

    /**
     * <p>
     * Specifies the runtime version to use for the canary. For a list of valid runtime versions and for more
     * information about runtime versions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
     * Canary Runtime Versions</a>.
     * </p>
     * 
     * @return Specifies the runtime version to use for the canary. For a list of valid runtime versions and for more
     *         information about runtime versions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
     *         > Canary Runtime Versions</a>.
     */
    public final String runtimeVersion() {
        return runtimeVersion;
    }

    /**
     * Returns the value of the RunConfig property for this object.
     * 
     * @return The value of the RunConfig property for this object.
     */
    public final CanaryRunConfigInput runConfig() {
        return runConfig;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfigInput vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
     * <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following
     * permissions:
     * </p>
     * 
     * @return The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
     *         <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the
     *         following permissions:
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The number of days to retain data about successful runs of this canary. If you omit this field, the default of 31
     * days is used. The valid range is 1 to 455 days.
     * </p>
     * <p>
     * This setting affects the range of information returned by <a
     * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html">GetCanaryRuns</a>,
     * as well as the range of information displayed in the Synthetics console.
     * </p>
     * 
     * @return The number of days to retain data about successful runs of this canary. If you omit this field, the
     *         default of 31 days is used. The valid range is 1 to 455 days.</p>
     *         <p>
     *         This setting affects the range of information returned by <a
     *         href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html"
     *         >GetCanaryRuns</a>, as well as the range of information displayed in the Synthetics console.
     */
    public final Integer successRetentionPeriodInDays() {
        return successRetentionPeriodInDays;
    }

    /**
     * <p>
     * The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31
     * days is used. The valid range is 1 to 455 days.
     * </p>
     * <p>
     * This setting affects the range of information returned by <a
     * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html">GetCanaryRuns</a>,
     * as well as the range of information displayed in the Synthetics console.
     * </p>
     * 
     * @return The number of days to retain data about failed runs of this canary. If you omit this field, the default
     *         of 31 days is used. The valid range is 1 to 455 days.</p>
     *         <p>
     *         This setting affects the range of information returned by <a
     *         href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html"
     *         >GetCanaryRuns</a>, as well as the range of information displayed in the Synthetics console.
     */
    public final Integer failureRetentionPeriodInDays() {
        return failureRetentionPeriodInDays;
    }

    /**
     * Returns the value of the VisualReference property for this object.
     * 
     * @return The value of the VisualReference property for this object.
     */
    public final VisualReferenceInput visualReference() {
        return visualReference;
    }

    /**
     * <p>
     * The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts include
     * the log file, screenshots, and HAR files. The name of the Amazon S3 bucket can't include a period (.).
     * </p>
     * 
     * @return The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts
     *         include the log file, screenshots, and HAR files. The name of the Amazon S3 bucket can't include a period
     *         (.).
     */
    public final String artifactS3Location() {
        return artifactS3Location;
    }

    /**
     * Returns the value of the ArtifactConfig property for this object.
     * 
     * @return The value of the ArtifactConfig property for this object.
     */
    public final ArtifactConfigInput artifactConfig() {
        return artifactConfig;
    }

    /**
     * <p>
     * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is deleted.
     * If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means that the Lambda functions
     * and layers will be deleted when the canary is deleted.
     * </p>
     * <p>
     * If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code> parameter of
     * the <a
     * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html">DeleteCanary</a>
     * operation determines whether the Lambda functions and layers will be deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisionedResourceCleanup} will return {@link ProvisionedResourceCleanupSetting#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #provisionedResourceCleanupAsString}.
     * </p>
     * 
     * @return Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is
     *         deleted. If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means that the
     *         Lambda functions and layers will be deleted when the canary is deleted.</p>
     *         <p>
     *         If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code>
     *         parameter of the <a
     *         href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html"
     *         >DeleteCanary</a> operation determines whether the Lambda functions and layers will be deleted.
     * @see ProvisionedResourceCleanupSetting
     */
    public final ProvisionedResourceCleanupSetting provisionedResourceCleanup() {
        return ProvisionedResourceCleanupSetting.fromValue(provisionedResourceCleanup);
    }

    /**
     * <p>
     * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is deleted.
     * If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means that the Lambda functions
     * and layers will be deleted when the canary is deleted.
     * </p>
     * <p>
     * If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code> parameter of
     * the <a
     * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html">DeleteCanary</a>
     * operation determines whether the Lambda functions and layers will be deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisionedResourceCleanup} will return {@link ProvisionedResourceCleanupSetting#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #provisionedResourceCleanupAsString}.
     * </p>
     * 
     * @return Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is
     *         deleted. If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means that the
     *         Lambda functions and layers will be deleted when the canary is deleted.</p>
     *         <p>
     *         If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code>
     *         parameter of the <a
     *         href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html"
     *         >DeleteCanary</a> operation determines whether the Lambda functions and layers will be deleted.
     * @see ProvisionedResourceCleanupSetting
     */
    public final String provisionedResourceCleanupAsString() {
        return provisionedResourceCleanup;
    }

    /**
     * For responses, this returns true if the service returned a value for the BrowserConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBrowserConfigs() {
        return browserConfigs != null && !(browserConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports running
     * canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.
     * </p>
     * <note>
     * <p>
     * If not specified, <code>browserConfigs</code> defaults to Chrome.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrowserConfigs} method.
     * </p>
     * 
     * @return A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports
     *         running canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.</p> <note>
     *         <p>
     *         If not specified, <code>browserConfigs</code> defaults to Chrome.
     *         </p>
     */
    public final List<BrowserConfig> browserConfigs() {
        return browserConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the VisualReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVisualReferences() {
        return visualReferences != null && !(visualReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of visual reference configurations for the canary, one for each browser type that the canary is configured
     * to run on. Visual references are used for visual monitoring comparisons.
     * </p>
     * <p>
     * <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above, only
     * supports <code>visualReferences</code>. <code>visualReference</code> field is not supported.
     * </p>
     * <p>
     * Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and
     * <code>visualReferences</code> for backward compatibility. It is recommended to use <code>visualReferences</code>
     * for consistency and future compatibility.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVisualReferences} method.
     * </p>
     * 
     * @return A list of visual reference configurations for the canary, one for each browser type that the canary is
     *         configured to run on. Visual references are used for visual monitoring comparisons.</p>
     *         <p>
     *         <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above,
     *         only supports <code>visualReferences</code>. <code>visualReference</code> field is not supported.
     *         </p>
     *         <p>
     *         Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and
     *         <code>visualReferences</code> for backward compatibility. It is recommended to use
     *         <code>visualReferences</code> for consistency and future compatibility.
     */
    public final List<VisualReferenceInput> visualReferences() {
        return visualReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(visualReference());
        hashCode = 31 * hashCode + Objects.hashCode(artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(artifactConfig());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedResourceCleanupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBrowserConfigs() ? browserConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVisualReferences() ? visualReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCanaryDryRunRequest)) {
            return false;
        }
        StartCanaryDryRunRequest other = (StartCanaryDryRunRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(code(), other.code())
                && Objects.equals(runtimeVersion(), other.runtimeVersion()) && Objects.equals(runConfig(), other.runConfig())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(successRetentionPeriodInDays(), other.successRetentionPeriodInDays())
                && Objects.equals(failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays())
                && Objects.equals(visualReference(), other.visualReference())
                && Objects.equals(artifactS3Location(), other.artifactS3Location())
                && Objects.equals(artifactConfig(), other.artifactConfig())
                && Objects.equals(provisionedResourceCleanupAsString(), other.provisionedResourceCleanupAsString())
                && hasBrowserConfigs() == other.hasBrowserConfigs() && Objects.equals(browserConfigs(), other.browserConfigs())
                && hasVisualReferences() == other.hasVisualReferences()
                && Objects.equals(visualReferences(), other.visualReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCanaryDryRunRequest").add("Name", name()).add("Code", code())
                .add("RuntimeVersion", runtimeVersion()).add("RunConfig", runConfig()).add("VpcConfig", vpcConfig())
                .add("ExecutionRoleArn", executionRoleArn()).add("SuccessRetentionPeriodInDays", successRetentionPeriodInDays())
                .add("FailureRetentionPeriodInDays", failureRetentionPeriodInDays()).add("VisualReference", visualReference())
                .add("ArtifactS3Location", artifactS3Location()).add("ArtifactConfig", artifactConfig())
                .add("ProvisionedResourceCleanup", provisionedResourceCleanupAsString())
                .add("BrowserConfigs", hasBrowserConfigs() ? browserConfigs() : null)
                .add("VisualReferences", hasVisualReferences() ? visualReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "RuntimeVersion":
            return Optional.ofNullable(clazz.cast(runtimeVersion()));
        case "RunConfig":
            return Optional.ofNullable(clazz.cast(runConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "SuccessRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(successRetentionPeriodInDays()));
        case "FailureRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(failureRetentionPeriodInDays()));
        case "VisualReference":
            return Optional.ofNullable(clazz.cast(visualReference()));
        case "ArtifactS3Location":
            return Optional.ofNullable(clazz.cast(artifactS3Location()));
        case "ArtifactConfig":
            return Optional.ofNullable(clazz.cast(artifactConfig()));
        case "ProvisionedResourceCleanup":
            return Optional.ofNullable(clazz.cast(provisionedResourceCleanupAsString()));
        case "BrowserConfigs":
            return Optional.ofNullable(clazz.cast(browserConfigs()));
        case "VisualReferences":
            return Optional.ofNullable(clazz.cast(visualReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("RuntimeVersion", RUNTIME_VERSION_FIELD);
        map.put("RunConfig", RUN_CONFIG_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("SuccessRetentionPeriodInDays", SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("FailureRetentionPeriodInDays", FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("VisualReference", VISUAL_REFERENCE_FIELD);
        map.put("ArtifactS3Location", ARTIFACT_S3_LOCATION_FIELD);
        map.put("ArtifactConfig", ARTIFACT_CONFIG_FIELD);
        map.put("ProvisionedResourceCleanup", PROVISIONED_RESOURCE_CLEANUP_FIELD);
        map.put("BrowserConfigs", BROWSER_CONFIGS_FIELD);
        map.put("VisualReferences", VISUAL_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCanaryDryRunRequest, T> g) {
        return obj -> g.apply((StartCanaryDryRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SyntheticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCanaryDryRunRequest> {
        /**
         * <p>
         * The name of the canary that you want to dry run. To find canary names, use <a
         * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
         * >DescribeCanaries</a>.
         * </p>
         * 
         * @param name
         *        The name of the canary that you want to dry run. To find canary names, use <a
         *        href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html"
         *        >DescribeCanaries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(CanaryCodeInput code);

        /**
         * Sets the value of the Code property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CanaryCodeInput.Builder} avoiding the
         * need to create one manually via {@link CanaryCodeInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CanaryCodeInput.Builder#build()} is called immediately and its
         * result is passed to {@link #code(CanaryCodeInput)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link CanaryCodeInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(CanaryCodeInput)
         */
        default Builder code(Consumer<CanaryCodeInput.Builder> code) {
            return code(CanaryCodeInput.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * Specifies the runtime version to use for the canary. For a list of valid runtime versions and for more
         * information about runtime versions, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">
         * Canary Runtime Versions</a>.
         * </p>
         * 
         * @param runtimeVersion
         *        Specifies the runtime version to use for the canary. For a list of valid runtime versions and for more
         *        information about runtime versions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html"
         *        > Canary Runtime Versions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersion(String runtimeVersion);

        /**
         * Sets the value of the RunConfig property for this object.
         *
         * @param runConfig
         *        The new value for the RunConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runConfig(CanaryRunConfigInput runConfig);

        /**
         * Sets the value of the RunConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CanaryRunConfigInput.Builder} avoiding
         * the need to create one manually via {@link CanaryRunConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CanaryRunConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #runConfig(CanaryRunConfigInput)}.
         * 
         * @param runConfig
         *        a consumer that will call methods on {@link CanaryRunConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runConfig(CanaryRunConfigInput)
         */
        default Builder runConfig(Consumer<CanaryRunConfigInput.Builder> runConfig) {
            return runConfig(CanaryRunConfigInput.builder().applyMutation(runConfig).build());
        }

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfigInput vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfigInput.Builder} avoiding the need
         * to create one manually via {@link VpcConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(VpcConfigInput)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfigInput)
         */
        default Builder vpcConfig(Consumer<VpcConfigInput.Builder> vpcConfig) {
            return vpcConfig(VpcConfigInput.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
         * <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following
         * permissions:
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the IAM role to be used to run the canary. This role must already exist, and must include
         *        <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the
         *        following permissions:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The number of days to retain data about successful runs of this canary. If you omit this field, the default
         * of 31 days is used. The valid range is 1 to 455 days.
         * </p>
         * <p>
         * This setting affects the range of information returned by <a
         * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html"
         * >GetCanaryRuns</a>, as well as the range of information displayed in the Synthetics console.
         * </p>
         * 
         * @param successRetentionPeriodInDays
         *        The number of days to retain data about successful runs of this canary. If you omit this field, the
         *        default of 31 days is used. The valid range is 1 to 455 days.</p>
         *        <p>
         *        This setting affects the range of information returned by <a
         *        href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html"
         *        >GetCanaryRuns</a>, as well as the range of information displayed in the Synthetics console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays);

        /**
         * <p>
         * The number of days to retain data about failed runs of this canary. If you omit this field, the default of 31
         * days is used. The valid range is 1 to 455 days.
         * </p>
         * <p>
         * This setting affects the range of information returned by <a
         * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html"
         * >GetCanaryRuns</a>, as well as the range of information displayed in the Synthetics console.
         * </p>
         * 
         * @param failureRetentionPeriodInDays
         *        The number of days to retain data about failed runs of this canary. If you omit this field, the
         *        default of 31 days is used. The valid range is 1 to 455 days.</p>
         *        <p>
         *        This setting affects the range of information returned by <a
         *        href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html"
         *        >GetCanaryRuns</a>, as well as the range of information displayed in the Synthetics console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays);

        /**
         * Sets the value of the VisualReference property for this object.
         *
         * @param visualReference
         *        The new value for the VisualReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualReference(VisualReferenceInput visualReference);

        /**
         * Sets the value of the VisualReference property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualReferenceInput.Builder} avoiding
         * the need to create one manually via {@link VisualReferenceInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualReferenceInput.Builder#build()} is called immediately and
         * its result is passed to {@link #visualReference(VisualReferenceInput)}.
         * 
         * @param visualReference
         *        a consumer that will call methods on {@link VisualReferenceInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualReference(VisualReferenceInput)
         */
        default Builder visualReference(Consumer<VisualReferenceInput.Builder> visualReference) {
            return visualReference(VisualReferenceInput.builder().applyMutation(visualReference).build());
        }

        /**
         * <p>
         * The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary. Artifacts
         * include the log file, screenshots, and HAR files. The name of the Amazon S3 bucket can't include a period
         * (.).
         * </p>
         * 
         * @param artifactS3Location
         *        The location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
         *        Artifacts include the log file, screenshots, and HAR files. The name of the Amazon S3 bucket can't
         *        include a period (.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactS3Location(String artifactS3Location);

        /**
         * Sets the value of the ArtifactConfig property for this object.
         *
         * @param artifactConfig
         *        The new value for the ArtifactConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactConfig(ArtifactConfigInput artifactConfig);

        /**
         * Sets the value of the ArtifactConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ArtifactConfigInput.Builder} avoiding the
         * need to create one manually via {@link ArtifactConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactConfigInput.Builder#build()} is called immediately and
         * its result is passed to {@link #artifactConfig(ArtifactConfigInput)}.
         * 
         * @param artifactConfig
         *        a consumer that will call methods on {@link ArtifactConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactConfig(ArtifactConfigInput)
         */
        default Builder artifactConfig(Consumer<ArtifactConfigInput.Builder> artifactConfig) {
            return artifactConfig(ArtifactConfigInput.builder().applyMutation(artifactConfig).build());
        }

        /**
         * <p>
         * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is
         * deleted. If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means that the
         * Lambda functions and layers will be deleted when the canary is deleted.
         * </p>
         * <p>
         * If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code> parameter
         * of the <a
         * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html">DeleteCanary
         * </a> operation determines whether the Lambda functions and layers will be deleted.
         * </p>
         * 
         * @param provisionedResourceCleanup
         *        Specifies whether to also delete the Lambda functions and layers used by this canary when the canary
         *        is deleted. If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means
         *        that the Lambda functions and layers will be deleted when the canary is deleted.</p>
         *        <p>
         *        If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code>
         *        parameter of the <a
         *        href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html"
         *        >DeleteCanary</a> operation determines whether the Lambda functions and layers will be deleted.
         * @see ProvisionedResourceCleanupSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedResourceCleanupSetting
         */
        Builder provisionedResourceCleanup(String provisionedResourceCleanup);

        /**
         * <p>
         * Specifies whether to also delete the Lambda functions and layers used by this canary when the canary is
         * deleted. If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means that the
         * Lambda functions and layers will be deleted when the canary is deleted.
         * </p>
         * <p>
         * If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code> parameter
         * of the <a
         * href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html">DeleteCanary
         * </a> operation determines whether the Lambda functions and layers will be deleted.
         * </p>
         * 
         * @param provisionedResourceCleanup
         *        Specifies whether to also delete the Lambda functions and layers used by this canary when the canary
         *        is deleted. If you omit this parameter, the default of <code>AUTOMATIC</code> is used, which means
         *        that the Lambda functions and layers will be deleted when the canary is deleted.</p>
         *        <p>
         *        If the value of this parameter is <code>OFF</code>, then the value of the <code>DeleteLambda</code>
         *        parameter of the <a
         *        href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html"
         *        >DeleteCanary</a> operation determines whether the Lambda functions and layers will be deleted.
         * @see ProvisionedResourceCleanupSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedResourceCleanupSetting
         */
        Builder provisionedResourceCleanup(ProvisionedResourceCleanupSetting provisionedResourceCleanup);

        /**
         * <p>
         * A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports running
         * canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.
         * </p>
         * <note>
         * <p>
         * If not specified, <code>browserConfigs</code> defaults to Chrome.
         * </p>
         * </note>
         * 
         * @param browserConfigs
         *        A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports
         *        running canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.</p> <note>
         *        <p>
         *        If not specified, <code>browserConfigs</code> defaults to Chrome.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserConfigs(Collection<BrowserConfig> browserConfigs);

        /**
         * <p>
         * A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports running
         * canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.
         * </p>
         * <note>
         * <p>
         * If not specified, <code>browserConfigs</code> defaults to Chrome.
         * </p>
         * </note>
         * 
         * @param browserConfigs
         *        A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports
         *        running canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.</p> <note>
         *        <p>
         *        If not specified, <code>browserConfigs</code> defaults to Chrome.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserConfigs(BrowserConfig... browserConfigs);

        /**
         * <p>
         * A structure that specifies the browser type to use for a canary run. CloudWatch Synthetics supports running
         * canaries on both <code>CHROME</code> and <code>FIREFOX</code> browsers.
         * </p>
         * <note>
         * <p>
         * If not specified, <code>browserConfigs</code> defaults to Chrome.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.synthetics.model.BrowserConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.synthetics.model.BrowserConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.synthetics.model.BrowserConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #browserConfigs(List<BrowserConfig>)}.
         * 
         * @param browserConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.synthetics.model.BrowserConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #browserConfigs(java.util.Collection<BrowserConfig>)
         */
        Builder browserConfigs(Consumer<BrowserConfig.Builder>... browserConfigs);

        /**
         * <p>
         * A list of visual reference configurations for the canary, one for each browser type that the canary is
         * configured to run on. Visual references are used for visual monitoring comparisons.
         * </p>
         * <p>
         * <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above, only
         * supports <code>visualReferences</code>. <code>visualReference</code> field is not supported.
         * </p>
         * <p>
         * Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and
         * <code>visualReferences</code> for backward compatibility. It is recommended to use
         * <code>visualReferences</code> for consistency and future compatibility.
         * </p>
         * 
         * @param visualReferences
         *        A list of visual reference configurations for the canary, one for each browser type that the canary is
         *        configured to run on. Visual references are used for visual monitoring comparisons.</p>
         *        <p>
         *        <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and
         *        above, only supports <code>visualReferences</code>. <code>visualReference</code> field is not
         *        supported.
         *        </p>
         *        <p>
         *        Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code>
         *        and <code>visualReferences</code> for backward compatibility. It is recommended to use
         *        <code>visualReferences</code> for consistency and future compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualReferences(Collection<VisualReferenceInput> visualReferences);

        /**
         * <p>
         * A list of visual reference configurations for the canary, one for each browser type that the canary is
         * configured to run on. Visual references are used for visual monitoring comparisons.
         * </p>
         * <p>
         * <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above, only
         * supports <code>visualReferences</code>. <code>visualReference</code> field is not supported.
         * </p>
         * <p>
         * Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and
         * <code>visualReferences</code> for backward compatibility. It is recommended to use
         * <code>visualReferences</code> for consistency and future compatibility.
         * </p>
         * 
         * @param visualReferences
         *        A list of visual reference configurations for the canary, one for each browser type that the canary is
         *        configured to run on. Visual references are used for visual monitoring comparisons.</p>
         *        <p>
         *        <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and
         *        above, only supports <code>visualReferences</code>. <code>visualReference</code> field is not
         *        supported.
         *        </p>
         *        <p>
         *        Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code>
         *        and <code>visualReferences</code> for backward compatibility. It is recommended to use
         *        <code>visualReferences</code> for consistency and future compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualReferences(VisualReferenceInput... visualReferences);

        /**
         * <p>
         * A list of visual reference configurations for the canary, one for each browser type that the canary is
         * configured to run on. Visual references are used for visual monitoring comparisons.
         * </p>
         * <p>
         * <code>syn-nodejs-puppeteer-11.0</code> and above, and <code>syn-nodejs-playwright-3.0</code> and above, only
         * supports <code>visualReferences</code>. <code>visualReference</code> field is not supported.
         * </p>
         * <p>
         * Versions older than <code>syn-nodejs-puppeteer-11.0</code> supports both <code>visualReference</code> and
         * <code>visualReferences</code> for backward compatibility. It is recommended to use
         * <code>visualReferences</code> for consistency and future compatibility.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.synthetics.model.VisualReferenceInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.synthetics.model.VisualReferenceInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.synthetics.model.VisualReferenceInput.Builder#build()} is called
         * immediately and its result is passed to {@link #visualReferences(List<VisualReferenceInput>)}.
         * 
         * @param visualReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.synthetics.model.VisualReferenceInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualReferences(java.util.Collection<VisualReferenceInput>)
         */
        Builder visualReferences(Consumer<VisualReferenceInput.Builder>... visualReferences);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SyntheticsRequest.BuilderImpl implements Builder {
        private String name;

        private CanaryCodeInput code;

        private String runtimeVersion;

        private CanaryRunConfigInput runConfig;

        private VpcConfigInput vpcConfig;

        private String executionRoleArn;

        private Integer successRetentionPeriodInDays;

        private Integer failureRetentionPeriodInDays;

        private VisualReferenceInput visualReference;

        private String artifactS3Location;

        private ArtifactConfigInput artifactConfig;

        private String provisionedResourceCleanup;

        private List<BrowserConfig> browserConfigs = DefaultSdkAutoConstructList.getInstance();

        private List<VisualReferenceInput> visualReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCanaryDryRunRequest model) {
            super(model);
            name(model.name);
            code(model.code);
            runtimeVersion(model.runtimeVersion);
            runConfig(model.runConfig);
            vpcConfig(model.vpcConfig);
            executionRoleArn(model.executionRoleArn);
            successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            visualReference(model.visualReference);
            artifactS3Location(model.artifactS3Location);
            artifactConfig(model.artifactConfig);
            provisionedResourceCleanup(model.provisionedResourceCleanup);
            browserConfigs(model.browserConfigs);
            visualReferences(model.visualReferences);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryCodeInput.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        public final void setCode(CanaryCodeInput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CanaryCodeInput code) {
            this.code = code;
            return this;
        }

        public final String getRuntimeVersion() {
            return runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final CanaryRunConfigInput.Builder getRunConfig() {
            return runConfig != null ? runConfig.toBuilder() : null;
        }

        public final void setRunConfig(CanaryRunConfigInput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        @Override
        public final Builder runConfig(CanaryRunConfigInput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final VpcConfigInput.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigInput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigInput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return successRetentionPeriodInDays;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        @Override
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return failureRetentionPeriodInDays;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        @Override
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final VisualReferenceInput.Builder getVisualReference() {
            return visualReference != null ? visualReference.toBuilder() : null;
        }

        public final void setVisualReference(VisualReferenceInput.BuilderImpl visualReference) {
            this.visualReference = visualReference != null ? visualReference.build() : null;
        }

        @Override
        public final Builder visualReference(VisualReferenceInput visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        public final String getArtifactS3Location() {
            return artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final ArtifactConfigInput.Builder getArtifactConfig() {
            return artifactConfig != null ? artifactConfig.toBuilder() : null;
        }

        public final void setArtifactConfig(ArtifactConfigInput.BuilderImpl artifactConfig) {
            this.artifactConfig = artifactConfig != null ? artifactConfig.build() : null;
        }

        @Override
        public final Builder artifactConfig(ArtifactConfigInput artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        public final String getProvisionedResourceCleanup() {
            return provisionedResourceCleanup;
        }

        public final void setProvisionedResourceCleanup(String provisionedResourceCleanup) {
            this.provisionedResourceCleanup = provisionedResourceCleanup;
        }

        @Override
        public final Builder provisionedResourceCleanup(String provisionedResourceCleanup) {
            this.provisionedResourceCleanup = provisionedResourceCleanup;
            return this;
        }

        @Override
        public final Builder provisionedResourceCleanup(ProvisionedResourceCleanupSetting provisionedResourceCleanup) {
            this.provisionedResourceCleanup(provisionedResourceCleanup == null ? null : provisionedResourceCleanup.toString());
            return this;
        }

        public final List<BrowserConfig.Builder> getBrowserConfigs() {
            List<BrowserConfig.Builder> result = BrowserConfigsCopier.copyToBuilder(this.browserConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrowserConfigs(Collection<BrowserConfig.BuilderImpl> browserConfigs) {
            this.browserConfigs = BrowserConfigsCopier.copyFromBuilder(browserConfigs);
        }

        @Override
        public final Builder browserConfigs(Collection<BrowserConfig> browserConfigs) {
            this.browserConfigs = BrowserConfigsCopier.copy(browserConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserConfigs(BrowserConfig... browserConfigs) {
            browserConfigs(Arrays.asList(browserConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserConfigs(Consumer<BrowserConfig.Builder>... browserConfigs) {
            browserConfigs(Stream.of(browserConfigs).map(c -> BrowserConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VisualReferenceInput.Builder> getVisualReferences() {
            List<VisualReferenceInput.Builder> result = VisualReferencesCopier.copyToBuilder(this.visualReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVisualReferences(Collection<VisualReferenceInput.BuilderImpl> visualReferences) {
            this.visualReferences = VisualReferencesCopier.copyFromBuilder(visualReferences);
        }

        @Override
        public final Builder visualReferences(Collection<VisualReferenceInput> visualReferences) {
            this.visualReferences = VisualReferencesCopier.copy(visualReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualReferences(VisualReferenceInput... visualReferences) {
            visualReferences(Arrays.asList(visualReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualReferences(Consumer<VisualReferenceInput.Builder>... visualReferences) {
            visualReferences(Stream.of(visualReferences).map(c -> VisualReferenceInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCanaryDryRunRequest build() {
            return new StartCanaryDryRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
