/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCanaryRunsRequest extends SyntheticsRequest implements
        ToCopyableBuilder<GetCanaryRunsRequest.Builder, GetCanaryRunsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetCanaryRunsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCanaryRunsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCanaryRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DryRunId").getter(getter(GetCanaryRunsRequest::dryRunId)).setter(setter(Builder::dryRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunId").build()).build();

    private static final SdkField<String> RUN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunType").getter(getter(GetCanaryRunsRequest::runTypeAsString)).setter(setter(Builder::runType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, DRY_RUN_ID_FIELD, RUN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String nextToken;

    private final Integer maxResults;

    private final String dryRunId;

    private final String runType;

    private GetCanaryRunsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.dryRunId = builder.dryRunId;
        this.runType = builder.runType;
    }

    /**
     * <p>
     * The name of the canary that you want to see runs for.
     * </p>
     * 
     * @return The name of the canary that you want to see runs for.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>GetCanaryRuns</code> operation to retrieve the next set of results.
     * </p>
     * <note>
     * <p>
     * When auto retry is enabled for the canary, the first subsequent retry is suffixed with *1 indicating its the
     * first retry and the next subsequent try is suffixed with *2.
     * </p>
     * </note>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>GetCanaryRuns</code> operation to retrieve the next set of results.</p> <note>
     *         <p>
     *         When auto retry is enabled for the canary, the first subsequent retry is suffixed with *1 indicating its
     *         the first retry and the next subsequent try is suffixed with *2.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify this parameter to limit how many runs are returned each time you use the <code>GetCanaryRuns</code>
     * operation. If you omit this parameter, the default of 100 is used.
     * </p>
     * 
     * @return Specify this parameter to limit how many runs are returned each time you use the
     *         <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve information
     * about the dry run.
     * </p>
     * 
     * @return The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve
     *         information about the dry run.
     */
    public final String dryRunId() {
        return dryRunId;
    }

    /**
     * <ul>
     * <li>
     * <p>
     * When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
     * </p>
     * </li>
     * <li>
     * <p>
     * When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runType} will
     * return {@link RunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runTypeAsString}.
     * </p>
     * 
     * @return <li>
     *         <p>
     *         When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
     *         </p>
     *         </li> <li>
     *         <p>
     *         When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
     *         </p>
     *         </li> <li>
     *         <p>
     *         When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
     *         </p>
     *         </li> <li>
     *         <p>
     *         When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
     *         </p>
     *         </li>
     * @see RunType
     */
    public final RunType runType() {
        return RunType.fromValue(runType);
    }

    /**
     * <ul>
     * <li>
     * <p>
     * When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
     * </p>
     * </li>
     * <li>
     * <p>
     * When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runType} will
     * return {@link RunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runTypeAsString}.
     * </p>
     * 
     * @return <li>
     *         <p>
     *         When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
     *         </p>
     *         </li> <li>
     *         <p>
     *         When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
     *         </p>
     *         </li> <li>
     *         <p>
     *         When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
     *         </p>
     *         </li> <li>
     *         <p>
     *         When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
     *         </p>
     *         </li>
     * @see RunType
     */
    public final String runTypeAsString() {
        return runType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(dryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(runTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCanaryRunsRequest)) {
            return false;
        }
        GetCanaryRunsRequest other = (GetCanaryRunsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(dryRunId(), other.dryRunId())
                && Objects.equals(runTypeAsString(), other.runTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCanaryRunsRequest").add("Name", name()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("DryRunId", dryRunId()).add("RunType", runTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "DryRunId":
            return Optional.ofNullable(clazz.cast(dryRunId()));
        case "RunType":
            return Optional.ofNullable(clazz.cast(runTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRunId", DRY_RUN_ID_FIELD);
        map.put("RunType", RUN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCanaryRunsRequest, T> g) {
        return obj -> g.apply((GetCanaryRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SyntheticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCanaryRunsRequest> {
        /**
         * <p>
         * The name of the canary that you want to see runs for.
         * </p>
         * 
         * @param name
         *        The name of the canary that you want to see runs for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>GetCanaryRuns</code> operation to retrieve the next set of results.
         * </p>
         * <note>
         * <p>
         * When auto retry is enabled for the canary, the first subsequent retry is suffixed with *1 indicating its the
         * first retry and the next subsequent try is suffixed with *2.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>GetCanaryRuns</code> operation to retrieve the next set of results.</p> <note>
         *        <p>
         *        When auto retry is enabled for the canary, the first subsequent retry is suffixed with *1 indicating
         *        its the first retry and the next subsequent try is suffixed with *2.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify this parameter to limit how many runs are returned each time you use the <code>GetCanaryRuns</code>
         * operation. If you omit this parameter, the default of 100 is used.
         * </p>
         * 
         * @param maxResults
         *        Specify this parameter to limit how many runs are returned each time you use the
         *        <code>GetCanaryRuns</code> operation. If you omit this parameter, the default of 100 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve information
         * about the dry run.
         * </p>
         * 
         * @param dryRunId
         *        The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve
         *        information about the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunId(String dryRunId);

        /**
         * <ul>
         * <li>
         * <p>
         * When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
         * </p>
         * </li>
         * <li>
         * <p>
         * When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
         * </p>
         * </li>
         * </ul>
         * 
         * @param runType
         *        <li>
         *        <p>
         *        When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
         *        </p>
         *        </li> <li>
         *        <p>
         *        When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
         *        </p>
         *        </li> <li>
         *        <p>
         *        When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
         *        </p>
         *        </li> <li>
         *        <p>
         *        When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
         *        </p>
         *        </li>
         * @see RunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunType
         */
        Builder runType(String runType);

        /**
         * <ul>
         * <li>
         * <p>
         * When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
         * </p>
         * </li>
         * <li>
         * <p>
         * When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
         * </p>
         * </li>
         * </ul>
         * 
         * @param runType
         *        <li>
         *        <p>
         *        When you provide <code>RunType=CANARY_RUN</code> and <code>dryRunId</code>, you will get an exception
         *        </p>
         *        </li> <li>
         *        <p>
         *        When a value is not provided for <code>RunType</code>, the default value is <code>CANARY_RUN</code>
         *        </p>
         *        </li> <li>
         *        <p>
         *        When <code>CANARY_RUN</code> is provided, all canary runs excluding dry runs are returned
         *        </p>
         *        </li> <li>
         *        <p>
         *        When <code>DRY_RUN</code> is provided, all dry runs excluding canary runs are returned
         *        </p>
         *        </li>
         * @see RunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunType
         */
        Builder runType(RunType runType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SyntheticsRequest.BuilderImpl implements Builder {
        private String name;

        private String nextToken;

        private Integer maxResults;

        private String dryRunId;

        private String runType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCanaryRunsRequest model) {
            super(model);
            name(model.name);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            dryRunId(model.dryRunId);
            runType(model.runType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDryRunId() {
            return dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        public final String getRunType() {
            return runType;
        }

        public final void setRunType(String runType) {
            this.runType = runType;
        }

        @Override
        public final Builder runType(String runType) {
            this.runType = runType;
            return this;
        }

        @Override
        public final Builder runType(RunType runType) {
            this.runType(runType == null ? null : runType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCanaryRunsRequest build() {
            return new GetCanaryRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
