/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a dependency for a canary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dependency implements SdkPojo, Serializable, ToCopyableBuilder<Dependency.Builder, Dependency> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Dependency::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Reference").getter(getter(Dependency::reference)).setter(setter(Builder::reference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String reference;

    private Dependency(BuilderImpl builder) {
        this.type = builder.type;
        this.reference = builder.reference;
    }

    /**
     * <p>
     * The type of dependency. Valid value is <code>LambdaLayer</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DependencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of dependency. Valid value is <code>LambdaLayer</code>.
     * @see DependencyType
     */
    public final DependencyType type() {
        return DependencyType.fromValue(type);
    }

    /**
     * <p>
     * The type of dependency. Valid value is <code>LambdaLayer</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DependencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of dependency. Valid value is <code>LambdaLayer</code>.
     * @see DependencyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The dependency reference. For Lambda layers, this is the ARN of the Lambda layer. For more information about
     * Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/api/API_Layer.html">Lambda</a>.
     * </p>
     * 
     * @return The dependency reference. For Lambda layers, this is the ARN of the Lambda layer. For more information
     *         about Lambda ARN format, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/api/API_Layer.html">Lambda</a>.
     */
    public final String reference() {
        return reference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(reference(), other.reference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dependency").add("Type", typeAsString()).add("Reference", reference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Reference":
            return Optional.ofNullable(clazz.cast(reference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Reference", REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dependency, T> g) {
        return obj -> g.apply((Dependency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dependency> {
        /**
         * <p>
         * The type of dependency. Valid value is <code>LambdaLayer</code>.
         * </p>
         * 
         * @param type
         *        The type of dependency. Valid value is <code>LambdaLayer</code>.
         * @see DependencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DependencyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of dependency. Valid value is <code>LambdaLayer</code>.
         * </p>
         * 
         * @param type
         *        The type of dependency. Valid value is <code>LambdaLayer</code>.
         * @see DependencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DependencyType
         */
        Builder type(DependencyType type);

        /**
         * <p>
         * The dependency reference. For Lambda layers, this is the ARN of the Lambda layer. For more information about
         * Lambda ARN format, see <a href="https://docs.aws.amazon.com/lambda/latest/api/API_Layer.html">Lambda</a>.
         * </p>
         * 
         * @param reference
         *        The dependency reference. For Lambda layers, this is the ARN of the Lambda layer. For more information
         *        about Lambda ARN format, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/api/API_Layer.html">Lambda</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(String reference);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String reference;

        private BuilderImpl() {
        }

        private BuilderImpl(Dependency model) {
            type(model.type);
            reference(model.reference);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DependencyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getReference() {
            return reference;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        @Override
        public final Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public Dependency build() {
            return new Dependency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
