/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How long, in seconds, for the canary to continue making regular runs according to the schedule in the
 * <code>Expression</code> value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryScheduleOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryScheduleOutput.Builder, CanaryScheduleOutput> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(CanaryScheduleOutput::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<Long> DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationInSeconds").getter(getter(CanaryScheduleOutput::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<RetryConfigOutput> RETRY_CONFIG_FIELD = SdkField
            .<RetryConfigOutput> builder(MarshallingType.SDK_POJO).memberName("RetryConfig")
            .getter(getter(CanaryScheduleOutput::retryConfig)).setter(setter(Builder::retryConfig))
            .constructor(RetryConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            DURATION_IN_SECONDS_FIELD, RETRY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final Long durationInSeconds;

    private final RetryConfigOutput retryConfig;

    private CanaryScheduleOutput(BuilderImpl builder) {
        this.expression = builder.expression;
        this.durationInSeconds = builder.durationInSeconds;
        this.retryConfig = builder.retryConfig;
    }

    /**
     * <p>
     * A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.
     * </p>
     * <p>
     * For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be
     * <code>minute</code>, <code>minutes</code>, or <code>hour</code>.
     * </p>
     * <p>
     * For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it
     * once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between
     * <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
     * </p>
     * <p>
     * Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to
     * run only once when it is started.
     * </p>
     * <p>
     * Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax for cron
     * expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">
     * Scheduling canary runs using cron</a>.
     * </p>
     * 
     * @return A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to
     *         run.</p>
     *         <p>
     *         For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be
     *         <code>minute</code>, <code>minutes</code>, or <code>hour</code>.
     *         </p>
     *         <p>
     *         For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code>
     *         runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a
     *         frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
     *         </p>
     *         <p>
     *         Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the
     *         canary to run only once when it is started.
     *         </p>
     *         <p>
     *         Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax
     *         for cron expressions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"
     *         > Scheduling canary runs using cron</a>.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * How long, in seconds, for the canary to continue making regular runs after it was created. The runs are performed
     * according to the schedule in the <code>Expression</code> value.
     * </p>
     * 
     * @return How long, in seconds, for the canary to continue making regular runs after it was created. The runs are
     *         performed according to the schedule in the <code>Expression</code> value.
     */
    public final Long durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * A structure that contains the retry configuration for a canary
     * </p>
     * 
     * @return A structure that contains the retry configuration for a canary
     */
    public final RetryConfigOutput retryConfig() {
        return retryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(retryConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryScheduleOutput)) {
            return false;
        }
        CanaryScheduleOutput other = (CanaryScheduleOutput) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(retryConfig(), other.retryConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryScheduleOutput").add("Expression", expression())
                .add("DurationInSeconds", durationInSeconds()).add("RetryConfig", retryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "RetryConfig":
            return Optional.ofNullable(clazz.cast(retryConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("RetryConfig", RETRY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryScheduleOutput, T> g) {
        return obj -> g.apply((CanaryScheduleOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryScheduleOutput> {
        /**
         * <p>
         * A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is to run.
         * </p>
         * <p>
         * For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be
         * <code>minute</code>, <code>minutes</code>, or <code>hour</code>.
         * </p>
         * <p>
         * For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it
         * once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency
         * between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
         * </p>
         * <p>
         * Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary
         * to run only once when it is started.
         * </p>
         * <p>
         * Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the syntax for
         * cron expressions, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">
         * Scheduling canary runs using cron</a>.
         * </p>
         * 
         * @param expression
         *        A <code>rate</code> expression or a <code>cron</code> expression that defines how often the canary is
         *        to run.</p>
         *        <p>
         *        For a rate expression, The syntax is <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be
         *        <code>minute</code>, <code>minutes</code>, or <code>hour</code>.
         *        </p>
         *        <p>
         *        For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code>
         *        runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify
         *        a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
         *        </p>
         *        <p>
         *        Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the
         *        canary to run only once when it is started.
         *        </p>
         *        <p>
         *        Use <code>cron(<i>expression</i>)</code> to specify a cron expression. For information about the
         *        syntax for cron expressions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html"
         *        > Scheduling canary runs using cron</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * How long, in seconds, for the canary to continue making regular runs after it was created. The runs are
         * performed according to the schedule in the <code>Expression</code> value.
         * </p>
         * 
         * @param durationInSeconds
         *        How long, in seconds, for the canary to continue making regular runs after it was created. The runs
         *        are performed according to the schedule in the <code>Expression</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Long durationInSeconds);

        /**
         * <p>
         * A structure that contains the retry configuration for a canary
         * </p>
         * 
         * @param retryConfig
         *        A structure that contains the retry configuration for a canary
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryConfig(RetryConfigOutput retryConfig);

        /**
         * <p>
         * A structure that contains the retry configuration for a canary
         * </p>
         * This is a convenience method that creates an instance of the {@link RetryConfigOutput.Builder} avoiding the
         * need to create one manually via {@link RetryConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryConfigOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #retryConfig(RetryConfigOutput)}.
         * 
         * @param retryConfig
         *        a consumer that will call methods on {@link RetryConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryConfig(RetryConfigOutput)
         */
        default Builder retryConfig(Consumer<RetryConfigOutput.Builder> retryConfig) {
            return retryConfig(RetryConfigOutput.builder().applyMutation(retryConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private Long durationInSeconds;

        private RetryConfigOutput retryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryScheduleOutput model) {
            expression(model.expression);
            durationInSeconds(model.durationInSeconds);
            retryConfig(model.retryConfig);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Long getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final RetryConfigOutput.Builder getRetryConfig() {
            return retryConfig != null ? retryConfig.toBuilder() : null;
        }

        public final void setRetryConfig(RetryConfigOutput.BuilderImpl retryConfig) {
            this.retryConfig = retryConfig != null ? retryConfig.build() : null;
        }

        @Override
        public final Builder retryConfig(RetryConfigOutput retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Override
        public CanaryScheduleOutput build() {
            return new CanaryScheduleOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
