/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the start and end times of a single canary run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRunTimeline implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryRunTimeline.Builder, CanaryRunTimeline> {
    private static final SdkField<Instant> STARTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Started").getter(getter(CanaryRunTimeline::started)).setter(setter(Builder::started))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Started").build()).build();

    private static final SdkField<Instant> COMPLETED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Completed").getter(getter(CanaryRunTimeline::completed)).setter(setter(Builder::completed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()).build();

    private static final SdkField<Instant> METRIC_TIMESTAMP_FOR_RUN_AND_RETRIES_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("MetricTimestampForRunAndRetries")
            .getter(getter(CanaryRunTimeline::metricTimestampForRunAndRetries))
            .setter(setter(Builder::metricTimestampForRunAndRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricTimestampForRunAndRetries")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTED_FIELD,
            COMPLETED_FIELD, METRIC_TIMESTAMP_FOR_RUN_AND_RETRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant started;

    private final Instant completed;

    private final Instant metricTimestampForRunAndRetries;

    private CanaryRunTimeline(BuilderImpl builder) {
        this.started = builder.started;
        this.completed = builder.completed;
        this.metricTimestampForRunAndRetries = builder.metricTimestampForRunAndRetries;
    }

    /**
     * <p>
     * The start time of the run.
     * </p>
     * 
     * @return The start time of the run.
     */
    public final Instant started() {
        return started;
    }

    /**
     * <p>
     * The end time of the run.
     * </p>
     * 
     * @return The end time of the run.
     */
    public final Instant completed() {
        return completed;
    }

    /**
     * <p>
     * The time at which the metrics will be generated for this run or retries.
     * </p>
     * 
     * @return The time at which the metrics will be generated for this run or retries.
     */
    public final Instant metricTimestampForRunAndRetries() {
        return metricTimestampForRunAndRetries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(completed());
        hashCode = 31 * hashCode + Objects.hashCode(metricTimestampForRunAndRetries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunTimeline)) {
            return false;
        }
        CanaryRunTimeline other = (CanaryRunTimeline) obj;
        return Objects.equals(started(), other.started()) && Objects.equals(completed(), other.completed())
                && Objects.equals(metricTimestampForRunAndRetries(), other.metricTimestampForRunAndRetries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryRunTimeline").add("Started", started()).add("Completed", completed())
                .add("MetricTimestampForRunAndRetries", metricTimestampForRunAndRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Started":
            return Optional.ofNullable(clazz.cast(started()));
        case "Completed":
            return Optional.ofNullable(clazz.cast(completed()));
        case "MetricTimestampForRunAndRetries":
            return Optional.ofNullable(clazz.cast(metricTimestampForRunAndRetries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Started", STARTED_FIELD);
        map.put("Completed", COMPLETED_FIELD);
        map.put("MetricTimestampForRunAndRetries", METRIC_TIMESTAMP_FOR_RUN_AND_RETRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunTimeline, T> g) {
        return obj -> g.apply((CanaryRunTimeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRunTimeline> {
        /**
         * <p>
         * The start time of the run.
         * </p>
         * 
         * @param started
         *        The start time of the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The end time of the run.
         * </p>
         * 
         * @param completed
         *        The end time of the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completed(Instant completed);

        /**
         * <p>
         * The time at which the metrics will be generated for this run or retries.
         * </p>
         * 
         * @param metricTimestampForRunAndRetries
         *        The time at which the metrics will be generated for this run or retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTimestampForRunAndRetries(Instant metricTimestampForRunAndRetries);
    }

    static final class BuilderImpl implements Builder {
        private Instant started;

        private Instant completed;

        private Instant metricTimestampForRunAndRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunTimeline model) {
            started(model.started);
            completed(model.completed);
            metricTimestampForRunAndRetries(model.metricTimestampForRunAndRetries);
        }

        public final Instant getStarted() {
            return started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getCompleted() {
            return completed;
        }

        public final void setCompleted(Instant completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(Instant completed) {
            this.completed = completed;
            return this;
        }

        public final Instant getMetricTimestampForRunAndRetries() {
            return metricTimestampForRunAndRetries;
        }

        public final void setMetricTimestampForRunAndRetries(Instant metricTimestampForRunAndRetries) {
            this.metricTimestampForRunAndRetries = metricTimestampForRunAndRetries;
        }

        @Override
        public final Builder metricTimestampForRunAndRetries(Instant metricTimestampForRunAndRetries) {
            this.metricTimestampForRunAndRetries = metricTimestampForRunAndRetries;
            return this;
        }

        @Override
        public CanaryRunTimeline build() {
            return new CanaryRunTimeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
