/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.synthetics.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryRunConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryRunConfigInput> {
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInSeconds").getter(CanaryRunConfigInput.getter(CanaryRunConfigInput::timeoutInSeconds)).setter(CanaryRunConfigInput.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()}).build();
    private static final SdkField<Integer> MEMORY_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemoryInMB").getter(CanaryRunConfigInput.getter(CanaryRunConfigInput::memoryInMB)).setter(CanaryRunConfigInput.setter(Builder::memoryInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInMB").build()}).build();
    private static final SdkField<Boolean> ACTIVE_TRACING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ActiveTracing").getter(CanaryRunConfigInput.getter(CanaryRunConfigInput::activeTracing)).setter(CanaryRunConfigInput.setter(Builder::activeTracing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTracing").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EnvironmentVariables").getter(CanaryRunConfigInput.getter(CanaryRunConfigInput::environmentVariables)).setter(CanaryRunConfigInput.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD, MEMORY_IN_MB_FIELD, ACTIVE_TRACING_FIELD, ENVIRONMENT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanaryRunConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutInSeconds;
    private final Integer memoryInMB;
    private final Boolean activeTracing;
    private final Map<String, String> environmentVariables;

    private CanaryRunConfigInput(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.memoryInMB = builder.memoryInMB;
        this.activeTracing = builder.activeTracing;
        this.environmentVariables = builder.environmentVariables;
    }

    public final Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public final Integer memoryInMB() {
        return this.memoryInMB;
    }

    public final Boolean activeTracing() {
        return this.activeTracing;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeTracing());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunConfigInput)) {
            return false;
        }
        CanaryRunConfigInput other = (CanaryRunConfigInput)obj;
        return Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.memoryInMB(), other.memoryInMB()) && Objects.equals(this.activeTracing(), other.activeTracing()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryRunConfigInput").add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("MemoryInMB", (Object)this.memoryInMB()).add("ActiveTracing", (Object)this.activeTracing()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "MemoryInMB": {
                return Optional.ofNullable(clazz.cast(this.memoryInMB()));
            }
            case "ActiveTracing": {
                return Optional.ofNullable(clazz.cast(this.activeTracing()));
            }
            case "EnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TimeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("MemoryInMB", MEMORY_IN_MB_FIELD);
        map.put("ActiveTracing", ACTIVE_TRACING_FIELD);
        map.put("EnvironmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunConfigInput, T> g) {
        return obj -> g.apply((CanaryRunConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutInSeconds;
        private Integer memoryInMB;
        private Boolean activeTracing;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunConfigInput model) {
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.memoryInMB(model.memoryInMB);
            this.activeTracing(model.activeTracing);
            this.environmentVariables(model.environmentVariables);
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final Integer getMemoryInMB() {
            return this.memoryInMB;
        }

        public final void setMemoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
        }

        @Override
        public final Builder memoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public final Boolean getActiveTracing() {
            return this.activeTracing;
        }

        public final void setActiveTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
        }

        @Override
        public final Builder activeTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public CanaryRunConfigInput build() {
            return new CanaryRunConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryRunConfigInput> {
        public Builder timeoutInSeconds(Integer var1);

        public Builder memoryInMB(Integer var1);

        public Builder activeTracing(Boolean var1);

        public Builder environmentVariables(Map<String, String> var1);
    }
}

